/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SegmentInsertActionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TaskActionTestKit actionTestKit = new TaskActionTestKit();
    private static final String DATA_SOURCE = "none";
    private static final Interval INTERVAL = Intervals.of((String)"2020/2020T01");
    private static final String PARTY_YEAR = "1999";
    private static final String THE_DISTANT_FUTURE = "3000";
    private static final DataSegment SEGMENT1 = new DataSegment("none", INTERVAL, "1999", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 1024L);
    private static final DataSegment SEGMENT2 = new DataSegment("none", INTERVAL, "1999", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 1024L);
    private static final DataSegment SEGMENT3 = new DataSegment("none", INTERVAL, "3000", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 1024L);

    private LockResult acquireTimeChunkLock(TaskLockType lockType, Task task, Interval interval, long timeoutMs) throws InterruptedException {
        return this.actionTestKit.getTaskLockbox().lock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null), timeoutMs);
    }

    @Test
    public void testSimple() throws Exception {
        NoopTask task = NoopTask.create();
        SegmentInsertAction action = new SegmentInsertAction((Set)ImmutableSet.of((Object)SEGMENT1, (Object)SEGMENT2));
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        this.actionTestKit.getTaskLockbox().doInCriticalSection((Task)task, Collections.singletonList(INTERVAL), CriticalAction.builder().onValidLocks(() -> this.lambda$testSimple$0(action, (Task)task)).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
        Assertions.assertThat((Iterable)this.actionTestKit.getMetadataStorageCoordinator().retrieveUsedSegmentsForInterval(DATA_SOURCE, INTERVAL, Segments.ONLY_VISIBLE)).containsExactlyInAnyOrder((Object[])new DataSegment[]{SEGMENT1, SEGMENT2});
    }

    @Test
    public void testFailBadVersion() throws Exception {
        NoopTask task = NoopTask.create();
        SegmentInsertAction action = new SegmentInsertAction((Set)ImmutableSet.of((Object)SEGMENT3));
        this.actionTestKit.getTaskLockbox().add((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, INTERVAL, 5000L);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"are not covered by locks"));
        Set segments = (Set)this.actionTestKit.getTaskLockbox().doInCriticalSection((Task)task, Collections.singletonList(INTERVAL), CriticalAction.builder().onValidLocks(() -> this.lambda$testFailBadVersion$2(action, (Task)task)).onInvalidLocks(() -> {
            Assert.fail();
            return null;
        }).build());
        Assert.assertEquals((Object)ImmutableSet.of((Object)SEGMENT3), (Object)segments);
    }

    private /* synthetic */ Set lambda$testFailBadVersion$2(SegmentInsertAction action, Task task) throws Exception {
        return action.perform(task, this.actionTestKit.getTaskActionToolbox());
    }

    private /* synthetic */ Object lambda$testSimple$0(SegmentInsertAction action, Task task) throws Exception {
        return action.perform(task, this.actionTestKit.getTaskActionToolbox());
    }
}

