/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.UpdateLocationAction;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UpdateLocationActionTest {
    @Test
    public void testFlow() throws UnknownHostException {
        InetAddress hostName = InetAddress.getLocalHost();
        TaskLocation myLocation = TaskLocation.create((String)hostName.getHostAddress(), (int)1, (int)2);
        UpdateLocationAction action = new UpdateLocationAction(myLocation);
        NoopTask task = NoopTask.create();
        TaskActionToolbox toolbox = (TaskActionToolbox)Mockito.mock(TaskActionToolbox.class);
        TaskRunner runner = (TaskRunner)Mockito.mock(TaskRunner.class);
        Mockito.when((Object)toolbox.getTaskRunner()).thenReturn((Object)Optional.of((Object)runner));
        action.perform((Task)task, toolbox);
        ((TaskRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.times((int)1))).updateLocation((Task)ArgumentMatchers.eq((Object)task), (TaskLocation)ArgumentMatchers.eq((Object)myLocation));
    }

    @Test
    public void testWithNoTaskRunner() throws UnknownHostException {
        InetAddress hostName = InetAddress.getLocalHost();
        TaskLocation myLocation = TaskLocation.create((String)hostName.getHostAddress(), (int)1, (int)2);
        UpdateLocationAction action = new UpdateLocationAction(myLocation);
        NoopTask task = NoopTask.create();
        TaskActionToolbox toolbox = (TaskActionToolbox)Mockito.mock(TaskActionToolbox.class);
        TaskRunner runner = (TaskRunner)Mockito.mock(TaskRunner.class);
        Mockito.when((Object)toolbox.getTaskRunner()).thenReturn((Object)Optional.absent());
        action.perform((Task)task, toolbox);
        ((TaskRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.never())).updateStatus((Task)ArgumentMatchers.any(), (TaskStatus)ArgumentMatchers.any());
    }
}

