/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.base.Optional;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.UpdateStatusAction;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class UpdateStatusActionTest {
    @Test
    public void testActionCallsTaskRunner() {
        UpdateStatusAction action = new UpdateStatusAction("successful");
        NoopTask task = NoopTask.create();
        TaskActionToolbox toolbox = (TaskActionToolbox)Mockito.mock(TaskActionToolbox.class);
        TaskRunner runner = (TaskRunner)Mockito.mock(TaskRunner.class);
        Mockito.when((Object)toolbox.getTaskRunner()).thenReturn((Object)Optional.of((Object)runner));
        action.perform((Task)task, toolbox);
        ((TaskRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.times((int)1))).updateStatus((Task)ArgumentMatchers.eq((Object)task), (TaskStatus)ArgumentMatchers.eq((Object)TaskStatus.success((String)task.getId())));
    }

    @Test
    public void testFailureScenario() {
        UpdateStatusAction action = new UpdateStatusAction("failure");
        NoopTask task = NoopTask.create();
        TaskActionToolbox toolbox = (TaskActionToolbox)Mockito.mock(TaskActionToolbox.class);
        TaskRunner runner = (TaskRunner)Mockito.mock(TaskRunner.class);
        Mockito.when((Object)toolbox.getTaskRunner()).thenReturn((Object)Optional.of((Object)runner));
        action.perform((Task)task, toolbox);
        ((TaskRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.times((int)1))).updateStatus((Task)ArgumentMatchers.eq((Object)task), (TaskStatus)ArgumentMatchers.eq((Object)TaskStatus.failure((String)task.getId(), (String)"Error with task")));
    }

    @Test
    public void testNoTaskRunner() {
        UpdateStatusAction action = new UpdateStatusAction("successful");
        NoopTask task = NoopTask.create();
        TaskActionToolbox toolbox = (TaskActionToolbox)Mockito.mock(TaskActionToolbox.class);
        TaskRunner runner = (TaskRunner)Mockito.mock(TaskRunner.class);
        Mockito.when((Object)toolbox.getTaskRunner()).thenReturn((Object)Optional.absent());
        action.perform((Task)task, toolbox);
        ((TaskRunner)Mockito.verify((Object)runner, (VerificationMode)Mockito.never())).updateStatus((Task)ArgumentMatchers.any(), (TaskStatus)ArgumentMatchers.any());
    }
}

