/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.server.DruidNode;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractTaskTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSetupAndCleanupIsCalledWtihParameter() throws Exception {
        TaskToolbox toolbox = (TaskToolbox)Mockito.mock(TaskToolbox.class);
        Mockito.when((Object)toolbox.getAttemptId()).thenReturn((Object)"1");
        DruidNode node = new DruidNode("foo", "foo", false, Integer.valueOf(1), Integer.valueOf(2), true, true);
        Mockito.when((Object)toolbox.getTaskExecutorNode()).thenReturn((Object)node);
        TaskLogPusher pusher = (TaskLogPusher)Mockito.mock(TaskLogPusher.class);
        Mockito.when((Object)toolbox.getTaskLogPusher()).thenReturn((Object)pusher);
        TaskConfig config = (TaskConfig)Mockito.mock(TaskConfig.class);
        Mockito.when((Object)config.isEncapsulatedTask()).thenReturn((Object)true);
        final File folder = this.temporaryFolder.newFolder();
        Mockito.when((Object)config.getTaskDir((String)ArgumentMatchers.eq((Object)"myID"))).thenReturn((Object)folder);
        Mockito.when((Object)toolbox.getConfig()).thenReturn((Object)config);
        TaskActionClient taskActionClient = (TaskActionClient)Mockito.mock(TaskActionClient.class);
        Mockito.when((Object)taskActionClient.submit((TaskAction)ArgumentMatchers.any())).thenReturn(TaskConfig.class);
        Mockito.when((Object)toolbox.getTaskActionClient()).thenReturn((Object)taskActionClient);
        NoopTask task = new NoopTask("myID", null, null, 1L, 0L, null, null, null){

            @Nullable
            public String setup(TaskToolbox toolbox) throws Exception {
                String result = super.setup(toolbox);
                File attemptDir = Paths.get(folder.getAbsolutePath(), "attempt", toolbox.getAttemptId()).toFile();
                File reportsDir = new File(attemptDir, "report.json");
                FileUtils.write((File)reportsDir, (CharSequence)"foo", (Charset)StandardCharsets.UTF_8);
                return result;
            }
        };
        task.run(toolbox);
        ((TaskActionClient)Mockito.verify((Object)taskActionClient, (VerificationMode)Mockito.times((int)3))).submit((TaskAction)ArgumentMatchers.any());
        ((TaskLogPusher)Mockito.verify((Object)pusher, (VerificationMode)Mockito.times((int)1))).pushTaskReports((String)ArgumentMatchers.eq((Object)"myID"), (File)ArgumentMatchers.any());
    }

    @Test
    public void testWithNoEncapsulatedTask() throws Exception {
        TaskToolbox toolbox = (TaskToolbox)Mockito.mock(TaskToolbox.class);
        Mockito.when((Object)toolbox.getAttemptId()).thenReturn((Object)"1");
        DruidNode node = new DruidNode("foo", "foo", false, Integer.valueOf(1), Integer.valueOf(2), true, true);
        Mockito.when((Object)toolbox.getTaskExecutorNode()).thenReturn((Object)node);
        TaskLogPusher pusher = (TaskLogPusher)Mockito.mock(TaskLogPusher.class);
        Mockito.when((Object)toolbox.getTaskLogPusher()).thenReturn((Object)pusher);
        TaskConfig config = (TaskConfig)Mockito.mock(TaskConfig.class);
        Mockito.when((Object)config.isEncapsulatedTask()).thenReturn((Object)false);
        final File folder = this.temporaryFolder.newFolder();
        Mockito.when((Object)config.getTaskDir((String)ArgumentMatchers.eq((Object)"myID"))).thenReturn((Object)folder);
        Mockito.when((Object)toolbox.getConfig()).thenReturn((Object)config);
        TaskActionClient taskActionClient = (TaskActionClient)Mockito.mock(TaskActionClient.class);
        Mockito.when((Object)taskActionClient.submit((TaskAction)ArgumentMatchers.any())).thenReturn(TaskConfig.class);
        Mockito.when((Object)toolbox.getTaskActionClient()).thenReturn((Object)taskActionClient);
        NoopTask task = new NoopTask("myID", null, null, 1L, 0L, null, null, null){

            @Nullable
            public String setup(TaskToolbox toolbox) throws Exception {
                String result = super.setup(toolbox);
                File attemptDir = Paths.get(folder.getAbsolutePath(), "attempt", toolbox.getAttemptId()).toFile();
                File reportsDir = new File(attemptDir, "report.json");
                FileUtils.write((File)reportsDir, (CharSequence)"foo", (Charset)StandardCharsets.UTF_8);
                return result;
            }
        };
        task.run(toolbox);
        ((TaskActionClient)Mockito.verify((Object)taskActionClient, (VerificationMode)Mockito.never())).submit((TaskAction)ArgumentMatchers.any());
        ((TaskLogPusher)Mockito.verify((Object)pusher, (VerificationMode)Mockito.never())).pushTaskReports((String)ArgumentMatchers.eq((Object)"myID"), (File)ArgumentMatchers.any());
    }

    @Test
    public void testBatchIOConfigAppend() {
        AbstractTask.IngestionMode ingestionMode = AbstractTask.IngestionMode.fromString((String)"APPEND");
        Assert.assertEquals((Object)AbstractTask.IngestionMode.APPEND, (Object)ingestionMode);
    }

    @Test
    public void testBatchIOConfigReplace() {
        AbstractTask.IngestionMode ingestionMode = AbstractTask.IngestionMode.fromString((String)"REPLACE");
        Assert.assertEquals((Object)AbstractTask.IngestionMode.REPLACE, (Object)ingestionMode);
    }

    @Test
    public void testBatchIOConfigOverwrite() {
        AbstractTask.IngestionMode ingestionMode = AbstractTask.IngestionMode.fromString((String)"REPLACE_LEGACY");
        Assert.assertEquals((Object)AbstractTask.IngestionMode.REPLACE_LEGACY, (Object)ingestionMode);
    }

    @Test
    public void testBatchIOConfigHadoop() {
        AbstractTask.IngestionMode ingestionMode = AbstractTask.IngestionMode.fromString((String)"HADOOP");
        Assert.assertEquals((Object)AbstractTask.IngestionMode.HADOOP, (Object)ingestionMode);
    }

    @Test
    public void testBatchIOConfigNone() {
        AbstractTask.IngestionMode ingestionMode = AbstractTask.IngestionMode.fromString((String)"NONE");
        Assert.assertEquals((Object)AbstractTask.IngestionMode.NONE, (Object)ingestionMode);
    }
}

