/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.BatchAppenderators;
import org.apache.druid.indexing.common.task.NoopTestTaskReportFileWriter;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorImpl;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderator;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class BatchAppenderatorsTest {
    @Test
    public void testLegacyOfflineAppenderator() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester("OPEN_SEGMENTS");){
            Assert.assertTrue((boolean)(tester.appenderator instanceof AppenderatorImpl));
            AppenderatorImpl appenderator = (AppenderatorImpl)tester.appenderator;
            Assert.assertTrue((boolean)appenderator.isOpenSegments());
        }
    }

    @Test
    public void testClosedSegmentsOfflineAppenderator() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester("CLOSED_SEGMENTS");){
            Assert.assertTrue((boolean)(tester.appenderator instanceof AppenderatorImpl));
            AppenderatorImpl appenderator = (AppenderatorImpl)tester.appenderator;
            Assert.assertFalse((boolean)appenderator.isOpenSegments());
        }
    }

    @Test
    public void testClosedSegmentsSinksOfflineAppenderator() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester("CLOSED_SEGMENTS_SINKS");){
            Assert.assertTrue((boolean)(tester.appenderator instanceof BatchAppenderator));
        }
    }

    private static class AppenderatorTester
    implements AutoCloseable {
        public static final String DATASOURCE = "foo";
        private final DataSchema schema;
        private final AppenderatorConfig tuningConfig;
        private final FireDepartmentMetrics metrics;
        private final ObjectMapper objectMapper;
        private final Appenderator appenderator;
        private final ServiceEmitter emitter;
        private final List<DataSegment> pushedSegments = new CopyOnWriteArrayList<DataSegment>();

        public AppenderatorTester(String batchMode) {
            this(100, 100L, null, false, (RowIngestionMeters)new SimpleRowIngestionMeters(), false, batchMode);
        }

        public AppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, @Nullable File basePersistDirectory, final boolean enablePushFailure, RowIngestionMeters rowIngestionMeters, boolean skipBytesInMemoryOverheadCheck, String batchMode) {
            this.objectMapper = new DefaultObjectMapper();
            this.objectMapper.registerSubtypes(new Class[]{LinearShardSpec.class});
            Map parserMap = (Map)this.objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), DimensionsSpec.EMPTY, null, null, null)), Map.class);
            this.schema = new DataSchema(DATASOURCE, null, null, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null, parserMap, this.objectMapper);
            this.tuningConfig = new TestIndexTuningConfig(TuningConfig.DEFAULT_APPENDABLE_INDEX, maxRowsInMemory, maxSizeInBytes == 0L ? this.getDefaultMaxBytesInMemory() : maxSizeInBytes, skipBytesInMemoryOverheadCheck, new IndexSpec(), 0, false, 0L, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), -1, basePersistDirectory == null ? AppenderatorTester.createNewBasePersistDirectory() : basePersistDirectory);
            this.metrics = new FireDepartmentMetrics();
            IndexIO indexIO = new IndexIO(this.objectMapper, () -> 0);
            IndexMergerV9 indexMerger = new IndexMergerV9(this.objectMapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
            this.emitter = new ServiceEmitter("test", "test", (Emitter)new NoopEmitter());
            this.emitter.start();
            EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
            DataSegmentPusher dataSegmentPusher = new DataSegmentPusher(){
                private boolean mustFail = true;

                @Deprecated
                public String getPathForHadoop(String dataSource) {
                    return this.getPathForHadoop();
                }

                public String getPathForHadoop() {
                    throw new UnsupportedOperationException();
                }

                public DataSegment push(File file, DataSegment segment, boolean useUniquePath) throws IOException {
                    if (enablePushFailure && this.mustFail) {
                        this.mustFail = false;
                        throw new IOException("Push failure test");
                    }
                    if (enablePushFailure) {
                        this.mustFail = true;
                    }
                    pushedSegments.add(segment);
                    return segment;
                }

                public Map<String, Object> makeLoadSpec(URI uri) {
                    throw new UnsupportedOperationException();
                }
            };
            switch (batchMode) {
                case "OPEN_SEGMENTS": {
                    this.appenderator = BatchAppenderators.newAppenderator((String)DATASOURCE, (AppenderatorsManager)new TestAppenderatorsManager(), (FireDepartmentMetrics)this.metrics, (TaskToolbox)AppenderatorTester.makeTaskToolbox(this.objectMapper, indexMerger, TaskConfig.BatchProcessingMode.OPEN_SEGMENTS), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (DataSegmentPusher)dataSegmentPusher, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)false);
                    break;
                }
                case "CLOSED_SEGMENTS": {
                    this.appenderator = BatchAppenderators.newAppenderator((String)DATASOURCE, (AppenderatorsManager)new TestAppenderatorsManager(), (FireDepartmentMetrics)this.metrics, (TaskToolbox)AppenderatorTester.makeTaskToolbox(this.objectMapper, indexMerger, TaskConfig.BatchProcessingMode.CLOSED_SEGMENTS), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (DataSegmentPusher)dataSegmentPusher, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)false);
                    break;
                }
                case "CLOSED_SEGMENTS_SINKS": {
                    this.appenderator = BatchAppenderators.newAppenderator((String)DATASOURCE, (AppenderatorsManager)new TestAppenderatorsManager(), (FireDepartmentMetrics)this.metrics, (TaskToolbox)AppenderatorTester.makeTaskToolbox(this.objectMapper, indexMerger, TaskConfig.BatchProcessingMode.CLOSED_SEGMENTS_SINKS), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (DataSegmentPusher)dataSegmentPusher, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized batchMode: " + batchMode);
                }
            }
        }

        private long getDefaultMaxBytesInMemory() {
            return Runtime.getRuntime().totalMemory() / 3L;
        }

        public DataSchema getSchema() {
            return this.schema;
        }

        public AppenderatorConfig getTuningConfig() {
            return this.tuningConfig;
        }

        public FireDepartmentMetrics getMetrics() {
            return this.metrics;
        }

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public Appenderator getAppenderator() {
            return this.appenderator;
        }

        public List<DataSegment> getPushedSegments() {
            return this.pushedSegments;
        }

        @Override
        public void close() throws Exception {
            this.appenderator.close();
            this.emitter.close();
            FileUtils.deleteDirectory((File)this.tuningConfig.getBasePersistDirectory());
        }

        private static File createNewBasePersistDirectory() {
            return FileUtils.createTempDir((String)"druid-batch-persist");
        }

        private static TaskToolbox makeTaskToolbox(ObjectMapper mapper, IndexMergerV9 indexMergerV9, TaskConfig.BatchProcessingMode mode) {
            return new TaskToolbox.Builder().config(new TaskConfig(null, null, null, null, null, false, null, null, null, false, false, mode.name(), null, false)).joinableFactory((JoinableFactory)NoopJoinableFactory.INSTANCE).jsonMapper(mapper).indexIO(new IndexIO(new ObjectMapper(), () -> 0)).indexMergerV9(indexMergerV9).taskReportFileWriter((TaskReportFileWriter)new NoopTestTaskReportFileWriter()).authorizerMapper(AuthTestUtils.TEST_AUTHORIZER_MAPPER).chatHandlerProvider((ChatHandlerProvider)new NoopChatHandlerProvider()).appenderatorsManager((AppenderatorsManager)new TestAppenderatorsManager()).taskLogPusher(null).attemptId("1").build();
        }

        static class TestIndexTuningConfig
        implements AppenderatorConfig {
            private final AppendableIndexSpec appendableIndexSpec;
            private final int maxRowsInMemory;
            private final long maxBytesInMemory;
            private final boolean skipBytesInMemoryOverheadCheck;
            private final int maxColumnsToMerge;
            private final PartitionsSpec partitionsSpec;
            private final IndexSpec indexSpec;
            private final File basePersistDirectory;
            private final int maxPendingPersists;
            private final boolean reportParseExceptions;
            private final long pushTimeout;
            private final IndexSpec indexSpecForIntermediatePersists;
            @Nullable
            private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

            public TestIndexTuningConfig(AppendableIndexSpec appendableIndexSpec, Integer maxRowsInMemory, Long maxBytesInMemory, Boolean skipBytesInMemoryOverheadCheck, IndexSpec indexSpec, Integer maxPendingPersists, Boolean reportParseExceptions, Long pushTimeout, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, Integer maxColumnsToMerge, File basePersistDirectory) {
                this.appendableIndexSpec = appendableIndexSpec;
                this.maxRowsInMemory = maxRowsInMemory;
                this.maxBytesInMemory = maxBytesInMemory;
                this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck;
                this.indexSpec = indexSpec;
                this.maxPendingPersists = maxPendingPersists;
                this.reportParseExceptions = reportParseExceptions;
                this.pushTimeout = pushTimeout;
                this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
                this.maxColumnsToMerge = maxColumnsToMerge;
                this.basePersistDirectory = basePersistDirectory;
                this.partitionsSpec = null;
                this.indexSpecForIntermediatePersists = this.indexSpec;
            }

            public TestIndexTuningConfig withBasePersistDirectory(File dir) {
                return this;
            }

            public AppendableIndexSpec getAppendableIndexSpec() {
                return this.appendableIndexSpec;
            }

            public int getMaxRowsInMemory() {
                return this.maxRowsInMemory;
            }

            public long getMaxBytesInMemory() {
                return this.maxBytesInMemory;
            }

            public boolean isSkipBytesInMemoryOverheadCheck() {
                return this.skipBytesInMemoryOverheadCheck;
            }

            @Nullable
            public PartitionsSpec getPartitionsSpec() {
                return this.partitionsSpec;
            }

            public IndexSpec getIndexSpec() {
                return this.indexSpec;
            }

            public IndexSpec getIndexSpecForIntermediatePersists() {
                return this.indexSpecForIntermediatePersists;
            }

            public int getMaxPendingPersists() {
                return this.maxPendingPersists;
            }

            public boolean isReportParseExceptions() {
                return this.reportParseExceptions;
            }

            @Nullable
            public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
                return this.segmentWriteOutMediumFactory;
            }

            public int getMaxColumnsToMerge() {
                return this.maxColumnsToMerge;
            }

            public File getBasePersistDirectory() {
                return this.basePersistDirectory;
            }

            public Period getIntermediatePersistPeriod() {
                return new Period(Integer.MAX_VALUE);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TestIndexTuningConfig that = (TestIndexTuningConfig)o;
                return Objects.equals(this.appendableIndexSpec, that.appendableIndexSpec) && this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.skipBytesInMemoryOverheadCheck == that.skipBytesInMemoryOverheadCheck && this.maxColumnsToMerge == that.maxColumnsToMerge && this.maxPendingPersists == that.maxPendingPersists && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory);
            }

            public int hashCode() {
                return Objects.hash(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.maxColumnsToMerge, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.basePersistDirectory, this.maxPendingPersists, this.reportParseExceptions, this.pushTimeout, this.segmentWriteOutMediumFactory);
            }

            public String toString() {
                return "IndexTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", skipBytesInMemoryOverheadCheck=" + this.skipBytesInMemoryOverheadCheck + ", maxColumnsToMerge=" + this.maxColumnsToMerge + ", partitionsSpec=" + this.partitionsSpec + ", indexSpec=" + this.indexSpec + ", indexSpecForIntermediatePersists=" + this.indexSpecForIntermediatePersists + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + '}';
            }
        }
    }
}

