/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.apache.druid.guice.GuiceInjectableValues;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class ClientCompactionTaskQuerySerdeTest {
    private static final RowIngestionMetersFactory ROW_INGESTION_METERS_FACTORY = new TestUtils().getRowIngestionMetersFactory();
    private static final CoordinatorClient COORDINATOR_CLIENT = new CoordinatorClient(null, null);
    private static final AppenderatorsManager APPENDERATORS_MANAGER = new TestAppenderatorsManager();

    @Test
    public void testClientCompactionTaskQueryToCompactionTask() throws IOException {
        ObjectMapper mapper = ClientCompactionTaskQuerySerdeTest.setupInjectablesInObjectMapper((ObjectMapper)new DefaultObjectMapper());
        ClientCompactionTaskQuery query = new ClientCompactionTaskQuery("id", "datasource", new ClientCompactionIOConfig(new ClientCompactionIntervalSpec(Intervals.of((String)"2019/2020"), "testSha256OfSortedSegmentIds"), Boolean.valueOf(true)), new ClientCompactionTaskQueryTuningConfig(null, null, Integer.valueOf(40000), Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), Integer.valueOf(10)), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(30000L)), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.AUTO), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2)), new ClientCompactionTaskGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true)), new ClientCompactionTaskDimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null)), (Map)ImmutableMap.of((Object)"key", (Object)"value"));
        byte[] json = mapper.writeValueAsBytes((Object)query);
        CompactionTask task = (CompactionTask)mapper.readValue(json, Task.class);
        Assert.assertEquals((Object)query.getId(), (Object)task.getId());
        Assert.assertEquals((Object)query.getDataSource(), (Object)task.getDataSource());
        Assert.assertTrue((boolean)(task.getIoConfig().getInputSpec() instanceof CompactionIntervalSpec));
        Assert.assertEquals((Object)query.getIoConfig().getInputSpec().getInterval(), (Object)((CompactionIntervalSpec)task.getIoConfig().getInputSpec()).getInterval());
        Assert.assertEquals((Object)query.getIoConfig().getInputSpec().getSha256OfSortedSegmentIds(), (Object)((CompactionIntervalSpec)task.getIoConfig().getInputSpec()).getSha256OfSortedSegmentIds());
        Assert.assertEquals((long)query.getTuningConfig().getMaxRowsInMemory().intValue(), (long)task.getTuningConfig().getMaxRowsInMemory());
        Assert.assertEquals((long)query.getTuningConfig().getMaxBytesInMemory(), (long)task.getTuningConfig().getMaxBytesInMemory());
        Assert.assertEquals((Object)query.getTuningConfig().getSplitHintSpec(), (Object)task.getTuningConfig().getSplitHintSpec());
        Assert.assertEquals((Object)query.getTuningConfig().getPartitionsSpec(), (Object)task.getTuningConfig().getPartitionsSpec());
        Assert.assertEquals((Object)query.getTuningConfig().getIndexSpec(), (Object)task.getTuningConfig().getIndexSpec());
        Assert.assertEquals((Object)query.getTuningConfig().getIndexSpecForIntermediatePersists(), (Object)task.getTuningConfig().getIndexSpecForIntermediatePersists());
        Assert.assertEquals((long)query.getTuningConfig().getPushTimeout(), (long)task.getTuningConfig().getPushTimeout());
        Assert.assertEquals((Object)query.getTuningConfig().getSegmentWriteOutMediumFactory(), (Object)task.getTuningConfig().getSegmentWriteOutMediumFactory());
        Assert.assertEquals((long)query.getTuningConfig().getMaxNumConcurrentSubTasks().intValue(), (long)task.getTuningConfig().getMaxNumConcurrentSubTasks());
        Assert.assertEquals((long)query.getTuningConfig().getMaxRetry().intValue(), (long)task.getTuningConfig().getMaxRetry());
        Assert.assertEquals((long)query.getTuningConfig().getTaskStatusCheckPeriodMs(), (long)task.getTuningConfig().getTaskStatusCheckPeriodMs());
        Assert.assertEquals((Object)query.getTuningConfig().getChatHandlerTimeout(), (Object)task.getTuningConfig().getChatHandlerTimeout());
        Assert.assertEquals((long)query.getTuningConfig().getMaxNumSegmentsToMerge().intValue(), (long)task.getTuningConfig().getMaxNumSegmentsToMerge());
        Assert.assertEquals((long)query.getTuningConfig().getTotalNumMergeTasks().intValue(), (long)task.getTuningConfig().getTotalNumMergeTasks());
        Assert.assertEquals((Object)query.getGranularitySpec(), (Object)task.getGranularitySpec());
        Assert.assertEquals((Object)query.getGranularitySpec().getQueryGranularity(), (Object)task.getGranularitySpec().getQueryGranularity());
        Assert.assertEquals((Object)query.getGranularitySpec().getSegmentGranularity(), (Object)task.getGranularitySpec().getSegmentGranularity());
        Assert.assertEquals((Object)query.getGranularitySpec().isRollup(), (Object)task.getGranularitySpec().isRollup());
        Assert.assertEquals((Object)query.getIoConfig().isDropExisting(), (Object)task.getIoConfig().isDropExisting());
        Assert.assertEquals((Object)query.getContext(), (Object)task.getContext());
        Assert.assertEquals((Object)query.getDimensionsSpec().getDimensions(), (Object)task.getDimensionsSpec().getDimensions());
        Assert.assertEquals((Object)query.getTransformSpec().getFilter(), (Object)task.getTransformSpec().getFilter());
        Assert.assertArrayEquals((Object[])query.getMetricsSpec(), (Object[])task.getMetricsSpec());
    }

    @Test
    public void testCompactionTaskToClientCompactionTaskQuery() throws IOException {
        ObjectMapper mapper = ClientCompactionTaskQuerySerdeTest.setupInjectablesInObjectMapper((ObjectMapper)new DefaultObjectMapper());
        CompactionTask.Builder builder = new CompactionTask.Builder("datasource", new SegmentCacheManagerFactory(mapper), new RetryPolicyFactory(new RetryPolicyConfig()));
        CompactionTask task = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(Intervals.of((String)"2019/2020"), "testSha256OfSortedSegmentIds"), Boolean.valueOf(true)).tuningConfig((TuningConfig)new ParallelIndexTuningConfig(null, null, (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), Integer.valueOf(40000), Long.valueOf(2000L), null, null, null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), Integer.valueOf(10)), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(30000L)), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.AUTO), Integer.valueOf(2), null, null, Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), null, null, null, Integer.valueOf(2), null, null)).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true))).dimensionsSpec(DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))).setDimensionExclusions((List)ImmutableList.of((Object)"__time", (Object)"val")).build()).metricsSpec(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).transformSpec(new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null))).build();
        ClientCompactionTaskQuery expected = new ClientCompactionTaskQuery(task.getId(), "datasource", new ClientCompactionIOConfig(new ClientCompactionIntervalSpec(Intervals.of((String)"2019/2020"), "testSha256OfSortedSegmentIds"), Boolean.valueOf(true)), new ClientCompactionTaskQueryTuningConfig(Integer.valueOf(100), (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), Integer.valueOf(40000), Long.valueOf(2000L), Long.valueOf(30000L), (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), Integer.valueOf(10)), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(30000L)), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.AUTO), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2)), new ClientCompactionTaskGranularitySpec(Granularities.DAY, Granularities.HOUR, Boolean.valueOf(true)), new ClientCompactionTaskDimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null)), new HashMap());
        byte[] json = mapper.writeValueAsBytes((Object)task);
        ClientCompactionTaskQuery actual = (ClientCompactionTaskQuery)mapper.readValue(json, ClientTaskQuery.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static ObjectMapper setupInjectablesInObjectMapper(ObjectMapper objectMapper) {
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        objectMapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, objectMapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, objectMapper.getDeserializationConfig().getAnnotationIntrospector()));
        GuiceInjectableValues injectableValues = new GuiceInjectableValues(GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
            binder.bind(ChatHandlerProvider.class).toInstance((Object)new NoopChatHandlerProvider());
            binder.bind(RowIngestionMetersFactory.class).toInstance((Object)ROW_INGESTION_METERS_FACTORY);
            binder.bind(CoordinatorClient.class).toInstance((Object)COORDINATOR_CLIENT);
            binder.bind(SegmentCacheManagerFactory.class).toInstance((Object)new SegmentCacheManagerFactory(objectMapper));
            binder.bind(AppenderatorsManager.class).toInstance((Object)APPENDERATORS_MANAGER);
            binder.bind(OverlordClient.class).toInstance((Object)new NoopOverlordClient());
        })));
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        objectMapper.registerSubtypes(new NamedType[]{new NamedType(ParallelIndexTuningConfig.class, "index_parallel")});
        return objectMapper;
    }
}

