/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.indexing.common.actions.LocalTaskActionClient;
import org.apache.druid.indexing.common.actions.SurrogateAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskAuditLogConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;

public class CountingLocalTaskActionClientForTest
implements TaskActionClient {
    private final ConcurrentHashMap<Class<? extends TaskAction>, AtomicInteger> actionCountMap = new ConcurrentHashMap();
    private final LocalTaskActionClient delegate;

    public CountingLocalTaskActionClientForTest(Task task, TaskStorage storage, TaskActionToolbox toolbox) {
        this.delegate = new LocalTaskActionClient(task, storage, toolbox, new TaskAuditLogConfig(false));
    }

    public <RetType> RetType submit(TaskAction<RetType> taskAction) {
        Object result = this.delegate.submit(taskAction);
        TaskAction actionKey = taskAction instanceof SurrogateAction ? ((SurrogateAction)taskAction).getTaskAction() : taskAction;
        this.actionCountMap.computeIfAbsent(actionKey.getClass(), k -> new AtomicInteger()).incrementAndGet();
        return (RetType)result;
    }

    public int getActionCount(Class<? extends TaskAction> actionClass) {
        AtomicInteger count = this.actionCountMap.get(actionClass);
        return count == null ? 0 : count.get();
    }
}

