/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IndexTaskSerdeTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setup() {
        MAPPER.registerSubtypes(new NamedType[]{new NamedType(IndexTask.IndexTuningConfig.class, "index")});
    }

    @Test
    public void testSerdeTuningConfigWithDynamicPartitionsSpec() throws IOException {
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(100), Long.valueOf(2000L), null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(2000L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(false), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), Integer.valueOf(1234), Long.valueOf(0L));
        IndexTaskSerdeTest.assertSerdeTuningConfig(tuningConfig);
    }

    @Test
    public void testSerdeTuningConfigWithHashedPartitionsSpec() throws IOException {
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(100), Long.valueOf(2000L), null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim1", (Object)"dim2")), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), null, Long.valueOf(-1L));
        IndexTaskSerdeTest.assertSerdeTuningConfig(tuningConfig);
    }

    @Test
    public void testSerdeTuningConfigWithDeprecatedDynamicPartitionsSpec() throws IOException {
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, Integer.valueOf(1000), null, Integer.valueOf(100), Long.valueOf(2000L), null, Long.valueOf(3000L), null, null, null, null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(false), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), null, Long.valueOf(1L));
        IndexTaskSerdeTest.assertSerdeTuningConfig(tuningConfig);
    }

    @Test
    public void testSerdeTuningConfigWithDeprecatedHashedPartitionsSpec() throws IOException {
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(100), Long.valueOf(2000L), null, null, null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), null, new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(false), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), Integer.valueOf(1234), null);
        IndexTaskSerdeTest.assertSerdeTuningConfig(tuningConfig);
    }

    @Test
    public void testForceGuaranteedRollupWithDynamicPartitionsSpec() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DynamicPartitionsSpec cannot be used for perfect rollup");
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(100), Long.valueOf(2000L), null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(2000L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(true), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), null, null);
    }

    @Test
    public void testBestEffortRollupWithHashedPartitionsSpec() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DynamicPartitionsSpec must be used for best-effort rollup");
        IndexTask.IndexTuningConfig tuningConfig = new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(100), Long.valueOf(2000L), null, null, null, null, null, (PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(10), (List)ImmutableList.of((Object)"dim1", (Object)"dim2")), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(false)), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), null, null, Boolean.valueOf(false), null, null, Long.valueOf(100L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(100), null, null);
    }

    private static void assertSerdeTuningConfig(IndexTask.IndexTuningConfig tuningConfig) throws IOException {
        byte[] json = MAPPER.writeValueAsBytes((Object)tuningConfig);
        IndexTask.IndexTuningConfig fromJson = (IndexTask.IndexTuningConfig)MAPPER.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }
}

