/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.Union;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionCardinalityReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.Level;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class DimensionCardinalityReportTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private DimensionCardinalityReport target;
    @Rule
    public final LoggerCaptureRule logger = new LoggerCaptureRule(ParallelIndexSupervisorTask.class);

    @Before
    public void setup() {
        Interval interval = Intervals.ETERNITY;
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        Map<Interval, byte[]> intervalToCardinality = Collections.singletonMap(interval, collector.toByteArray());
        String taskId = "abc";
        this.target = new DimensionCardinalityReport(taskId, intervalToCardinality);
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }

    @Test
    public void abidesEqualsContract() {
        EqualsVerifier.forClass(DimensionCardinalityReport.class).usingGetClass().verify();
    }

    @Test
    public void testSupervisorDetermineNumShardsFromCardinalityReport() {
        ArrayList<DimensionCardinalityReport> reports = new ArrayList<DimensionCardinalityReport>();
        HllSketch collector1 = DimensionCardinalityReport.createHllSketchForReport();
        collector1.update(IndexTask.HASH_FUNCTION.hashLong(1L).asBytes());
        collector1.update(IndexTask.HASH_FUNCTION.hashLong(200L).asBytes());
        DimensionCardinalityReport report1 = new DimensionCardinalityReport("taskA", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-02T00:00:00.000Z"), (Object)collector1.toCompactByteArray()));
        reports.add(report1);
        HllSketch collector2 = DimensionCardinalityReport.createHllSketchForReport();
        collector2.update(IndexTask.HASH_FUNCTION.hashLong(1000L).asBytes());
        collector2.update(IndexTask.HASH_FUNCTION.hashLong(30000L).asBytes());
        DimensionCardinalityReport report2 = new DimensionCardinalityReport("taskB", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-02T00:00:00.000Z"), (Object)collector2.toCompactByteArray()));
        reports.add(report2);
        HllSketch collector3 = DimensionCardinalityReport.createHllSketchForReport();
        collector3.update(IndexTask.HASH_FUNCTION.hashLong(99000L).asBytes());
        DimensionCardinalityReport report3 = new DimensionCardinalityReport("taskC", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-02T00:00:00.000Z/1970-01-03T00:00:00.000Z"), (Object)collector3.toCompactByteArray()));
        reports.add(report3);
        Map intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)1);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)4, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)2);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)2, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)3);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)4);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)5);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
    }

    @Test
    public void testLargeSupervisorDetermineNumShardsFromCardinalityReport() {
        ArrayList<DimensionCardinalityReport> reports = new ArrayList<DimensionCardinalityReport>();
        HllSketch collector1 = DimensionCardinalityReport.createHllSketchForReport();
        collector1.update(IndexTask.HASH_FUNCTION.hashLong(1L).asBytes());
        collector1.update(IndexTask.HASH_FUNCTION.hashLong(200L).asBytes());
        DimensionCardinalityReport report1 = new DimensionCardinalityReport("taskA", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-02T00:00:00.000Z"), (Object)collector1.toCompactByteArray()));
        reports.add(report1);
        HllSketch collector2 = DimensionCardinalityReport.createHllSketchForReport();
        collector2.update(IndexTask.HASH_FUNCTION.hashLong(1000L).asBytes());
        collector2.update(IndexTask.HASH_FUNCTION.hashLong(30000L).asBytes());
        DimensionCardinalityReport report2 = new DimensionCardinalityReport("taskB", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01T00:00:00.000Z/1970-01-02T00:00:00.000Z"), (Object)collector2.toCompactByteArray()));
        reports.add(report2);
        HllSketch collector3 = DimensionCardinalityReport.createHllSketchForReport();
        collector3.update(IndexTask.HASH_FUNCTION.hashLong(99000L).asBytes());
        DimensionCardinalityReport report3 = new DimensionCardinalityReport("taskC", (Map)ImmutableMap.of((Object)Intervals.of((String)"1970-01-02T00:00:00.000Z/1970-01-03T00:00:00.000Z"), (Object)collector3.toCompactByteArray()));
        reports.add(report3);
        Map intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)1);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)4, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)2);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)2, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)3);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)4);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
        intervalToNumShards = ParallelIndexSupervisorTask.determineNumShardsFromCardinalityReport(reports, (int)5);
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"1970-01-01/P1D"), (Object)1, (Object)Intervals.of((String)"1970-01-02/P1D"), (Object)1), (Object)intervalToNumShards);
    }

    @Test
    public void testSupervisorDetermineNegativeNumShardsFromCardinalityReport() {
        this.logger.clearLogEvents();
        Union negativeUnion = (Union)Mockito.mock(Union.class);
        Mockito.when((Object)negativeUnion.getEstimate()).thenReturn((Object)-1.0);
        Interval interval = Intervals.of((String)"2001-01-01/P1D");
        ImmutableMap intervalToUnion = ImmutableMap.of((Object)interval, (Object)negativeUnion);
        Map intervalToNumShards = ParallelIndexSupervisorTask.computeIntervalToNumShards((int)10, (Map)intervalToUnion);
        Assert.assertEquals((Object)new Integer(7), intervalToNumShards.get(interval));
        List loggingEvents = this.logger.getLogEvents();
        String expectedLogMessage = "Estimated cardinality for union of estimates is zero or less: -1.00, setting num shards to 7";
        Assert.assertTrue((String)("Logging events: " + loggingEvents), (boolean)loggingEvents.stream().anyMatch(l -> l.getLevel().equals((Object)Level.WARN) && l.getMessage().getFormattedMessage().equals(expectedLogMessage)));
    }

    @Test
    public void testSupervisorDeterminePositiveNumShardsFromCardinalityReport() {
        Union union = (Union)Mockito.mock(Union.class);
        Mockito.when((Object)union.getEstimate()).thenReturn((Object)24.0);
        Interval interval = Intervals.of((String)"2001-01-01/P1D");
        ImmutableMap intervalToUnion = ImmutableMap.of((Object)interval, (Object)union);
        Map intervalToNumShards = ParallelIndexSupervisorTask.computeIntervalToNumShards((int)6, (Map)intervalToUnion);
        Assert.assertEquals((Object)new Integer(4), intervalToNumShards.get(interval));
    }

    @Test
    public void testSupervisorDeterminePositiveOneShardFromCardinalityReport() {
        this.logger.clearLogEvents();
        Union union = (Union)Mockito.mock(Union.class);
        Mockito.when((Object)union.getEstimate()).thenReturn((Object)24.0);
        Interval interval = Intervals.of((String)"2001-01-01/P1D");
        ImmutableMap intervalToUnion = ImmutableMap.of((Object)interval, (Object)union);
        Map intervalToNumShards = ParallelIndexSupervisorTask.computeIntervalToNumShards((int)24, (Map)intervalToUnion);
        Assert.assertEquals((Object)new Integer(1), intervalToNumShards.get(interval));
        List loggingEvents = this.logger.getLogEvents();
        String expectedLogMessage = "estimatedNumShards is ONE (1) given estimated cardinality 24.00 and maxRowsPerSegment 24";
        Assert.assertTrue((String)("Logging events: " + loggingEvents), (boolean)loggingEvents.stream().anyMatch(l -> l.getLevel().equals((Object)Level.INFO) && l.getMessage().getFormattedMessage().equals(expectedLogMessage)));
    }
}

