/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.util.concurrent.Futures;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.HttpShuffleClient;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.utils.CompressionUtils;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class HttpShuffleClientTest {
    private static final String SUPERVISOR_TASK_ID = "supervisorTaskId";
    private static final String SUBTASK_ID = "subtaskId";
    private static final Interval INTERVAL = Intervals.of((String)"2019/2020");
    private static final String HOST = "host";
    private static final int PORT = 1080;
    private static final int PARTITION_ID = 0;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private File segmentFile;

    @Before
    public void setup() throws IOException {
        File temp = this.temporaryFolder.newFile();
        try (BufferedWriter writer = Files.newBufferedWriter(temp.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (int j = 0; j < 10; ++j) {
                writer.write(StringUtils.format((String)"let's write some data.\n", (Object[])new Object[0]));
            }
        }
        this.segmentFile = new File(temp.getAbsolutePath() + ".zip");
        CompressionUtils.zip((File)this.segmentFile.getParentFile(), (File)this.segmentFile);
    }

    @Test
    public void testFetchSegmentFileWithValidParamsReturningCopiedFileInPartitoinDir() throws IOException {
        HttpShuffleClient shuffleClient = this.mockClient(0);
        File localDir = this.temporaryFolder.newFolder();
        File fetchedFile = shuffleClient.fetchSegmentFile(localDir, SUPERVISOR_TASK_ID, (PartitionLocation)new TestPartitionLocation());
        Assert.assertEquals((Object)fetchedFile.getParentFile(), (Object)localDir);
    }

    @Test
    public void testFetchUnknownPartitionThrowingIOExceptionAfterRetries() throws IOException {
        this.expectedException.expect(IOException.class);
        HttpShuffleClient shuffleClient = this.mockClient(4);
        shuffleClient.fetchSegmentFile(this.temporaryFolder.newFolder(), SUPERVISOR_TASK_ID, (PartitionLocation)new TestPartitionLocation());
    }

    @Test
    public void testFetchSegmentFileWithTransientFailuresReturningCopiedFileInPartitionDir() throws IOException {
        HttpShuffleClient shuffleClient = this.mockClient(2);
        File localDir = this.temporaryFolder.newFolder();
        File fetchedFile = shuffleClient.fetchSegmentFile(localDir, SUPERVISOR_TASK_ID, (PartitionLocation)new TestPartitionLocation());
        Assert.assertEquals((Object)fetchedFile.getParentFile(), (Object)localDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFetchSegmentFileWithTwoThreadsReturningCopiedFilesInPartitionDir() throws IOException, ExecutionException, InterruptedException {
        ExecutorService service = Execs.multiThreaded((int)2, (String)"http-shuffle-client-test-%d");
        HttpShuffleClient shuffleClient = this.mockClient(0);
        try {
            int i;
            ArrayList<Future<File>> futures = new ArrayList<Future<File>>();
            ArrayList<File> localDirs = new ArrayList<File>();
            for (i = 0; i < 2; ++i) {
                localDirs.add(this.temporaryFolder.newFolder());
            }
            for (i = 0; i < 2; ++i) {
                File localDir = (File)localDirs.get(i);
                futures.add(service.submit(() -> HttpShuffleClientTest.lambda$testFetchSegmentFileWithTwoThreadsReturningCopiedFilesInPartitionDir$0((ShuffleClient)shuffleClient, localDir)));
            }
            for (i = 0; i < futures.size(); ++i) {
                Assert.assertEquals((Object)((File)((Future)futures.get(i)).get()).getParentFile(), localDirs.get(i));
            }
        }
        finally {
            service.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFetchSegmentFileWithTwoThreadsAndTransitentFailuresReturningCopiedFilesInPartitionDir() throws IOException, ExecutionException, InterruptedException {
        ExecutorService service = Execs.multiThreaded((int)2, (String)"http-shuffle-client-test-%d");
        HttpShuffleClient shuffleClient = this.mockClient(2);
        try {
            int i;
            ArrayList<Future<File>> futures = new ArrayList<Future<File>>();
            ArrayList<File> localDirs = new ArrayList<File>();
            for (i = 0; i < 2; ++i) {
                localDirs.add(this.temporaryFolder.newFolder());
            }
            for (i = 0; i < 2; ++i) {
                File localDir = (File)localDirs.get(i);
                futures.add(service.submit(() -> HttpShuffleClientTest.lambda$testFetchSegmentFileWithTwoThreadsAndTransitentFailuresReturningCopiedFilesInPartitionDir$1((ShuffleClient)shuffleClient, localDir)));
            }
            for (i = 0; i < futures.size(); ++i) {
                Assert.assertEquals((Object)((File)((Future)futures.get(i)).get()).getParentFile(), localDirs.get(i));
            }
        }
        finally {
            service.shutdownNow();
        }
    }

    private HttpShuffleClient mockClient(int numFailures) throws FileNotFoundException {
        HttpClient httpClient = (HttpClient)EasyMock.strictMock(HttpClient.class);
        if (numFailures == 0) {
            EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject())).andReturn((Object)Futures.immediateFuture((Object)new FileInputStream(this.segmentFile))).andReturn((Object)Futures.immediateFuture((Object)new FileInputStream(this.segmentFile)));
        } else {
            EasyMock.expect((Object)httpClient.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject())).andReturn((Object)Futures.immediateFailedFuture((Throwable)new RuntimeException())).times(numFailures).andReturn((Object)Futures.immediateFuture((Object)new FileInputStream(this.segmentFile))).andReturn((Object)Futures.immediateFuture((Object)new FileInputStream(this.segmentFile)));
        }
        EasyMock.replay((Object[])new Object[]{httpClient});
        return new HttpShuffleClient(httpClient);
    }

    private static /* synthetic */ File lambda$testFetchSegmentFileWithTwoThreadsAndTransitentFailuresReturningCopiedFilesInPartitionDir$1(ShuffleClient shuffleClient, File localDir) throws Exception {
        return shuffleClient.fetchSegmentFile(localDir, SUPERVISOR_TASK_ID, (PartitionLocation)new TestPartitionLocation());
    }

    private static /* synthetic */ File lambda$testFetchSegmentFileWithTwoThreadsReturningCopiedFilesInPartitionDir$0(ShuffleClient shuffleClient, File localDir) throws Exception {
        return shuffleClient.fetchSegmentFile(localDir, SUPERVISOR_TASK_ID, (PartitionLocation)new TestPartitionLocation());
    }

    private static class TestPartitionLocation
    extends GenericPartitionLocation {
        private TestPartitionLocation() {
            super(HttpShuffleClientTest.HOST, 1080, false, HttpShuffleClientTest.SUBTASK_ID, INTERVAL, null);
        }

        public int getBucketId() {
            return 0;
        }
    }
}

