/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiPhaseParallelIndexingWithNullColumnTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final InputFormat JSON_FORMAT = new JsonInputFormat(null, null, null, null, null);
    private static final List<Interval> INTERVAL_TO_INDEX = Collections.singletonList(Intervals.of((String)"2022-01/P1M"));
    private final PartitionsSpec partitionsSpec;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new HashedPartitionsSpec(Integer.valueOf(10), null, (List)ImmutableList.of((Object)"ts", (Object)"unknownDim"))}, (Object)new Object[]{new DimensionRangePartitionsSpec(Integer.valueOf(10), null, Collections.singletonList("unknownDim"), false)});
    }

    public MultiPhaseParallelIndexingWithNullColumnTest(PartitionsSpec partitionsSpec) {
        super(LockGranularity.TIME_CHUNK, true, 0.0, 0.0);
        this.partitionsSpec = partitionsSpec;
        this.getObjectMapper().registerSubtypes(new Class[]{SplittableInlineDataSource.class});
    }

    @Test
    public void testIngestNullColumn() throws JsonProcessingException {
        List dimensionSchemas = DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "unknownDim"));
        ParallelIndexSupervisorTask task = new ParallelIndexSupervisorTask(null, null, null, new ParallelIndexIngestionSpec(new DataSchema("dataSource", TIMESTAMP_SPEC, DIMENSIONS_SPEC.withDimensions(dimensionSchemas), DEFAULT_METRICS_SPEC, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, INTERVAL_TO_INDEX), null), new ParallelIndexIOConfig(null, this.getInputSource(), JSON_FORMAT, Boolean.valueOf(false), null), this.newTuningConfig(this.partitionsSpec, 2, true)), null);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)this.getIndexingServiceClient().runAndWait((Task)task).getStatusCode());
        Set<DataSegment> segments = this.getIndexingServiceClient().getPublishedSegments((Task)task);
        Assert.assertFalse((boolean)segments.isEmpty());
        for (DataSegment segment : segments) {
            Assert.assertEquals((long)dimensionSchemas.size(), (long)segment.getDimensions().size());
            for (int i = 0; i < dimensionSchemas.size(); ++i) {
                Assert.assertEquals((Object)((DimensionSchema)dimensionSchemas.get(i)).getName(), segment.getDimensions().get(i));
            }
        }
    }

    @Test
    public void testIngestNullColumn_useFieldDiscovery_includeAllDimensions_shouldStoreAllColumns() throws JsonProcessingException {
        List dimensionSchemas = DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "unknownDim", "dim1"));
        ParallelIndexSupervisorTask task = new ParallelIndexSupervisorTask(null, null, null, new ParallelIndexIngestionSpec(new DataSchema("dataSource", TIMESTAMP_SPEC, new DimensionsSpec.Builder().setDimensions(dimensionSchemas).setIncludeAllDimensions(true).build(), DEFAULT_METRICS_SPEC, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, INTERVAL_TO_INDEX), null), new ParallelIndexIOConfig(null, this.getInputSource(), (InputFormat)new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), null), null, null, null, null), Boolean.valueOf(false), null), this.newTuningConfig(this.partitionsSpec, 2, true)), null);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)this.getIndexingServiceClient().runAndWait((Task)task).getStatusCode());
        Set<DataSegment> segments = this.getIndexingServiceClient().getPublishedSegments((Task)task);
        Assert.assertFalse((boolean)segments.isEmpty());
        ImmutableList expectedExplicitDimensions = ImmutableList.of((Object)"ts", (Object)"unknownDim", (Object)"dim1");
        ImmutableSet expectedImplicitDimensions = ImmutableSet.of((Object)"dim2", (Object)"dim3");
        for (DataSegment segment : segments) {
            Assert.assertEquals((Object)expectedExplicitDimensions, segment.getDimensions().subList(0, expectedExplicitDimensions.size()));
            Assert.assertEquals((Object)expectedImplicitDimensions, new HashSet(segment.getDimensions().subList(expectedExplicitDimensions.size(), segment.getDimensions().size())));
        }
    }

    @Test
    public void testIngestNullColumn_explicitPathSpec_useFieldDiscovery_includeAllDimensions_shouldStoreAllColumns() throws JsonProcessingException {
        ParallelIndexSupervisorTask task = new ParallelIndexSupervisorTask(null, null, null, new ParallelIndexIngestionSpec(new DataSchema("dataSource", TIMESTAMP_SPEC, new DimensionsSpec.Builder().setIncludeAllDimensions(true).build(), DEFAULT_METRICS_SPEC, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, null), null), new ParallelIndexIOConfig(null, this.getInputSource(), (InputFormat)new JsonInputFormat(new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "dim1", "$.dim1"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "k", "$.dim4.k"))), null, null, null, null), Boolean.valueOf(false), null), this.newTuningConfig(this.partitionsSpec, 2, true)), null);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)this.getIndexingServiceClient().runAndWait((Task)task).getStatusCode());
        Set<DataSegment> segments = this.getIndexingServiceClient().getPublishedSegments((Task)task);
        Assert.assertFalse((boolean)segments.isEmpty());
        ImmutableList expectedExplicitDimensions = ImmutableList.of((Object)"dim1", (Object)"k");
        ImmutableSet expectedImplicitDimensions = ImmutableSet.of((Object)"dim2", (Object)"dim3");
        for (DataSegment segment : segments) {
            Assert.assertEquals((Object)expectedExplicitDimensions, segment.getDimensions().subList(0, expectedExplicitDimensions.size()));
            Assert.assertEquals((Object)expectedImplicitDimensions, new HashSet(segment.getDimensions().subList(expectedExplicitDimensions.size(), segment.getDimensions().size())));
        }
    }

    @Test
    public void testIngestNullColumn_storeEmptyColumnsOff_shouldNotStoreEmptyColumns() throws JsonProcessingException {
        ParallelIndexSupervisorTask task = new ParallelIndexSupervisorTask(null, null, null, new ParallelIndexIngestionSpec(new DataSchema("dataSource", TIMESTAMP_SPEC, DIMENSIONS_SPEC.withDimensions(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "unknownDim"))), DEFAULT_METRICS_SPEC, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, INTERVAL_TO_INDEX), null), new ParallelIndexIOConfig(null, this.getInputSource(), JSON_FORMAT, Boolean.valueOf(false), null), this.newTuningConfig(this.partitionsSpec, 2, true)), null);
        task.addToContext("storeEmptyColumns", (Object)false);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)this.getIndexingServiceClient().runAndWait((Task)task).getStatusCode());
        Set<DataSegment> segments = this.getIndexingServiceClient().getPublishedSegments((Task)task);
        Assert.assertFalse((boolean)segments.isEmpty());
        List expectedDimensions = DimensionsSpec.getDefaultSchemas(Collections.singletonList("ts"));
        for (DataSegment segment : segments) {
            Assert.assertEquals((long)expectedDimensions.size(), (long)segment.getDimensions().size());
            for (int i = 0; i < expectedDimensions.size(); ++i) {
                Assert.assertEquals((Object)((DimensionSchema)expectedDimensions.get(i)).getName(), segment.getDimensions().get(i));
            }
        }
    }

    private InputSource getInputSource() throws JsonProcessingException {
        ObjectMapper mapper = this.getObjectMapper();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < 3; ++i) {
            rows.add(MultiPhaseParallelIndexingWithNullColumnTest.row(StringUtils.format((String)"2022-01-%02d", (Object[])new Object[]{i + 1}), "val1", "val2", null));
        }
        rows.add(MultiPhaseParallelIndexingWithNullColumnTest.row("2022-01-04", null, null, null, ImmutableMap.of((Object)"k", (Object)"v")));
        String data = StringUtils.format((String)"%s\n%s\n%s\n%s\n", (Object[])new Object[]{mapper.writeValueAsString(rows.get(0)), mapper.writeValueAsString(rows.get(1)), mapper.writeValueAsString(rows.get(2)), mapper.writeValueAsString(rows.get(3))});
        return new SplittableInlineDataSource((List<String>)ImmutableList.of((Object)data));
    }

    private static Map<String, Object> row(String timestamp, Object ... dims) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("ts", timestamp);
        IntStream.range(0, dims.length).forEach(i -> row.put("dim" + (i + 1), dims[i]));
        return row;
    }

    private static final class SplittableInlineDataSource
    implements SplittableInputSource<String> {
        private final List<String> data;

        @JsonCreator
        public SplittableInlineDataSource(@JsonProperty(value="data") List<String> data) {
            this.data = data;
        }

        @JsonProperty
        public List<String> getData() {
            return this.data;
        }

        public Stream<InputSplit<String>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.data.stream().map(InputSplit::new);
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.data.size();
        }

        public InputSource withSplit(InputSplit<String> split) {
            return new SplittableInlineDataSource((List<String>)ImmutableList.of((Object)split.get()));
        }

        public boolean needsFormat() {
            return true;
        }

        public InputSourceReader reader(InputRowSchema inputRowSchema, @Nullable InputFormat inputFormat, File temporaryDirectory) {
            return new InputEntityIteratingReader(inputRowSchema, inputFormat, this.data.stream().map(str -> new ByteEntity(StringUtils.toUtf8((String)str))).iterator(), temporaryDirectory);
        }
    }
}

