/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseParallelIndexTaskRunner;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.TaskHistory;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParallelIndexSupervisorTaskKillTest
extends AbstractParallelIndexSupervisorTaskTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public ParallelIndexSupervisorTaskKillTest() {
        super(0.0, 0.0);
    }

    @After
    public void teardown() {
        this.temporaryFolder.delete();
    }

    @Test(timeout=5000L)
    public void testStopGracefully() throws Exception {
        ParallelIndexSupervisorTask task = this.newTask(Intervals.of((String)"2017/2018"), new ParallelIndexIOConfig(null, (InputSource)new TestInputSource(new Pair[]{Pair.of((Object)new TestInput(Integer.MAX_VALUE, TaskState.SUCCESS), (Object)4)}), (InputFormat)new NoopInputFormat(), Boolean.valueOf(false), null));
        this.getIndexingServiceClient().runTask(task.getId(), task);
        while (task.getCurrentRunner() == null) {
            Thread.sleep(100L);
        }
        task.stopGracefully(null);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ExecutionException.class));
        this.getIndexingServiceClient().waitToFinish((Task)task, 3000L, TimeUnit.MILLISECONDS);
        SinglePhaseParallelIndexTaskRunner runner = (SinglePhaseParallelIndexTaskRunner)task.getCurrentRunner();
        Assert.assertTrue((boolean)runner.getRunningTaskIds().isEmpty());
        Assert.assertTrue((boolean)runner.getCompleteSubTaskSpecs().isEmpty());
        Assert.assertEquals((long)4L, (long)runner.getTaskMonitor().getNumCanceledTasks());
    }

    @Test(timeout=5000L)
    public void testSubTaskFail() throws Exception {
        ParallelIndexSupervisorTask task = this.newTask(Intervals.of((String)"2017/2018"), new ParallelIndexIOConfig(null, (InputSource)new TestInputSource(new Pair[]{Pair.of((Object)new TestInput(10L, TaskState.FAILED), (Object)1), Pair.of((Object)new TestInput(Integer.MAX_VALUE, TaskState.FAILED), (Object)3)}), (InputFormat)new NoopInputFormat(), Boolean.valueOf(false), null));
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        this.prepareTaskForLocking((Task)task);
        Assert.assertTrue((boolean)task.isReady((TaskActionClient)actionClient));
        TaskStatus taskStatus = task.run(toolbox);
        Assert.assertEquals((Object)"Failed in phase[segment generation]. See task logs for details.", (Object)taskStatus.getErrorMsg());
        Assert.assertEquals((Object)TaskState.FAILED, (Object)taskStatus.getStatusCode());
        SinglePhaseParallelIndexTaskRunner runner = (SinglePhaseParallelIndexTaskRunner)task.getCurrentRunner();
        Assert.assertTrue((boolean)runner.getRunningTaskIds().isEmpty());
        List completeSubTaskSpecs = runner.getCompleteSubTaskSpecs();
        Assert.assertEquals((long)1L, (long)completeSubTaskSpecs.size());
        TaskHistory history = runner.getCompleteSubTaskSpecAttemptHistory(((SubTaskSpec)completeSubTaskSpecs.get(0)).getId());
        Assert.assertNotNull((Object)history);
        Assert.assertEquals((long)3L, (long)history.getAttemptHistory().size());
        for (TaskStatusPlus status : history.getAttemptHistory()) {
            Assert.assertEquals((Object)TaskState.FAILED, (Object)status.getStatusCode());
        }
        Assert.assertEquals((long)3L, (long)runner.getTaskMonitor().getNumCanceledTasks());
    }

    private ParallelIndexSupervisorTask newTask(Interval interval, ParallelIndexIOConfig ioConfig) {
        TestInputSource inputSource = (TestInputSource)ioConfig.getInputSource();
        int numTotalSubTasks = inputSource.estimateNumSplits((InputFormat)new NoopInputFormat(), null);
        ParallelIndexIngestionSpec ingestionSpec = new ParallelIndexIngestionSpec(new DataSchema("dataSource", DEFAULT_TIMESTAMP_SPEC, DEFAULT_DIMENSIONS_SPEC, new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.MINUTE, interval == null ? null : Collections.singletonList(interval)), null), ioConfig, new ParallelIndexTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Integer.valueOf(numTotalSubTasks), null, null, null, null, null, null, null, null, null, null, null, null));
        return new TestSupervisorTask(ingestionSpec, Collections.singletonMap("disableInject", true));
    }

    private static class TestSinglePhaseSubTask
    extends SinglePhaseSubTask {
        private TestSinglePhaseSubTask(@Nullable String id, String groupId, TaskResource taskResource, String supervisorTaskId, String subtaskSpecId, int numAttempts, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context) {
            super(id, groupId, taskResource, supervisorTaskId, subtaskSpecId, numAttempts, ingestionSchema, context);
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            return true;
        }

        public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
            TestInputSource inputSource = (TestInputSource)this.getIngestionSchema().getIOConfig().getInputSource();
            TestInput testInput = (TestInput)((InputSplit)Iterables.getOnlyElement((Iterable)inputSource.splits)).get();
            Thread.sleep(testInput.runTime);
            return TaskStatus.fromCode((String)this.getId(), (TaskState)testInput.finalState);
        }
    }

    private static class TestSinglePhaseSubTaskSpec
    extends SinglePhaseSubTaskSpec {
        private TestSinglePhaseSubTaskSpec(String id, String groupId, ParallelIndexSupervisorTask supervisorTask, ParallelIndexIngestionSpec ingestionSpec, Map<String, Object> context, InputSplit inputSplit) {
            super(id, groupId, supervisorTask.getId(), ingestionSpec, context, inputSplit);
        }

        public SinglePhaseSubTask newSubTask(int numAttempts) {
            return new TestSinglePhaseSubTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), this.getId(), numAttempts, this.getIngestionSpec(), this.getContext());
        }
    }

    private static class TestRunner
    extends SinglePhaseParallelIndexTaskRunner {
        private final ParallelIndexSupervisorTask supervisorTask;

        private TestRunner(TaskToolbox toolbox, ParallelIndexSupervisorTask supervisorTask) {
            super(toolbox, supervisorTask.getId(), supervisorTask.getGroupId(), supervisorTask.getIngestionSchema(), supervisorTask.getContext());
            this.supervisorTask = supervisorTask;
        }

        SinglePhaseSubTaskSpec newTaskSpec(InputSplit split) {
            SplittableInputSource baseInputSource = (SplittableInputSource)this.getIngestionSchema().getIOConfig().getInputSource();
            return new TestSinglePhaseSubTaskSpec(this.supervisorTask.getId() + "_" + this.getAndIncrementNextSpecId(), this.supervisorTask.getGroupId(), this.supervisorTask, new ParallelIndexIngestionSpec(this.getIngestionSchema().getDataSchema(), new ParallelIndexIOConfig(null, baseInputSource.withSplit(split), this.getIngestionSchema().getIOConfig().getInputFormat(), Boolean.valueOf(this.getIngestionSchema().getIOConfig().isAppendToExisting()), Boolean.valueOf(this.getIngestionSchema().getIOConfig().isDropExisting())), this.getIngestionSchema().getTuningConfig()), this.supervisorTask.getContext(), split);
        }
    }

    private static class TestSupervisorTask
    extends AbstractParallelIndexSupervisorTaskTest.TestParallelIndexSupervisorTask {
        private TestSupervisorTask(ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context) {
            super(null, null, ingestionSchema, context);
        }

        SinglePhaseParallelIndexTaskRunner createSinglePhaseTaskRunner(TaskToolbox toolbox) {
            return new TestRunner(toolbox, this);
        }
    }

    private static class TestInputSource
    extends AbstractInputSource
    implements SplittableInputSource<TestInput> {
        private final List<InputSplit<TestInput>> splits;

        @SafeVarargs
        private TestInputSource(Pair<TestInput, Integer> ... inputSpecs) {
            this.splits = new ArrayList<InputSplit<TestInput>>();
            for (Pair<TestInput, Integer> inputSpec : inputSpecs) {
                int numInputs = (Integer)inputSpec.rhs;
                for (int i = 0; i < numInputs; ++i) {
                    this.splits.add((InputSplit<TestInput>)new InputSplit((Object)new TestInput(((TestInput)inputSpec.lhs).runTime, ((TestInput)inputSpec.lhs).finalState)));
                }
            }
        }

        private TestInputSource(InputSplit<TestInput> split) {
            this.splits = Collections.singletonList(split);
        }

        public Stream<InputSplit<TestInput>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.splits.stream();
        }

        public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
            return this.splits.size();
        }

        public SplittableInputSource<TestInput> withSplit(InputSplit<TestInput> split) {
            return new TestInputSource(split);
        }

        public boolean needsFormat() {
            return false;
        }
    }

    private static class TestInput {
        private final long runTime;
        private final TaskState finalState;

        private TestInput(long runTime, TaskState finalState) {
            this.runTime = runTime;
            this.finalState = finalState;
        }
    }
}

