/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;

class ParallelIndexTestingFactory {
    static final String AUTOMATIC_ID = null;
    static final String ID = "id";
    static final String GROUP_ID = "group-id";
    static final TaskResource TASK_RESOURCE = null;
    static final String SUPERVISOR_TASK_ID = "supervisor-task-id";
    static final String SUBTASK_SPEC_ID = "subtask-spec-id";
    static final int NUM_ATTEMPTS = 1;
    static final Map<String, Object> CONTEXT = Collections.emptyMap();
    static final ParallelIndexSupervisorTaskClientProvider TASK_CLIENT_PROVIDER = TestUtils.TASK_CLIENT_PROVIDER;
    static final AppenderatorsManager APPENDERATORS_MANAGER = TestUtils.APPENDERATORS_MANAGER;
    static final ShuffleClient SHUFFLE_CLIENT = new ShuffleClient(){

        public File fetchSegmentFile(File partitionDir, String supervisorTaskId, PartitionLocation location) {
            return null;
        }
    };
    static final List<Interval> INPUT_INTERVALS = Collections.singletonList(Intervals.ETERNITY);
    static final String TASK_EXECUTOR_HOST = "task-executor-host";
    static final int TASK_EXECUTOR_PORT = 1;
    static final boolean USE_HTTPS = true;
    static final Interval INTERVAL = Intervals.ETERNITY;
    static final int NUM_ROWS = 2;
    static final long SIZE_BYTES = 3L;
    static final int PARTITION_ID = 4;
    static final String HOST = "host";
    static final int PORT = 1;
    static final String SUBTASK_ID = "subtask-id";
    private static final TestUtils TEST_UTILS = new TestUtils();
    private static final ObjectMapper NESTED_OBJECT_MAPPER = TEST_UTILS.getTestObjectMapper();
    private static final String SCHEMA_TIME = "time";
    private static final String SCHEMA_DIMENSION = "dim";
    private static final String DATASOURCE = "datasource";
    static final BuildingHashBasedNumberedShardSpec HASH_BASED_NUMBERED_SHARD_SPEC = new BuildingHashBasedNumberedShardSpec(4, 4, 5, Collections.singletonList("dim"), HashPartitionFunction.MURMUR3_32_ABS, NESTED_OBJECT_MAPPER);

    ParallelIndexTestingFactory() {
    }

    static ObjectMapper createObjectMapper() {
        return TEST_UTILS.getTestObjectMapper();
    }

    static IndexIO getIndexIO() {
        return TEST_UTILS.getTestIndexIO();
    }

    static DataSchema createDataSchema(List<Interval> granularitySpecInputIntervals) {
        ArbitraryGranularitySpec granularitySpec = new ArbitraryGranularitySpec(Granularities.DAY, granularitySpecInputIntervals);
        TimestampSpec timestampSpec = new TimestampSpec(SCHEMA_TIME, "auto", null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)SCHEMA_DIMENSION)));
        return new DataSchema(DATASOURCE, timestampSpec, dimensionsSpec, new AggregatorFactory[0], (GranularitySpec)granularitySpec, TransformSpec.NONE, null, NESTED_OBJECT_MAPPER);
    }

    static ParallelIndexIngestionSpec createIngestionSpec(InputSource inputSource, InputFormat inputFormat, ParallelIndexTuningConfig tuningConfig, DataSchema dataSchema) {
        ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig(null, inputSource, inputFormat, Boolean.valueOf(false), Boolean.valueOf(false));
        return new ParallelIndexIngestionSpec(dataSchema, ioConfig, tuningConfig);
    }

    static ParallelIndexSupervisorTaskClientProvider createTaskClientFactory() {
        return (supervisorTaskId, httpTimeout, numRetries) -> ParallelIndexTestingFactory.createTaskClient();
    }

    private static ParallelIndexSupervisorTaskClient createTaskClient() {
        ParallelIndexSupervisorTaskClient taskClient = (ParallelIndexSupervisorTaskClient)EasyMock.niceMock(ParallelIndexSupervisorTaskClient.class);
        EasyMock.replay((Object[])new Object[]{taskClient});
        return taskClient;
    }

    static String createRow(long timestamp, Object dimensionValue) {
        try {
            return NESTED_OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)SCHEMA_TIME, (Object)timestamp, (Object)SCHEMA_DIMENSION, (Object)dimensionValue));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static String createRowFromMap(long timestamp, Map<String, Object> fields) {
        HashMap<String, Object> row = new HashMap<String, Object>(fields);
        row.put(SCHEMA_TIME, timestamp);
        try {
            return NESTED_OBJECT_MAPPER.writeValueAsString(row);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static InputFormat getInputFormat() {
        return new JsonInputFormat(null, null, null, null, null);
    }

    static class SingleDimensionPartitionsSpecBuilder {
        @Nullable
        private String partitionDimension = "dim";
        private boolean assumeGrouped = false;

        SingleDimensionPartitionsSpecBuilder() {
        }

        SingleDimensionPartitionsSpecBuilder partitionDimension(@Nullable String partitionDimension) {
            this.partitionDimension = partitionDimension;
            return this;
        }

        SingleDimensionPartitionsSpecBuilder assumeGrouped(boolean assumeGrouped) {
            this.assumeGrouped = assumeGrouped;
            return this;
        }

        SingleDimensionPartitionsSpec build() {
            return new SingleDimensionPartitionsSpec(Integer.valueOf(1), null, this.partitionDimension, this.assumeGrouped);
        }
    }

    static class TuningConfigBuilder {
        private PartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(2), null);
        private boolean forceGuaranteedRollup = true;
        private boolean logParseExceptions = false;
        private int maxParseExceptions = Integer.MAX_VALUE;

        TuningConfigBuilder() {
        }

        TuningConfigBuilder partitionsSpec(PartitionsSpec partitionsSpec) {
            this.partitionsSpec = partitionsSpec;
            return this;
        }

        TuningConfigBuilder forceGuaranteedRollup(boolean forceGuaranteedRollup) {
            this.forceGuaranteedRollup = forceGuaranteedRollup;
            return this;
        }

        TuningConfigBuilder logParseExceptions(boolean logParseExceptions) {
            this.logParseExceptions = logParseExceptions;
            return this;
        }

        TuningConfigBuilder maxParseExceptions(int maxParseExceptions) {
            this.maxParseExceptions = maxParseExceptions;
            return this;
        }

        ParallelIndexTuningConfig build() {
            return new ParallelIndexTuningConfig(Integer.valueOf(1), null, null, Integer.valueOf(3), Long.valueOf(4L), null, Long.valueOf(5L), Integer.valueOf(6), null, this.partitionsSpec, null, null, Integer.valueOf(10), Boolean.valueOf(this.forceGuaranteedRollup), Boolean.valueOf(false), Long.valueOf(14L), null, null, Integer.valueOf(16), Integer.valueOf(17), Long.valueOf(18L), Duration.ZERO, Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Boolean.valueOf(this.logParseExceptions), Integer.valueOf(this.maxParseExceptions), Integer.valueOf(25), null, null, null);
        }
    }
}

