/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartialCompactionTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final InputFormat INPUT_FORMAT = new CsvInputFormat(Arrays.asList("ts", "dim1", "dim2", "val"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0);
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"2017-12/P1M");
    private static final RetryPolicyFactory RETRY_POLICY_FACTORY = new RetryPolicyFactory(new RetryPolicyConfig());
    private File inputDir;

    public PartialCompactionTest() {
        super(LockGranularity.SEGMENT, true, 0.2, 0.2);
    }

    @Before
    public void setup() throws IOException {
        this.inputDir = this.temporaryFolder.newFolder("data");
        for (int i = 0; i < 10; ++i) {
            try (BufferedWriter writer = Files.newBufferedWriter(new File(this.inputDir, "test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                for (int j = 0; j < 10; ++j) {
                    writer.write(StringUtils.format((String)"2017-12-%d,%d,%d th test file\n", (Object[])new Object[]{j + 1, i + 10, i}));
                    writer.write(StringUtils.format((String)"2017-12-%d,%d,%d th test file\n", (Object[])new Object[]{j + 2, i + 11, i}));
                }
                continue;
            }
        }
    }

    @Test
    public void testPartialCompactHashAndDynamicPartitionedSegments() {
        Map hashPartitionedSegments = SegmentUtils.groupSegmentsByInterval(this.runTestTask((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), TaskState.SUCCESS, false));
        Map linearlyPartitionedSegments = SegmentUtils.groupSegmentsByInterval(this.runTestTask((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(10), null), TaskState.SUCCESS, true));
        hashPartitionedSegments.values().forEach(segmentsInInterval -> segmentsInInterval.sort(Comparator.comparing(segment -> segment.getShardSpec().getPartitionNum())));
        linearlyPartitionedSegments.values().forEach(segmentsInInterval -> segmentsInInterval.sort(Comparator.comparing(segment -> segment.getShardSpec().getPartitionNum())));
        ArrayList segmentsToCompact = new ArrayList();
        for (List segmentsInInterval2 : hashPartitionedSegments.values()) {
            segmentsToCompact.addAll(segmentsInInterval2.subList(segmentsInInterval2.size() / 2, segmentsInInterval2.size()));
        }
        for (List segmentsInInterval2 : linearlyPartitionedSegments.values()) {
            segmentsToCompact.addAll(segmentsInInterval2.subList(0, segmentsInInterval2.size() / 2));
        }
        CompactionTask compactionTask = this.newCompactionTaskBuilder().inputSpec((CompactionInputSpec)SpecificSegmentsSpec.fromSegments(segmentsToCompact)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(20), null), 2, false)).build();
        Map compactedSegments = SegmentUtils.groupSegmentsByInterval(this.runTask((Task)compactionTask, TaskState.SUCCESS));
        for (List segmentsInInterval3 : compactedSegments.values()) {
            int expectedAtomicUpdateGroupSize = segmentsInInterval3.size();
            for (DataSegment segment : segmentsInInterval3) {
                Assert.assertEquals((long)expectedAtomicUpdateGroupSize, (long)segment.getShardSpec().getAtomicUpdateGroupSize());
            }
        }
    }

    @Test
    public void testPartialCompactRangeAndDynamicPartitionedSegments() {
        Map rangePartitionedSegments = SegmentUtils.groupSegmentsByInterval(this.runTestTask((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(10), null, "dim1", false), TaskState.SUCCESS, false));
        Map linearlyPartitionedSegments = SegmentUtils.groupSegmentsByInterval(this.runTestTask((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(10), null), TaskState.SUCCESS, true));
        rangePartitionedSegments.values().forEach(segmentsInInterval -> segmentsInInterval.sort(Comparator.comparing(segment -> segment.getShardSpec().getPartitionNum())));
        linearlyPartitionedSegments.values().forEach(segmentsInInterval -> segmentsInInterval.sort(Comparator.comparing(segment -> segment.getShardSpec().getPartitionNum())));
        ArrayList segmentsToCompact = new ArrayList();
        for (List segmentsInInterval2 : rangePartitionedSegments.values()) {
            segmentsToCompact.addAll(segmentsInInterval2.subList(segmentsInInterval2.size() / 2, segmentsInInterval2.size()));
        }
        for (List segmentsInInterval2 : linearlyPartitionedSegments.values()) {
            segmentsToCompact.addAll(segmentsInInterval2.subList(0, segmentsInInterval2.size() / 2));
        }
        CompactionTask compactionTask = this.newCompactionTaskBuilder().inputSpec((CompactionInputSpec)SpecificSegmentsSpec.fromSegments(segmentsToCompact)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(20), null), 2, false)).build();
        Map compactedSegments = SegmentUtils.groupSegmentsByInterval(this.runTask((Task)compactionTask, TaskState.SUCCESS));
        for (List segmentsInInterval3 : compactedSegments.values()) {
            int expectedAtomicUpdateGroupSize = segmentsInInterval3.size();
            for (DataSegment segment : segmentsInInterval3) {
                Assert.assertEquals((long)expectedAtomicUpdateGroupSize, (long)segment.getShardSpec().getAtomicUpdateGroupSize());
            }
        }
    }

    private Set<DataSegment> runTestTask(PartitionsSpec partitionsSpec, TaskState expectedTaskState, boolean appendToExisting) {
        return this.runTestTask(TIMESTAMP_SPEC, DIMENSIONS_SPEC, INPUT_FORMAT, null, INTERVAL_TO_INDEX, this.inputDir, "test_*", partitionsSpec, 2, expectedTaskState, appendToExisting, false);
    }

    private CompactionTask.Builder newCompactionTaskBuilder() {
        return new CompactionTask.Builder("dataSource", this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
    }
}

