/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PerfectRollupWorkerTaskTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void requiresForceGuaranteedRollup() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("forceGuaranteedRollup must be set");
        new PerfectRollupWorkerTaskBuilder().forceGuaranteedRollup(false).build();
    }

    @Test
    public void succeedsWithUnspecifiedNumShards() {
        new PerfectRollupWorkerTaskBuilder().partitionsSpec((PartitionsSpec)HashedPartitionsSpec.defaultSpec()).build();
    }

    @Test
    public void succeedsWithValidPartitionsSpec() {
        new PerfectRollupWorkerTaskBuilder().build();
    }

    private static class TestPerfectRollupWorkerTask
    extends PerfectRollupWorkerTask {
        TestPerfectRollupWorkerTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, DataSchema dataSchema, ParallelIndexTuningConfig tuningConfig, @Nullable Map<String, Object> context) {
            super(id, groupId, taskResource, dataSchema, tuningConfig, context);
        }

        public TaskStatus runTask(TaskToolbox toolbox) {
            throw new UnsupportedOperationException();
        }

        public String getType() {
            return "TestPerfectRollupWorkerTask";
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            throw new UnsupportedOperationException();
        }

        public String getSubtaskSpecId() {
            return "subtaskSpecId";
        }
    }

    private static class PerfectRollupWorkerTaskBuilder {
        private static final PartitionsSpec PARTITIONS_SPEC = new HashedPartitionsSpec(null, Integer.valueOf(1), null, null, null, null);
        private List<Interval> granularitySpecInputIntervals = Collections.singletonList(Intervals.ETERNITY);
        private boolean forceGuaranteedRollup = true;
        private PartitionsSpec partitionsSpec = PARTITIONS_SPEC;

        private PerfectRollupWorkerTaskBuilder() {
        }

        PerfectRollupWorkerTaskBuilder granularitySpecInputIntervals(List<Interval> granularitySpecInputIntervals) {
            this.granularitySpecInputIntervals = granularitySpecInputIntervals;
            return this;
        }

        PerfectRollupWorkerTaskBuilder forceGuaranteedRollup(boolean forceGuaranteedRollup) {
            this.forceGuaranteedRollup = forceGuaranteedRollup;
            return this;
        }

        PerfectRollupWorkerTaskBuilder partitionsSpec(PartitionsSpec partitionsSpec) {
            this.partitionsSpec = partitionsSpec;
            return this;
        }

        PerfectRollupWorkerTask build() {
            return new TestPerfectRollupWorkerTask("id", "group-id", null, PerfectRollupWorkerTaskBuilder.createDataSchema(this.granularitySpecInputIntervals), PerfectRollupWorkerTaskBuilder.createTuningConfig(this.forceGuaranteedRollup, this.partitionsSpec), null);
        }

        private static DataSchema createDataSchema(List<Interval> granularitySpecInputIntervals) {
            GranularitySpec granularitySpec = (GranularitySpec)EasyMock.mock(GranularitySpec.class);
            EasyMock.expect((Object)granularitySpec.inputIntervals()).andStubReturn(granularitySpecInputIntervals);
            EasyMock.replay((Object[])new Object[]{granularitySpec});
            DataSchema dataSchema = (DataSchema)EasyMock.mock(DataSchema.class);
            EasyMock.expect((Object)dataSchema.getDataSource()).andStubReturn((Object)"datasource");
            EasyMock.expect((Object)dataSchema.getGranularitySpec()).andStubReturn((Object)granularitySpec);
            EasyMock.replay((Object[])new Object[]{dataSchema});
            return dataSchema;
        }

        private static ParallelIndexTuningConfig createTuningConfig(boolean forceGuaranteedRollup, PartitionsSpec partitionsSpec) {
            ParallelIndexTuningConfig tuningConfig = (ParallelIndexTuningConfig)EasyMock.mock(ParallelIndexTuningConfig.class);
            EasyMock.expect((Object)tuningConfig.isForceGuaranteedRollup()).andStubReturn((Object)forceGuaranteedRollup);
            EasyMock.expect((Object)tuningConfig.getGivenOrDefaultPartitionsSpec()).andStubReturn((Object)partitionsSpec);
            EasyMock.replay((Object[])new Object[]{tuningConfig});
            return tuningConfig;
        }
    }
}

