/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTaskSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SinglePhaseSubTaskSpecTest {
    private static final SinglePhaseSubTaskSpec SPEC = new SinglePhaseSubTaskSpec("id", "groupId", "supervisorTaskId", new ParallelIndexIngestionSpec(new DataSchema("dataSource", new TimestampSpec(null, null, null), new DimensionsSpec(null), new AggregatorFactory[0], null, null), new ParallelIndexIOConfig(null, (InputSource)new LocalInputSource(new File("baseDir"), "filter"), (InputFormat)new JsonInputFormat(null, null, null, null, null), null, null), null), null, new InputSplit((Object)"string split"));
    private ObjectMapper mapper;

    @Before
    public void setup() {
        this.mapper = new TestUtils().getTestObjectMapper();
    }

    @Test
    public void testNewSubTaskType() throws IOException {
        SinglePhaseSubTask expected = SPEC.newSubTask(0);
        byte[] json = this.mapper.writeValueAsBytes((Object)expected);
        Map actual = (Map)this.mapper.readValue(json, Map.class);
        Assert.assertEquals((Object)"single_phase_sub_task", actual.get("type"));
    }

    @Test
    public void testNewSubTaskWithBackwardCompatibleType() throws IOException {
        SinglePhaseSubTask expected = SPEC.newSubTaskWithBackwardCompatibleType(0);
        byte[] json = this.mapper.writeValueAsBytes((Object)expected);
        Map actual = (Map)this.mapper.readValue(json, Map.class);
        Assert.assertEquals((Object)"index_sub", actual.get("type"));
    }
}

