/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.firehose;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactoryTest;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IngestSegmentFirehoseFactoryTimelineTest {
    private static final String DATA_SOURCE = "foo";
    private static final String TIME_COLUMN = "t";
    private static final String[] DIMENSIONS = new String[]{"d1"};
    private static final String[] METRICS = new String[]{"m1"};
    private static final InputRowParser<Map<String, Object>> ROW_PARSER = TransformSpec.NONE.decorate((InputRowParser)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("t", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList(DIMENSIONS))), null, null, null)));
    private final IngestSegmentFirehoseFactory factory;
    private final File tmpDir;
    private final int expectedCount;
    private final long expectedSum;
    private final int segmentCount;
    private static final ObjectMapper MAPPER;
    private static final IndexIO INDEX_IO;
    private static final IndexMergerV9 INDEX_MERGER_V9;

    public IngestSegmentFirehoseFactoryTimelineTest(String name, IngestSegmentFirehoseFactory factory, File tmpDir, int expectedCount, long expectedSum, int segmentCount) {
        this.factory = factory;
        this.tmpDir = tmpDir;
        this.expectedCount = expectedCount;
        this.expectedSum = expectedSum;
        this.segmentCount = segmentCount;
    }

    @Test
    public void test() throws Exception {
        this.testSimple();
        this.testSplit();
    }

    private void testSimple() throws Exception {
        int count = 0;
        long sum = 0L;
        try (Firehose firehose = this.factory.connect(ROW_PARSER, this.tmpDir);){
            while (firehose.hasMore()) {
                InputRow row = firehose.nextRow();
                ++count;
                sum += row.getMetric(METRICS[0]).longValue();
            }
        }
        Assert.assertEquals((String)"count", (long)this.expectedCount, (long)count);
        Assert.assertEquals((String)"sum", (long)this.expectedSum, (long)sum);
    }

    private void testSplit() throws Exception {
        Assert.assertTrue((boolean)this.factory.isSplittable());
        int numSplits = this.factory.getNumSplits(null);
        Assert.assertEquals((long)this.segmentCount, (long)numSplits);
        List splits = this.factory.getSplits(null).collect(Collectors.toList());
        Assert.assertEquals((long)numSplits, (long)splits.size());
        int count = 0;
        long sum = 0L;
        for (InputSplit split : splits) {
            FiniteFirehoseFactory splitFactory = this.factory.withSplit(split);
            Firehose firehose = splitFactory.connect(ROW_PARSER, this.tmpDir);
            Throwable throwable = null;
            try {
                while (firehose.hasMore()) {
                    InputRow row = firehose.nextRow();
                    ++count;
                    sum += row.getMetric(METRICS[0]).longValue();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (firehose == null) continue;
                if (throwable != null) {
                    try {
                        firehose.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                firehose.close();
            }
        }
        Assert.assertEquals((String)"count", (long)this.expectedCount, (long)count);
        Assert.assertEquals((String)"sum", (long)this.expectedSum, (long)sum);
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    private static TestCase tc(String intervalString, int expectedCount, long expectedSum, DataSegmentMaker ... segmentMakers) {
        File tmpDir = FileUtils.createTempDir();
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (DataSegmentMaker segmentMaker : segmentMakers) {
            segments.add(segmentMaker.make(tmpDir));
        }
        return new TestCase(tmpDir, Intervals.of((String)intervalString), expectedCount, expectedSum, segments);
    }

    private static DataSegmentMaker ds(String intervalString, String version, int partitionNum, InputRow ... rows) {
        return new DataSegmentMaker(Intervals.of((String)intervalString), version, partitionNum, Arrays.asList(rows));
    }

    private static InputRow ir(String timeString, long metricValue) {
        return new MapBasedInputRow(DateTimes.of((String)timeString).getMillis(), Arrays.asList(DIMENSIONS), (Map)ImmutableMap.of((Object)TIME_COLUMN, (Object)DateTimes.of((String)timeString).toString(), (Object)DIMENSIONS[0], (Object)"bar", (Object)METRICS[0], (Object)metricValue));
    }

    private static Map<String, Object> persist(File tmpDir, InputRow ... rows) {
        File persistDir = new File(tmpDir, UUID.randomUUID().toString());
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(-4611686018427387904L).withDimensionsSpec(ROW_PARSER).withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory(METRICS[0], METRICS[0])}).build();
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(rows.length).build();
        for (InputRow row : rows) {
            try {
                index.add(row);
            }
            catch (IndexSizeExceededException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            INDEX_MERGER_V9.persist(index, persistDir, new IndexSpec(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)persistDir.getAbsolutePath());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        ImmutableList testCases = ImmutableList.of((Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000/2000T02", 3, 7L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T01", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T00:01", 2L)), IngestSegmentFirehoseFactoryTimelineTest.ds("2000T01/2000T02", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 4L))), (Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000/2000T02", 3, 7L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T02", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T00:01", 2L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 8L)), IngestSegmentFirehoseFactoryTimelineTest.ds("2000T01/2000T02", "v2", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01:01", 4L))), (Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000/2000-01-02", 4, 23L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000-01-02", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T00:01", 2L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 8L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T02", 16L)), IngestSegmentFirehoseFactoryTimelineTest.ds("2000T01/2000T02", "v2", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01:01", 4L))), (Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000/2000T02", 4, 15L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T02", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T00:01", 2L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 8L)), IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T02", "v1", 1, IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01:01", 4L))), (Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000T01/2000T02", 1, 2L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T03", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 2L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T02", 4L))), (Object)IngestSegmentFirehoseFactoryTimelineTest.tc("2000T02/2000T04", 2, 12L, IngestSegmentFirehoseFactoryTimelineTest.ds("2000/2000T03", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000", 1L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T01", 2L), IngestSegmentFirehoseFactoryTimelineTest.ir("2000T02", 4L)), IngestSegmentFirehoseFactoryTimelineTest.ds("2000T03/2000T04", "v1", 0, IngestSegmentFirehoseFactoryTimelineTest.ir("2000T03", 8L))));
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (final TestCase testCase : testCases) {
            SegmentHandoffNotifierFactory notifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
            EasyMock.replay((Object[])new Object[]{notifierFactory});
            SegmentCacheManagerFactory slf = new SegmentCacheManagerFactory(MAPPER);
            RetryPolicyFactory retryPolicyFactory = new RetryPolicyFactory(new RetryPolicyConfig());
            CoordinatorClient cc = new CoordinatorClient(null, null){

                public Collection<DataSegment> fetchUsedSegmentsInDataSourceForIntervals(String dataSource, List<Interval> intervals) {
                    if (intervals.equals(ImmutableList.of((Object)testCase.interval))) {
                        return ImmutableSet.copyOf(testCase.segments);
                    }
                    throw new IllegalArgumentException("BAD");
                }

                public DataSegment fetchUsedSegment(String dataSource, String segmentId) {
                    return testCase.segments.stream().filter(s -> s.getId().toString().equals(segmentId)).findAny().get();
                }
            };
            IngestSegmentFirehoseFactory factory = new IngestSegmentFirehoseFactory(DATA_SOURCE, testCase.interval, null, (DimFilter)TrueDimFilter.instance(), Arrays.asList(DIMENSIONS), Arrays.asList(METRICS), Long.valueOf(1L), INDEX_IO, cc, slf, retryPolicyFactory);
            constructors.add(new Object[]{testCase.toString(), factory, testCase.tmpDir, testCase.expectedCount, testCase.expectedSum, testCase.segments.size()});
        }
        return constructors;
    }

    static {
        TestUtils testUtils = new TestUtils();
        MAPPER = IngestSegmentFirehoseFactoryTest.setupInjectablesInObjectMapper(testUtils.getTestObjectMapper());
        INDEX_IO = testUtils.getTestIndexIO();
        INDEX_MERGER_V9 = testUtils.getTestIndexMergerV9();
    }

    private static class DataSegmentMaker {
        final Interval interval;
        final String version;
        final int partitionNum;
        final List<InputRow> rows;

        public DataSegmentMaker(Interval interval, String version, int partitionNum, List<InputRow> rows) {
            this.interval = interval;
            this.version = version;
            this.partitionNum = partitionNum;
            this.rows = rows;
        }

        public DataSegment make(File tmpDir) {
            Map loadSpec = IngestSegmentFirehoseFactoryTimelineTest.persist(tmpDir, (InputRow[])Iterables.toArray(this.rows, InputRow.class));
            return new DataSegment(IngestSegmentFirehoseFactoryTimelineTest.DATA_SOURCE, this.interval, this.version, loadSpec, Arrays.asList(DIMENSIONS), Arrays.asList(METRICS), (ShardSpec)new LinearShardSpec(Integer.valueOf(this.partitionNum)), Integer.valueOf(-1), 2L);
        }
    }

    private static class TestCase {
        final File tmpDir;
        final Interval interval;
        final int expectedCount;
        final long expectedSum;
        final Set<DataSegment> segments;

        public TestCase(File tmpDir, Interval interval, int expectedCount, long expectedSum, Set<DataSegment> segments) {
            this.tmpDir = tmpDir;
            this.interval = interval;
            this.expectedCount = expectedCount;
            this.expectedSum = expectedSum;
            this.segments = segments;
        }

        public String toString() {
            ArrayList<SegmentId> segmentIds = new ArrayList<SegmentId>();
            for (DataSegment segment : this.segments) {
                segmentIds.add(segment.getId());
            }
            return "TestCase{interval=" + this.interval + ", expectedCount=" + this.expectedCount + ", expectedSum=" + this.expectedSum + ", segments=" + segmentIds + '}';
        }
    }
}

