/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.input.DruidSegmentInputFormat;
import org.apache.druid.indexing.input.DruidSegmentReader;
import org.apache.druid.indexing.input.DruidSegmentReaderTest;
import org.apache.druid.indexing.input.DruidTombstoneSegmentReader;
import org.apache.druid.java.util.common.Intervals;
import org.junit.Assert;
import org.junit.Test;

public class DruidSegmentInputFormatTest {
    private static final InputRowSchema INPUT_ROW_SCHEMA = new InputRowSchema(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "name"))), ColumnsFilter.all());

    @Test
    public void testDruidSegmentInputEntityReader() {
        DruidSegmentInputFormat format = new DruidSegmentInputFormat(null, null);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)DruidSegmentReaderTest.makeInputEntity(Intervals.of((String)"2000/P1D"), null, (List<String>)ImmutableList.of((Object)"s", (Object)"d"), (List<String>)ImmutableList.of((Object)"cnt", (Object)"met_s")), null);
        Assert.assertTrue((boolean)(reader instanceof DruidSegmentReader));
    }

    @Test
    public void testDruidTombstoneSegmentInputEntityReader() {
        DruidSegmentInputFormat format = new DruidSegmentInputFormat(null, null);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)DruidSegmentReaderTest.makeTombstoneInputEntity(Intervals.of((String)"2000/P1D")), null);
        Assert.assertTrue((boolean)(reader instanceof DruidTombstoneSegmentReader));
    }

    @Test
    public void testDruidSegmentInputEntityReaderBadEntity() {
        DruidSegmentInputFormat format = new DruidSegmentInputFormat(null, null);
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> format.createReader(INPUT_ROW_SCHEMA, (InputEntity)new FileEntity(null), null));
        String expectedMessage = "org.apache.druid.indexing.input.DruidSegmentInputEntity required, but org.apache.druid.data.input.impl.FileEntity provided.";
        String actualMessage = exception.getMessage();
        Assert.assertEquals((Object)expectedMessage, (Object)actualMessage);
    }
}

