/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.druid.common.config.NullHandlingTest;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.hll.HyperLogLogHash;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.indexing.input.DruidSegmentReader;
import org.apache.druid.indexing.input.DruidTombstoneSegmentReader;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DruidSegmentReaderTest
extends NullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File segmentDirectory;
    private final IndexIO indexIO = TestHelper.getTestIndexIO();
    private DimensionsSpec dimensionsSpec;
    private List<AggregatorFactory> metrics;
    private List<InputRow> rows;

    @Before
    public void setUp() throws IOException {
        this.dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol")));
        this.metrics = ImmutableList.of((Object)new CountAggregatorFactory("cnt"), (Object)new HyperUniquesAggregatorFactory("met_s", "strCol"));
        this.rows = ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).build()));
        this.createTestSetup();
    }

    @Test
    public void testReader() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "millis", DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderWhenFilteringOnLongColumn() throws IOException {
        this.dimensionsSpec = new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("longCol"), (Object)StringDimensionSchema.create((String)"a"), (Object)StringDimensionSchema.create((String)"b")));
        this.metrics = ImmutableList.of();
        ImmutableList columnNames = ImmutableList.of((Object)"longCol", (Object)"a", (Object)"b");
        this.rows = ImmutableList.of((Object)new MapBasedInputRow(DateTimes.utc((long)1667115726217L), (List)columnNames, (Map)ImmutableMap.builder().put((Object)"__time", (Object)1667115726217L).put((Object)"longCol", (Object)0L).put((Object)"a", (Object)"foo1").put((Object)"b", (Object)"bar1").build()), (Object)new MapBasedInputRow(DateTimes.utc((long)1667115726224L), (List)columnNames, (Map)ImmutableMap.builder().put((Object)"__time", (Object)1667115726224L).put((Object)"longCol", (Object)0L).put((Object)"a", (Object)"foo2").put((Object)"b", (Object)"bar2").build()), (Object)new MapBasedInputRow(DateTimes.utc((long)1667115726128L), (List)columnNames, (Map)ImmutableMap.builder().put((Object)"__time", (Object)1667115726128L).put((Object)"longCol", (Object)5L).put((Object)"a", (Object)"foo3").put((Object)"b", (Object)"bar3").build()));
        this.createTestSetup();
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntityWithParams(Intervals.of((String)"2022-10-30/2022-10-31"), (List<String>)columnNames, null), this.indexIO, new TimestampSpec("__time", "iso", null), this.dimensionsSpec, ColumnsFilter.all(), (DimFilter)new OrDimFilter(new DimFilter[]{new SelectorDimFilter("longCol", "5", null), new NotDimFilter((DimFilter)new SelectorDimFilter("a", "foo1", null)), new NotDimFilter((DimFilter)new SelectorDimFilter("b", "bar1", null))}), this.temporaryFolder.newFolder());
        ArrayList<InputRow> expectedRows = new ArrayList<InputRow>();
        expectedRows.add(this.rows.get(2));
        expectedRows.add(this.rows.get(1));
        Assert.assertEquals(expectedRows, this.readRows(reader));
    }

    @Test
    public void testDruidTombstoneSegmentReader() throws IOException {
        DruidTombstoneSegmentReader reader = new DruidTombstoneSegmentReader((InputEntity)DruidSegmentReaderTest.makeTombstoneInputEntity(Intervals.of((String)"2000/P1D")));
        Assert.assertFalse((boolean)reader.intermediateRowIterator().hasNext());
        Assert.assertEquals(Collections.emptyList(), this.readRows(reader));
    }

    @Test
    public void testDruidTombstoneSegmentReaderBadEntity() {
        Assert.assertThrows(ClassCastException.class, () -> new DruidTombstoneSegmentReader((InputEntity)new FileEntity(null)));
    }

    @Test
    public void testDruidTombstoneSegmentReaderNotCreatedFromTombstone() {
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> new DruidTombstoneSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D"))));
        String expectedMessage = "DruidSegmentInputEntity must be created from a tombstone but is not.";
        String actualMessage = exception.getMessage();
        Assert.assertEquals((Object)expectedMessage, (Object)actualMessage);
    }

    @Test
    public void testReaderAutoTimestampFormat() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "auto", DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderWithDimensionExclusions() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "millis", DateTimes.of((String)"1971")), DimensionsSpec.builder().setDimensionExclusions((List)ImmutableList.of((Object)"__time", (Object)"strCol", (Object)"cnt", (Object)"met_s")).build(), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderWithInclusiveColumnsFilter() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "millis", DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"__time", (Object)"strCol", (Object)"dblCol")), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).build())), this.readRows(reader));
    }

    @Test
    public void testReaderWithInclusiveColumnsFilterNoTimestamp() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "millis", DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"strCol", (Object)"dblCol")), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"1971"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"1971"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).build())), this.readRows(reader));
    }

    @Test
    public void testReaderWithFilter() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "millis", DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), (DimFilter)new SelectorDimFilter("dblCol", "1.23", null), this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderTimestampFromDouble() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("dblCol", "posix", null), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"1970-01-01T00:00:01.000Z"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"1970-01-01T00:00:04.000Z"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderTimestampAsPosixIncorrectly() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec("__time", "posix", null), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"31969-04-01T00:00:00.000Z"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"31969-05-12T16:00:00.000Z"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testReaderTimestampSpecDefault() throws IOException {
        DruidSegmentReader reader = new DruidSegmentReader((InputEntity)this.makeInputEntity(Intervals.of((String)"2000/P1D")), this.indexIO, new TimestampSpec(null, null, DateTimes.of((String)"1971")), new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"strCol"), (Object)new DoubleDimensionSchema("dblCol"))), ColumnsFilter.all(), null, this.temporaryFolder.newFolder());
        Assert.assertEquals((Object)ImmutableList.of((Object)new MapBasedInputRow(DateTimes.of((String)"1971"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T").getMillis()).put((Object)"strCol", (Object)"foo").put((Object)"dblCol", (Object)1.23).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("foo")).build()), (Object)new MapBasedInputRow(DateTimes.of((String)"1971"), (List)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (Map)ImmutableMap.builder().put((Object)"__time", (Object)DateTimes.of((String)"2000T01").getMillis()).put((Object)"strCol", (Object)"bar").put((Object)"dblCol", (Object)4.56).put((Object)"cnt", (Object)1L).put((Object)"met_s", (Object)DruidSegmentReaderTest.makeHLLC("bar")).build())), this.readRows(reader));
    }

    @Test
    public void testMakeCloseableIteratorFromSequenceAndSegmentFileCloseYielderOnClose() throws IOException {
        final MutableBoolean isSequenceClosed = new MutableBoolean(false);
        final MutableBoolean isFileClosed = new MutableBoolean(false);
        BaseSequence sequence = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Map<String, Object>, Iterator<Map<String, Object>>>(){

            public Iterator<Map<String, Object>> make() {
                return Collections.emptyIterator();
            }

            public void cleanup(Iterator<Map<String, Object>> iterFromMake) {
                isSequenceClosed.setValue(true);
            }
        });
        InputEntity.CleanableFile cleanableFile = new InputEntity.CleanableFile(){

            public File file() {
                return null;
            }

            public void close() {
                isFileClosed.setValue(true);
            }
        };
        try (CloseableIterator iterator = DruidSegmentReader.makeCloseableIteratorFromSequenceAndSegmentFile((Sequence)sequence, (InputEntity.CleanableFile)cleanableFile);){
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        Assert.assertTrue((String)"File is not closed", (boolean)isFileClosed.booleanValue());
        Assert.assertTrue((String)"Sequence is not closed", (boolean)isSequenceClosed.booleanValue());
    }

    private DruidSegmentInputEntity makeInputEntity(Interval interval) {
        return DruidSegmentReaderTest.makeInputEntity(interval, this.segmentDirectory, (List<String>)ImmutableList.of((Object)"strCol", (Object)"dblCol"), (List<String>)ImmutableList.of((Object)"cnt", (Object)"met_s"));
    }

    private DruidSegmentInputEntity makeInputEntityWithParams(Interval interval, List<String> dimensions, List<String> metrics) {
        return DruidSegmentReaderTest.makeInputEntity(interval, this.segmentDirectory, dimensions, metrics);
    }

    public static DruidSegmentInputEntity makeInputEntity(Interval interval, final File segmentDirectory, List<String> dimensions, List<String> metrics) {
        return new DruidSegmentInputEntity(new SegmentCacheManager(){

            public boolean isSegmentCached(DataSegment segment) {
                throw new UnsupportedOperationException("unused");
            }

            public File getSegmentFiles(DataSegment segment) {
                return segmentDirectory;
            }

            public void cleanup(DataSegment segment) {
                throw new UnsupportedOperationException("unused");
            }

            public boolean reserve(DataSegment segment) {
                throw new UnsupportedOperationException();
            }

            public boolean release(DataSegment segment) {
                throw new UnsupportedOperationException();
            }

            public void loadSegmentIntoPageCache(DataSegment segment, ExecutorService exec) {
                throw new UnsupportedOperationException();
            }
        }, DataSegment.builder().dataSource("ds").dimensions(dimensions).metrics(metrics).interval(interval).version("1").size(0L).build(), interval);
    }

    public static DruidSegmentInputEntity makeTombstoneInputEntity(Interval interval) {
        return new DruidSegmentInputEntity(new SegmentCacheManager(){

            public boolean isSegmentCached(DataSegment segment) {
                throw new UnsupportedOperationException("unused");
            }

            public File getSegmentFiles(DataSegment segment) {
                throw new UnsupportedOperationException("unused");
            }

            public void cleanup(DataSegment segment) {
                throw new UnsupportedOperationException("unused");
            }

            public boolean reserve(DataSegment segment) {
                throw new UnsupportedOperationException();
            }

            public boolean release(DataSegment segment) {
                throw new UnsupportedOperationException();
            }

            public void loadSegmentIntoPageCache(DataSegment segment, ExecutorService exec) {
                throw new UnsupportedOperationException();
            }
        }, DataSegment.builder().dataSource("ds").interval(Intervals.of((String)"2000/P1D")).version("1").shardSpec((ShardSpec)new TombstoneShardSpec()).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone")).size(1L).build(), interval);
    }

    private List<InputRow> readRows(DruidSegmentReader reader) throws IOException {
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        try (CloseableIterator iterator = reader.intermediateRowIterator();){
            while (iterator.hasNext()) {
                rows.addAll(reader.parseInputRows((Map)iterator.next()));
            }
        }
        return rows;
    }

    private List<InputRow> readRows(DruidTombstoneSegmentReader reader) throws IOException {
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        try (CloseableIterator iterator = reader.intermediateRowIterator();){
            while (iterator.hasNext()) {
                rows.addAll(reader.parseInputRows((Map)iterator.next()));
            }
        }
        return rows;
    }

    private static HyperLogLogCollector makeHLLC(String ... values) {
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (String value : values) {
            collector.add(HyperLogLogHash.getDefault().hash(value));
        }
        return collector;
    }

    private void createTestSetup() throws IOException {
        this.segmentDirectory = this.temporaryFolder.newFolder();
        try (IncrementalIndex incrementalIndex = IndexBuilder.create().schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(this.dimensionsSpec).withMetrics(this.metrics.toArray(new AggregatorFactory[0])).withRollup(false).build()).rows(this.rows).buildIncrementalIndex();){
            TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OnHeapMemorySegmentWriteOutMediumFactory.instance()).persist(incrementalIndex, this.segmentDirectory, new IndexSpec(), null);
        }
    }
}

