/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.common.config.NullHandlingTest;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.input.InputRowSchemas;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.junit.Assert;
import org.junit.Test;

public class InputRowSchemasTest
extends NullHandlingTest {
    @Test
    public void test_createColumnsFilter_normal() {
        ColumnsFilter columnsFilter = InputRowSchemas.createColumnsFilter((TimestampSpec)new TimestampSpec("ts", "auto", null), (DimensionsSpec)new DimensionsSpec((List)ImmutableList.of((Object)StringDimensionSchema.create((String)"foo"))), (TransformSpec)new TransformSpec((DimFilter)new SelectorDimFilter("bar", "x", null), (List)ImmutableList.of((Object)new ExpressionTransform("baz", "qux + 3", ExprMacroTable.nil()))), (AggregatorFactory[])new AggregatorFactory[]{new LongSumAggregatorFactory("billy", "bob")});
        Assert.assertEquals((Object)ColumnsFilter.inclusionBased((Set)ImmutableSet.of((Object)"ts", (Object)"foo", (Object)"bar", (Object)"qux", (Object)"bob")), (Object)columnsFilter);
    }

    @Test
    public void test_createColumnsFilter_schemaless() {
        ColumnsFilter columnsFilter = InputRowSchemas.createColumnsFilter((TimestampSpec)new TimestampSpec("ts", "auto", null), (DimensionsSpec)DimensionsSpec.builder().setDimensionExclusions((List)ImmutableList.of((Object)"ts", (Object)"foo", (Object)"bar", (Object)"qux", (Object)"bob")).build(), (TransformSpec)new TransformSpec((DimFilter)new SelectorDimFilter("bar", "x", null), (List)ImmutableList.of((Object)new ExpressionTransform("baz", "qux + 3", ExprMacroTable.nil()))), (AggregatorFactory[])new AggregatorFactory[]{new LongSumAggregatorFactory("billy", "bob")});
        Assert.assertEquals((Object)ColumnsFilter.exclusionBased((Set)ImmutableSet.of((Object)"foo")), (Object)columnsFilter);
    }

    @Test
    public void testFromDataSchema() {
        TimestampSpec timestampSpec = new TimestampSpec(null, null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("d1"), new StringDimensionSchema("d2"), new LongDimensionSchema("d3"), new FloatDimensionSchema("d4"), new DoubleDimensionSchema("d5")));
        DataSchema schema = new DataSchema("dataSourceName", new TimestampSpec(null, null, null), dimensionsSpec, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null);
        InputRowSchema inputRowSchema = InputRowSchemas.fromDataSchema((DataSchema)schema);
        Assert.assertEquals((Object)timestampSpec, (Object)inputRowSchema.getTimestampSpec());
        Assert.assertEquals((Object)dimensionsSpec.getDimensions(), (Object)inputRowSchema.getDimensionsSpec().getDimensions());
        Assert.assertEquals((Object)dimensionsSpec.getDimensionNames(), (Object)inputRowSchema.getDimensionsSpec().getDimensionNames());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"count", (Object)"met"), (Object)inputRowSchema.getMetricNames());
    }

    @Test
    public void testFromDataSchemaWithNoAggregator() {
        TimestampSpec timestampSpec = new TimestampSpec(null, null, null);
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("d1"), new StringDimensionSchema("d2"), new LongDimensionSchema("d3"), new FloatDimensionSchema("d4"), new DoubleDimensionSchema("d5")));
        DataSchema schema = new DataSchema("dataSourceName", new TimestampSpec(null, null, null), dimensionsSpec, new AggregatorFactory[0], (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null);
        InputRowSchema inputRowSchema = InputRowSchemas.fromDataSchema((DataSchema)schema);
        Assert.assertEquals((Object)timestampSpec, (Object)inputRowSchema.getTimestampSpec());
        Assert.assertEquals((Object)dimensionsSpec.getDimensions(), (Object)inputRowSchema.getDimensionsSpec().getDimensions());
        Assert.assertEquals((Object)dimensionsSpec.getDimensionNames(), (Object)inputRowSchema.getDimensionsSpec().getDimensionNames());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)inputRowSchema.getMetricNames());
    }
}

