/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.indexing.overlord.PortFinder;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PortFinderTest {
    private final List<PortFinder> finders = new ArrayList<PortFinder>();

    @Before
    public void setUp() {
        PortFinder finder1 = (PortFinder)EasyMock.createMockBuilder(PortFinder.class).withConstructor(new Object[]{1200, 1201, ImmutableList.of()}).addMockedMethod("canBind").createMock();
        PortFinder finder2 = (PortFinder)EasyMock.createMockBuilder(PortFinder.class).withConstructor(new Object[]{1024, 1025, ImmutableList.of((Object)1200, (Object)1201)}).addMockedMethod("canBind").createMock();
        this.finders.add(finder1);
        this.finders.add(finder2);
    }

    @Test
    public void testUsedPort() {
        for (PortFinder finder : this.finders) {
            EasyMock.expect((Object)finder.canBind(1200)).andReturn((Object)true).andReturn((Object)false);
            EasyMock.expect((Object)finder.canBind(1201)).andReturn((Object)true);
            EasyMock.replay((Object[])new Object[]{finder});
            int port1 = finder.findUnusedPort();
            Assert.assertEquals((long)1200L, (long)port1);
            finder.markPortUnused(port1);
            int port2 = finder.findUnusedPort();
            Assert.assertEquals((long)1201L, (long)port2);
            finder.markPortUnused(port2);
            EasyMock.verify((Object[])new Object[]{finder});
        }
    }
}

