/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.indexing.overlord.RemoteTaskRunnerFactory;
import org.apache.druid.indexing.overlord.autoscaling.NoopProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RemoteTaskRunnerFactoryTest {
    @Test
    public void testBuildWithAutoScale() {
        ProvisioningSchedulerConfig provisioningSchedulerConfig = (ProvisioningSchedulerConfig)Mockito.mock(ProvisioningSchedulerConfig.class);
        Mockito.when((Object)provisioningSchedulerConfig.isDoAutoscale()).thenReturn((Object)true);
        RemoteTaskRunnerFactory remoteTaskRunnerFactory = this.getTestRemoteTaskRunnerFactory(provisioningSchedulerConfig);
        Assert.assertNull((Object)remoteTaskRunnerFactory.build().getProvisioningStrategy());
    }

    @Test
    public void testBuildWithoutAutoScale() {
        ProvisioningSchedulerConfig provisioningSchedulerConfig = (ProvisioningSchedulerConfig)Mockito.mock(ProvisioningSchedulerConfig.class);
        Mockito.when((Object)provisioningSchedulerConfig.isDoAutoscale()).thenReturn((Object)false);
        RemoteTaskRunnerFactory remoteTaskRunnerFactory = this.getTestRemoteTaskRunnerFactory(provisioningSchedulerConfig);
        Assert.assertTrue((boolean)(remoteTaskRunnerFactory.build().getProvisioningStrategy() instanceof NoopProvisioningStrategy));
    }

    private RemoteTaskRunnerFactory getTestRemoteTaskRunnerFactory(ProvisioningSchedulerConfig provisioningSchedulerConfig) {
        CuratorFramework curator = (CuratorFramework)Mockito.mock(CuratorFramework.class);
        Mockito.when((Object)curator.newWatcherRemoveCuratorFramework()).thenReturn(null);
        return new RemoteTaskRunnerFactory(curator, new RemoteTaskRunnerConfig(), new IndexerZkConfig(new ZkPathsConfig(), null, null, null, null), null, null, null, provisioningSchedulerConfig, null, null);
    }
}

