/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.MetadataTaskStorage;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskLockboxSyncResult;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.DerbyMetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TaskLockboxTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derby = new TestDerbyConnector.DerbyConnectorRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ObjectMapper objectMapper;
    private TaskStorage taskStorage;
    private IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private TaskLockbox lockbox;
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private static String TASK_NAME = "myModuleIsntLoadedTask";

    @Before
    public void setup() {
        this.objectMapper = TestHelper.makeJsonMapper();
        this.objectMapper.registerSubtypes(new Class[]{NumberedShardSpec.class, HashBasedNumberedShardSpec.class});
        TestDerbyConnector derbyConnector = this.derby.getConnector();
        derbyConnector.createTaskTables();
        derbyConnector.createPendingSegmentsTable();
        derbyConnector.createSegmentTable();
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.derby.metadataTablesConfigSupplier().get();
        this.taskStorage = new MetadataTaskStorage((MetadataStorageConnector)derbyConnector, new TaskStorageConfig(null), (MetadataStorageActionHandlerFactory)new DerbyMetadataStorageActionHandlerFactory((SQLMetadataConnector)derbyConnector, tablesConfig, this.objectMapper));
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        EasyMock.replay((Object[])new Object[]{emitter});
        this.metadataStorageCoordinator = new IndexerSQLMetadataStorageCoordinator(this.objectMapper, tablesConfig, (SQLMetadataConnector)derbyConnector);
        this.lockbox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
    }

    private LockResult acquireTimeChunkLock(TaskLockType lockType, Task task, Interval interval, long timeoutMs) throws InterruptedException {
        return this.lockbox.lock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null), timeoutMs);
    }

    private LockResult acquireTimeChunkLock(TaskLockType lockType, Task task, Interval interval) throws InterruptedException {
        return this.lockbox.lock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null));
    }

    private LockResult tryTimeChunkLock(TaskLockType lockType, Task task, Interval interval) {
        return this.lockbox.tryLock(task, (LockRequest)new TimeChunkLockRequest(lockType, task, interval, null));
    }

    @Test
    public void testLock() throws InterruptedException {
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        Assert.assertNotNull((Object)this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2015-01-01/2015-01-02")));
    }

    @Test(expected=IllegalStateException.class)
    public void testLockForInactiveTask() throws InterruptedException {
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)NoopTask.create(), Intervals.of((String)"2015-01-01/2015-01-02"));
    }

    @Test
    public void testLockAfterTaskComplete() throws InterruptedException {
        NoopTask task = NoopTask.create();
        this.exception.expect(ISE.class);
        this.exception.expectMessage("Unable to grant lock to inactive Task");
        this.lockbox.add((Task)task);
        this.lockbox.remove((Task)task);
        this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2015-01-01/2015-01-02"));
    }

    @Test
    public void testTrySharedLock() throws EntryExistsException {
        Interval interval = Intervals.of((String)"2017-01/2017-02");
        ArrayList<Task> tasks = new ArrayList<Task>();
        HashSet<TaskLock> activeLocks = new HashSet<TaskLock>();
        NoopTask exclusiveHigherPriorityRevokedLockTask = NoopTask.create((int)100);
        tasks.add((Task)exclusiveHigherPriorityRevokedLockTask);
        this.taskStorage.insert((Task)exclusiveHigherPriorityRevokedLockTask, TaskStatus.running((String)exclusiveHigherPriorityRevokedLockTask.getId()));
        this.lockbox.add((Task)exclusiveHigherPriorityRevokedLockTask);
        TaskLock exclusiveRevokedLock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)exclusiveHigherPriorityRevokedLockTask, interval).getTaskLock();
        NoopTask sharedLockTask = NoopTask.create((int)100);
        this.lockbox.add((Task)sharedLockTask);
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)sharedLockTask, interval).isOk());
        this.lockbox.revokeLock(exclusiveHigherPriorityRevokedLockTask.getId(), exclusiveRevokedLock);
        Assert.assertEquals((long)1L, (long)this.getAllLocks(tasks).size());
        Assert.assertEquals((long)0L, (long)this.getAllActiveLocks(tasks).size());
        Assert.assertEquals(activeLocks, this.getAllActiveLocks(tasks));
        for (int i = 0; i < 3; ++i) {
            NoopTask task = NoopTask.create((int)Math.max(0, (i - 1) * 10));
            tasks.add((Task)task);
            this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
            this.lockbox.add((Task)task);
            TaskLock lock = this.tryTimeChunkLock(TaskLockType.SHARED, (Task)task, interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            activeLocks.add(lock);
        }
        Assert.assertEquals((long)4L, (long)this.getAllLocks(tasks).size());
        Assert.assertEquals((long)3L, (long)this.getAllActiveLocks(tasks).size());
        Assert.assertEquals(activeLocks, this.getAllActiveLocks(tasks));
        NoopTask exclusiveLowerPriorityLockTask = NoopTask.create((int)15);
        tasks.add((Task)exclusiveLowerPriorityLockTask);
        this.taskStorage.insert((Task)exclusiveLowerPriorityLockTask, TaskStatus.running((String)exclusiveLowerPriorityLockTask.getId()));
        this.lockbox.add((Task)exclusiveLowerPriorityLockTask);
        TaskLock lowerPriorityExclusiveLock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)exclusiveLowerPriorityLockTask, interval).getTaskLock();
        activeLocks.clear();
        activeLocks.add(lowerPriorityExclusiveLock);
        Assert.assertEquals((long)5L, (long)this.getAllLocks(tasks).size());
        Assert.assertEquals((long)1L, (long)this.getAllActiveLocks(tasks).size());
        Assert.assertEquals(activeLocks, this.getAllActiveLocks(tasks));
        activeLocks.clear();
        for (int i = 3; i < 5; ++i) {
            NoopTask task = NoopTask.create((int)Math.max(0, (i - 1) * 10));
            tasks.add((Task)task);
            this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
            this.lockbox.add((Task)task);
            TaskLock lock = this.tryTimeChunkLock(TaskLockType.SHARED, (Task)task, interval).getTaskLock();
            Assert.assertNotNull((Object)lock);
            activeLocks.add(lock);
        }
        Assert.assertEquals((long)7L, (long)this.getAllLocks(tasks).size());
        Assert.assertEquals((long)2L, (long)this.getAllActiveLocks(tasks).size());
        Assert.assertEquals(activeLocks, this.getAllActiveLocks(tasks));
    }

    @Test
    public void testTryMixedLocks() throws EntryExistsException {
        NoopTask lowPriorityTask = NoopTask.create((int)0);
        NoopTask lowPriorityTask2 = NoopTask.create((int)0);
        NoopTask highPiorityTask = NoopTask.create((int)10);
        Interval interval1 = Intervals.of((String)"2017-01-01/2017-01-02");
        Interval interval2 = Intervals.of((String)"2017-01-02/2017-01-03");
        Interval interval3 = Intervals.of((String)"2017-01-03/2017-01-04");
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.taskStorage.insert((Task)lowPriorityTask2, TaskStatus.running((String)lowPriorityTask2.getId()));
        this.taskStorage.insert((Task)highPiorityTask, TaskStatus.running((String)highPiorityTask.getId()));
        this.lockbox.add((Task)lowPriorityTask);
        this.lockbox.add((Task)lowPriorityTask2);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval1).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)lowPriorityTask, interval2).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)lowPriorityTask2, interval2).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval3).isOk());
        this.lockbox.add((Task)highPiorityTask);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)highPiorityTask, interval1).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPiorityTask, interval2).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPiorityTask, interval3).isOk());
        Assert.assertTrue((boolean)this.lockbox.findLocksForTask((Task)lowPriorityTask).stream().allMatch(TaskLock::isRevoked));
        Assert.assertTrue((boolean)this.lockbox.findLocksForTask((Task)lowPriorityTask2).stream().allMatch(TaskLock::isRevoked));
        this.lockbox.remove((Task)lowPriorityTask);
        this.lockbox.remove((Task)lowPriorityTask2);
        this.lockbox.remove((Task)highPiorityTask);
        this.lockbox.add((Task)highPiorityTask);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPiorityTask, interval1).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)highPiorityTask, interval2).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPiorityTask, interval3).isOk());
        this.lockbox.add((Task)lowPriorityTask);
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)lowPriorityTask, interval1).isOk());
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval2).isOk());
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval3).isOk());
    }

    @Test
    public void testTryExclusiveLock() {
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2015-01-01/2015-01-03")).isOk());
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task2);
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02")).isOk());
        this.lockbox.remove((Task)task);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02")).isOk());
    }

    @Test(expected=IllegalStateException.class)
    public void testTryLockForInactiveTask() {
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)NoopTask.create(), Intervals.of((String)"2015-01-01/2015-01-02")).isOk());
    }

    @Test
    public void testTryLockAfterTaskComplete() {
        NoopTask task = NoopTask.create();
        this.exception.expect(ISE.class);
        this.exception.expectMessage("Unable to grant lock to inactive Task");
        this.lockbox.add((Task)task);
        this.lockbox.remove((Task)task);
        Assert.assertFalse((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2015-01-01/2015-01-02")).isOk());
    }

    @Test
    public void testTimeoutForLock() throws InterruptedException {
        NoopTask task1 = NoopTask.create();
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task1);
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), 5000L).isOk());
        Assert.assertFalse((boolean)this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-15"), 1000L).isOk());
    }

    @Test
    public void testSyncFromStorage() throws EntryExistsException {
        TaskLockbox originalBox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        for (int i = 0; i < 5; ++i) {
            NoopTask task2 = NoopTask.create();
            this.taskStorage.insert((Task)task2, TaskStatus.running((String)task2.getId()));
            originalBox.add((Task)task2);
            Assert.assertTrue((boolean)originalBox.tryLock((Task)task2, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2})), null)).isOk());
        }
        List beforeLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(task -> this.taskStorage.getLocks(task.getId()).stream()).collect(Collectors.toList());
        TaskLockbox newBox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        newBox.syncFromStorage();
        Assert.assertEquals((Object)originalBox.getAllLocks(), (Object)newBox.getAllLocks());
        Assert.assertEquals((Object)originalBox.getActiveTasks(), (Object)newBox.getActiveTasks());
        List afterLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(task -> this.taskStorage.getLocks(task.getId()).stream()).collect(Collectors.toList());
        Assert.assertEquals(beforeLocksInStorage, afterLocksInStorage);
    }

    @Test
    public void testSyncFromStorageWithMissingTaskLockPriority() throws EntryExistsException {
        NoopTask task = NoopTask.create();
        this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
        this.taskStorage.addLock(task.getId(), (TaskLock)new IntervalLockWithoutPriority(task.getGroupId(), task.getDataSource(), Intervals.of((String)"2017/2018"), "v1"));
        List beforeLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(t -> this.taskStorage.getLocks(t.getId()).stream()).collect(Collectors.toList());
        TaskLockbox lockbox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        lockbox.syncFromStorage();
        List afterLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(t -> this.taskStorage.getLocks(t.getId()).stream()).collect(Collectors.toList());
        Assert.assertEquals(beforeLocksInStorage, afterLocksInStorage);
    }

    @Test
    public void testSyncFromStorageWithMissingTaskPriority() throws EntryExistsException {
        NoopTask task = NoopTask.create();
        this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
        this.taskStorage.addLock(task.getId(), (TaskLock)new TimeChunkLock(TaskLockType.EXCLUSIVE, task.getGroupId(), task.getDataSource(), Intervals.of((String)"2017/2018"), "v1", task.getPriority()));
        List beforeLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(t -> this.taskStorage.getLocks(t.getId()).stream()).collect(Collectors.toList());
        TaskLockbox lockbox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        lockbox.syncFromStorage();
        List afterLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(t -> this.taskStorage.getLocks(t.getId()).stream()).collect(Collectors.toList());
        Assert.assertEquals(beforeLocksInStorage, afterLocksInStorage);
    }

    @Test
    public void testSyncFromStorageWithInvalidPriority() throws EntryExistsException {
        NoopTask task = NoopTask.create();
        this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
        this.taskStorage.addLock(task.getId(), (TaskLock)new TimeChunkLock(TaskLockType.EXCLUSIVE, task.getGroupId(), task.getDataSource(), Intervals.of((String)"2017/2018"), "v1", 10));
        TaskLockbox lockbox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("lock priority[10] is different from task priority[50]");
        lockbox.syncFromStorage();
    }

    @Test
    public void testSyncWithUnknownTaskTypesFromModuleNotLoaded() throws Exception {
        TestDerbyConnector derbyConnector = this.derby.getConnector();
        ObjectMapper loadedMapper = new DefaultObjectMapper().registerModule((Module)new TheModule());
        MetadataTaskStorage loadedTaskStorage = new MetadataTaskStorage((MetadataStorageConnector)derbyConnector, new TaskStorageConfig(null), (MetadataStorageActionHandlerFactory)new DerbyMetadataStorageActionHandlerFactory((SQLMetadataConnector)derbyConnector, (MetadataStorageTablesConfig)this.derby.metadataTablesConfigSupplier().get(), loadedMapper));
        IndexerSQLMetadataStorageCoordinator loadedMetadataStorageCoordinator = new IndexerSQLMetadataStorageCoordinator(loadedMapper, (MetadataStorageTablesConfig)this.derby.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)derbyConnector);
        TaskLockbox theBox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        TaskLockbox loadedBox = new TaskLockbox((TaskStorage)loadedTaskStorage, (IndexerMetadataStorageCoordinator)loadedMetadataStorageCoordinator);
        NoopTask aTask = NoopTask.create();
        this.taskStorage.insert((Task)aTask, TaskStatus.running((String)aTask.getId()));
        theBox.add((Task)aTask);
        loadedBox.add((Task)aTask);
        MyModuleIsntLoadedTask theTask = new MyModuleIsntLoadedTask("1", "yey", null, "foo");
        loadedTaskStorage.insert((Task)theTask, TaskStatus.running((String)theTask.getId()));
        theBox.add((Task)theTask);
        loadedBox.add((Task)theTask);
        List tasks = this.taskStorage.getActiveTasks();
        List tasksFromLoaded = loadedTaskStorage.getActiveTasks();
        theBox.syncFromStorage();
        loadedBox.syncFromStorage();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)2L, (long)tasksFromLoaded.size());
    }

    @Test
    public void testRevokedLockSyncFromStorage() throws EntryExistsException {
        TaskLockbox originalBox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        NoopTask task1 = NoopTask.create((String)"task1", (int)10);
        this.taskStorage.insert((Task)task1, TaskStatus.running((String)task1.getId()));
        originalBox.add((Task)task1);
        Assert.assertTrue((boolean)originalBox.tryLock((Task)task1, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2017/2018"), null)).isOk());
        NoopTask task2 = NoopTask.create((String)"task2", (int)100);
        this.taskStorage.insert((Task)task2, TaskStatus.running((String)task2.getId()));
        originalBox.add((Task)task2);
        Assert.assertTrue((boolean)originalBox.tryLock((Task)task2, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2017/2018"), null)).isOk());
        Map<String, List> beforeLocksInStorage = this.taskStorage.getActiveTasks().stream().collect(Collectors.toMap(Task::getId, task -> this.taskStorage.getLocks(task.getId())));
        List task1Locks = beforeLocksInStorage.get("task1");
        Assert.assertEquals((long)1L, (long)task1Locks.size());
        Assert.assertTrue((boolean)((TaskLock)task1Locks.get(0)).isRevoked());
        List task2Locks = beforeLocksInStorage.get("task1");
        Assert.assertEquals((long)1L, (long)task2Locks.size());
        Assert.assertTrue((boolean)((TaskLock)task2Locks.get(0)).isRevoked());
        TaskLockbox newBox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        newBox.syncFromStorage();
        Set afterLocksInStorage = this.taskStorage.getActiveTasks().stream().flatMap(task -> this.taskStorage.getLocks(task.getId()).stream()).collect(Collectors.toSet());
        Assert.assertEquals(beforeLocksInStorage.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), afterLocksInStorage);
    }

    @Test
    public void testDoInCriticalSectionWithSharedLock() throws Exception {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)task, interval).isOk());
        Assert.assertTrue((boolean)((Boolean)this.lockbox.doInCriticalSection((Task)task, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> true).onInvalidLocks(() -> false).build())));
    }

    @Test
    public void testDoInCriticalSectionWithExclusiveLock() throws Exception {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        TaskLock lock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, interval).getTaskLock();
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)((Boolean)this.lockbox.doInCriticalSection((Task)task, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> true).onInvalidLocks(() -> false).build())));
    }

    @Test
    public void testDoInCriticalSectionWithSmallerInterval() throws Exception {
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        Interval smallInterval = Intervals.of((String)"2017-01-10/2017-01-11");
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        TaskLock lock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, interval).getTaskLock();
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)((Boolean)this.lockbox.doInCriticalSection((Task)task, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> true).onInvalidLocks(() -> false).build())));
    }

    @Test
    public void testPreemptionAndDoInCriticalSection() throws Exception {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        for (int i = 0; i < 5; ++i) {
            NoopTask task = NoopTask.create();
            this.lockbox.add((Task)task);
            this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
            Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.SHARED, (Task)task, interval).isOk());
        }
        NoopTask highPriorityTask = NoopTask.create((int)100);
        this.lockbox.add((Task)highPriorityTask);
        this.taskStorage.insert((Task)highPriorityTask, TaskStatus.running((String)highPriorityTask.getId()));
        TaskLock lock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPriorityTask, interval).getTaskLock();
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)((Boolean)this.lockbox.doInCriticalSection((Task)highPriorityTask, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> true).onInvalidLocks(() -> false).build())));
    }

    @Test
    public void testDoInCriticalSectionWithRevokedLock() throws Exception {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        NoopTask lowPriorityTask = NoopTask.create((String)"task1", (int)0);
        NoopTask highPriorityTask = NoopTask.create((String)"task2", (int)10);
        this.lockbox.add((Task)lowPriorityTask);
        this.lockbox.add((Task)highPriorityTask);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.taskStorage.insert((Task)highPriorityTask, TaskStatus.running((String)highPriorityTask.getId()));
        TaskLock lowPriorityLock = this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval).getTaskLock();
        Assert.assertNotNull((Object)lowPriorityLock);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPriorityTask, interval).isOk());
        Assert.assertTrue((boolean)((TaskLock)Iterables.getOnlyElement((Iterable)this.lockbox.findLocksForTask((Task)lowPriorityTask))).isRevoked());
        Assert.assertFalse((boolean)((Boolean)this.lockbox.doInCriticalSection((Task)lowPriorityTask, Collections.singletonList(interval), CriticalAction.builder().onValidLocks(() -> true).onInvalidLocks(() -> false).build())));
    }

    @Test(timeout=60000L)
    public void testAcquireLockAfterRevoked() throws EntryExistsException, InterruptedException {
        Interval interval = Intervals.of((String)"2017-01-01/2017-01-02");
        NoopTask lowPriorityTask = NoopTask.create((String)"task1", (int)0);
        NoopTask highPriorityTask = NoopTask.create((String)"task2", (int)10);
        this.lockbox.add((Task)lowPriorityTask);
        this.lockbox.add((Task)highPriorityTask);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.taskStorage.insert((Task)highPriorityTask, TaskStatus.running((String)highPriorityTask.getId()));
        TaskLock lowPriorityLock = this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval).getTaskLock();
        Assert.assertNotNull((Object)lowPriorityLock);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPriorityTask, interval).isOk());
        Assert.assertTrue((boolean)((TaskLock)Iterables.getOnlyElement((Iterable)this.lockbox.findLocksForTask((Task)lowPriorityTask))).isRevoked());
        this.lockbox.unlock((Task)highPriorityTask, interval);
        LockResult lockResult = this.acquireTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, interval);
        Assert.assertFalse((boolean)lockResult.isOk());
        Assert.assertTrue((boolean)lockResult.isRevoked());
        Assert.assertTrue((boolean)((TaskLock)Iterables.getOnlyElement((Iterable)this.lockbox.findLocksForTask((Task)lowPriorityTask))).isRevoked());
    }

    @Test
    public void testUnlock() throws EntryExistsException {
        NoopTask task;
        int i;
        ArrayList<NoopTask> lowPriorityTasks = new ArrayList<NoopTask>();
        ArrayList<NoopTask> highPriorityTasks = new ArrayList<NoopTask>();
        for (i = 0; i < 8; ++i) {
            task = NoopTask.create((int)10);
            lowPriorityTasks.add(task);
            this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
            this.lockbox.add((Task)task);
            Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2}))).isOk());
        }
        for (i = 0; i < 4; ++i) {
            task = NoopTask.create((int)100);
            highPriorityTasks.add(task);
            this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
            this.lockbox.add((Task)task);
            Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2}))).isOk());
        }
        for (i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)this.taskStorage.getLocks(((Task)lowPriorityTasks.get(i)).getId()).stream().allMatch(TaskLock::isRevoked));
            Assert.assertFalse((boolean)this.taskStorage.getLocks(((Task)highPriorityTasks.get(i)).getId()).stream().allMatch(TaskLock::isRevoked));
        }
        for (i = 4; i < 8; ++i) {
            Assert.assertFalse((boolean)this.taskStorage.getLocks(((Task)lowPriorityTasks.get(i)).getId()).stream().allMatch(TaskLock::isRevoked));
        }
        for (i = 0; i < 4; ++i) {
            this.lockbox.unlock((Task)lowPriorityTasks.get(i), Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2})));
            this.lockbox.unlock((Task)highPriorityTasks.get(i), Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2})));
        }
        for (i = 4; i < 8; ++i) {
            this.lockbox.unlock((Task)lowPriorityTasks.get(i), Intervals.of((String)StringUtils.format((String)"2017-01-0%d/2017-01-0%d", (Object[])new Object[]{i + 1, i + 2})));
        }
        Assert.assertTrue((boolean)this.lockbox.getAllLocks().isEmpty());
    }

    @Test
    public void testFindLockPosseAfterRevokeWithDifferentLockIntervals() throws EntryExistsException {
        NoopTask lowPriorityTask = NoopTask.create((int)0);
        NoopTask highPriorityTask = NoopTask.create((int)10);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.taskStorage.insert((Task)highPriorityTask, TaskStatus.running((String)highPriorityTask.getId()));
        this.lockbox.add((Task)lowPriorityTask);
        this.lockbox.add((Task)highPriorityTask);
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, Intervals.of((String)"2018-12-16T09:00:00/2018-12-16T10:00:00")).isOk());
        Assert.assertTrue((boolean)this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPriorityTask, Intervals.of((String)"2018-12-16T09:00:00/2018-12-16T09:30:00")).isOk());
        List highLockPosses = this.lockbox.getOnlyTaskLockPosseContainingInterval((Task)highPriorityTask, Intervals.of((String)"2018-12-16T09:00:00/2018-12-16T09:30:00"));
        Assert.assertEquals((long)1L, (long)highLockPosses.size());
        Assert.assertTrue((boolean)((TaskLockbox.TaskLockPosse)highLockPosses.get(0)).containsTask((Task)highPriorityTask));
        Assert.assertFalse((boolean)((TaskLockbox.TaskLockPosse)highLockPosses.get(0)).getTaskLock().isRevoked());
        List lowLockPosses = this.lockbox.getOnlyTaskLockPosseContainingInterval((Task)lowPriorityTask, Intervals.of((String)"2018-12-16T09:00:00/2018-12-16T10:00:00"));
        Assert.assertEquals((long)1L, (long)lowLockPosses.size());
        Assert.assertTrue((boolean)((TaskLockbox.TaskLockPosse)lowLockPosses.get(0)).containsTask((Task)lowPriorityTask));
        Assert.assertTrue((boolean)((TaskLockbox.TaskLockPosse)lowLockPosses.get(0)).getTaskLock().isRevoked());
    }

    @Test
    public void testSegmentLock() throws InterruptedException {
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        LockResult lockResult = this.lockbox.lock((Task)task, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3));
        Assert.assertTrue((boolean)lockResult.isOk());
        Assert.assertNull((Object)lockResult.getNewSegmentId());
        Assert.assertTrue((boolean)(lockResult.getTaskLock() instanceof SegmentLock));
        SegmentLock segmentLock = (SegmentLock)lockResult.getTaskLock();
        Assert.assertEquals((Object)TaskLockType.EXCLUSIVE, (Object)segmentLock.getType());
        Assert.assertEquals((Object)task.getGroupId(), (Object)segmentLock.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)segmentLock.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2015-01-01/2015-01-02"), (Object)segmentLock.getInterval());
        Assert.assertEquals((Object)"v1", (Object)segmentLock.getVersion());
        Assert.assertEquals((long)3L, (long)segmentLock.getPartitionId());
        Assert.assertEquals((long)task.getPriority(), (long)segmentLock.getPriority().intValue());
        Assert.assertFalse((boolean)segmentLock.isRevoked());
    }

    @Test
    public void testSegmentAndTimeChunkLockForSameInterval() {
        NoopTask task1 = NoopTask.create();
        this.lockbox.add((Task)task1);
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3)).isOk());
        Assert.assertFalse((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02"), "v1")).isOk());
    }

    @Test
    public void testSegmentAndTimeChunkLockForSameIntervalWithDifferentPriority() throws EntryExistsException {
        NoopTask task1 = NoopTask.create((int)10);
        this.lockbox.add((Task)task1);
        this.taskStorage.insert((Task)task1, TaskStatus.running((String)task1.getId()));
        NoopTask task2 = NoopTask.create((int)100);
        this.lockbox.add((Task)task2);
        this.taskStorage.insert((Task)task2, TaskStatus.running((String)task2.getId()));
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3)).isOk());
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02"), "v1")).isOk());
        LockResult resultOfTask1 = this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3));
        Assert.assertFalse((boolean)resultOfTask1.isOk());
        Assert.assertTrue((boolean)resultOfTask1.isRevoked());
    }

    @Test
    public void testSegmentLockForSameIntervalAndSamePartition() {
        NoopTask task1 = NoopTask.create();
        this.lockbox.add((Task)task1);
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3)).isOk());
        Assert.assertFalse((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3)).isOk());
    }

    @Test
    public void testSegmentLockForSameIntervalDifferentPartition() {
        NoopTask task1 = NoopTask.create();
        this.lockbox.add((Task)task1);
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 3)).isOk());
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-01/2015-01-02"), "v1", 2)).isOk());
    }

    @Test
    public void testSegmentLockForOverlappedIntervalDifferentPartition() {
        NoopTask task1 = NoopTask.create();
        this.lockbox.add((Task)task1);
        NoopTask task2 = NoopTask.create();
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2015-01-01/2015-01-05"), "v1", 3)).isOk());
        Assert.assertFalse((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2015-01-03/2015-01-08"), "v1", 2)).isOk());
    }

    @Test
    public void testRequestForNewSegmentWithSegmentLock() {
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        this.allocateSegmentsAndAssert((Task)task, "seq", 3, (PartialShardSpec)NumberedPartialShardSpec.instance());
        this.allocateSegmentsAndAssert((Task)task, "seq2", 2, (PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 3, 1));
        List locks = this.lockbox.findLocksForTask((Task)task);
        Assert.assertEquals((long)5L, (long)locks.size());
        int expectedPartitionId = 0;
        for (TaskLock lock : locks) {
            Assert.assertTrue((boolean)(lock instanceof SegmentLock));
            SegmentLock segmentLock = (SegmentLock)lock;
            Assert.assertEquals((long)expectedPartitionId++, (long)segmentLock.getPartitionId());
            if (expectedPartitionId != 3) continue;
            expectedPartitionId = 32768;
        }
    }

    @Test
    public void testRequestForNewSegmentWithHashPartition() {
        NoopTask task = NoopTask.create();
        this.lockbox.add((Task)task);
        this.allocateSegmentsAndAssert((Task)task, "seq", 3, (PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 1, 3, null));
        this.allocateSegmentsAndAssert((Task)task, "seq2", 5, (PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 3, 5, null));
    }

    private void allocateSegmentsAndAssert(Task task, String baseSequenceName, int numSegmentsToAllocate, PartialShardSpec partialShardSpec) {
        for (int i = 0; i < numSegmentsToAllocate; ++i) {
            LockRequestForNewSegment request = new LockRequestForNewSegment(LockGranularity.SEGMENT, TaskLockType.EXCLUSIVE, task, Intervals.of((String)"2015-01-01/2015-01-05"), partialShardSpec, StringUtils.format((String)"%s_%d", (Object[])new Object[]{baseSequenceName, i}), null, true);
            this.assertAllocatedSegments(request, this.lockbox.tryLock(task, (LockRequest)request));
        }
    }

    private void assertAllocatedSegments(LockRequestForNewSegment lockRequest, LockResult result) {
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertNotNull((Object)result.getTaskLock());
        Assert.assertTrue((boolean)(result.getTaskLock() instanceof SegmentLock));
        Assert.assertNotNull((Object)result.getNewSegmentId());
        SegmentLock segmentLock = (SegmentLock)result.getTaskLock();
        SegmentIdWithShardSpec segmentId = result.getNewSegmentId();
        Assert.assertEquals((Object)lockRequest.getType(), (Object)segmentLock.getType());
        Assert.assertEquals((Object)lockRequest.getGroupId(), (Object)segmentLock.getGroupId());
        Assert.assertEquals((Object)lockRequest.getDataSource(), (Object)segmentLock.getDataSource());
        Assert.assertEquals((Object)lockRequest.getInterval(), (Object)segmentLock.getInterval());
        Assert.assertEquals((Object)lockRequest.getPartialShardSpec().getShardSpecClass(), segmentId.getShardSpec().getClass());
        Assert.assertEquals((long)lockRequest.getPriority(), (long)lockRequest.getPriority());
    }

    @Test
    public void testLockPosseEquals() {
        NoopTask task1 = NoopTask.create();
        NoopTask task2 = NoopTask.create();
        TimeChunkLock taskLock1 = new TimeChunkLock(TaskLockType.EXCLUSIVE, task1.getGroupId(), task1.getDataSource(), Intervals.of((String)"2018/2019"), "v1", task1.getPriority());
        TimeChunkLock taskLock2 = new TimeChunkLock(TaskLockType.EXCLUSIVE, task2.getGroupId(), task2.getDataSource(), Intervals.of((String)"2018/2019"), "v2", task2.getPriority());
        TaskLockbox.TaskLockPosse taskLockPosse1 = new TaskLockbox.TaskLockPosse((TaskLock)taskLock1);
        TaskLockbox.TaskLockPosse taskLockPosse2 = new TaskLockbox.TaskLockPosse((TaskLock)taskLock2);
        TaskLockbox.TaskLockPosse taskLockPosse3 = new TaskLockbox.TaskLockPosse((TaskLock)taskLock1);
        Assert.assertNotEquals((Object)taskLockPosse1, null);
        Assert.assertNotEquals(null, (Object)taskLockPosse1);
        Assert.assertNotEquals((Object)taskLockPosse1, (Object)taskLockPosse2);
        Assert.assertEquals((Object)taskLockPosse1, (Object)taskLockPosse3);
    }

    @Test
    public void testGetTimeChunkAndSegmentLockForSameGroup() {
        NoopTask task1 = NoopTask.withGroupId((String)"groupId");
        NoopTask task2 = NoopTask.withGroupId((String)"groupId");
        this.lockbox.add((Task)task1);
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2017/2018"), null)).isOk());
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2017/2018"), "version", 0)).isOk());
        List posses = (List)((SortedMap)((NavigableMap)this.lockbox.getAllLocks().get(task1.getDataSource())).get(DateTimes.of((String)"2017"))).get(Intervals.of((String)"2017/2018"));
        Assert.assertEquals((long)2L, (long)posses.size());
        Assert.assertEquals((Object)LockGranularity.TIME_CHUNK, (Object)((TaskLockbox.TaskLockPosse)posses.get(0)).getTaskLock().getGranularity());
        TimeChunkLock timeChunkLock = (TimeChunkLock)((TaskLockbox.TaskLockPosse)posses.get(0)).getTaskLock();
        Assert.assertEquals((Object)"none", (Object)timeChunkLock.getDataSource());
        Assert.assertEquals((Object)"groupId", (Object)timeChunkLock.getGroupId());
        Assert.assertEquals((Object)Intervals.of((String)"2017/2018"), (Object)timeChunkLock.getInterval());
        Assert.assertEquals((Object)LockGranularity.SEGMENT, (Object)((TaskLockbox.TaskLockPosse)posses.get(1)).getTaskLock().getGranularity());
        SegmentLock segmentLock = (SegmentLock)((TaskLockbox.TaskLockPosse)posses.get(1)).getTaskLock();
        Assert.assertEquals((Object)"none", (Object)segmentLock.getDataSource());
        Assert.assertEquals((Object)"groupId", (Object)segmentLock.getGroupId());
        Assert.assertEquals((Object)Intervals.of((String)"2017/2018"), (Object)segmentLock.getInterval());
        Assert.assertEquals((long)0L, (long)segmentLock.getPartitionId());
    }

    @Test
    public void testGetTimeChunkAndSegmentLockForDifferentGroup() {
        NoopTask task1 = NoopTask.withGroupId((String)"groupId");
        NoopTask task2 = NoopTask.withGroupId((String)"groupId2");
        this.lockbox.add((Task)task1);
        this.lockbox.add((Task)task2);
        Assert.assertTrue((boolean)this.lockbox.tryLock((Task)task1, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2017/2018"), null)).isOk());
        Assert.assertFalse((boolean)this.lockbox.tryLock((Task)task2, (LockRequest)new SpecificSegmentLockRequest(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2017/2018"), "version", 0)).isOk());
    }

    @Test
    public void testGetLockedIntervals() {
        NoopTask task1 = NoopTask.create((String)"ds1");
        this.lockbox.add((Task)task1);
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2017-01-01/2017-02-01"));
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task1, Intervals.of((String)"2017-04-01/2017-05-01"));
        NoopTask task2 = NoopTask.create((String)"ds2");
        this.lockbox.add((Task)task2);
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task2, Intervals.of((String)"2017-03-01/2017-04-01"));
        HashMap<String, Integer> minTaskPriority = new HashMap<String, Integer>();
        minTaskPriority.put(task1.getDataSource(), 10);
        minTaskPriority.put(task2.getDataSource(), 10);
        Map lockedIntervals = this.lockbox.getLockedIntervals(minTaskPriority);
        Assert.assertEquals((long)2L, (long)lockedIntervals.size());
        Assert.assertEquals(Arrays.asList(Intervals.of((String)"2017-01-01/2017-02-01"), Intervals.of((String)"2017-04-01/2017-05-01")), lockedIntervals.get(task1.getDataSource()));
        Assert.assertEquals(Collections.singletonList(Intervals.of((String)"2017-03-01/2017-04-01")), lockedIntervals.get(task2.getDataSource()));
    }

    @Test
    public void testGetLockedIntervalsForLowPriorityTask() throws Exception {
        NoopTask lowPriorityTask = NoopTask.create((int)5);
        this.lockbox.add((Task)lowPriorityTask);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, Intervals.of((String)"2017/2018"));
        HashMap<String, Integer> minTaskPriority = new HashMap<String, Integer>();
        minTaskPriority.put(lowPriorityTask.getDataSource(), 10);
        Map lockedIntervals = this.lockbox.getLockedIntervals(minTaskPriority);
        Assert.assertTrue((boolean)lockedIntervals.isEmpty());
    }

    @Test
    public void testGetLockedIntervalsForEqualPriorityTask() throws Exception {
        NoopTask task = NoopTask.create((int)5);
        this.lockbox.add((Task)task);
        this.taskStorage.insert((Task)task, TaskStatus.running((String)task.getId()));
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)task, Intervals.of((String)"2017/2018"));
        HashMap<String, Integer> minTaskPriority = new HashMap<String, Integer>();
        minTaskPriority.put(task.getDataSource(), 5);
        Map lockedIntervals = this.lockbox.getLockedIntervals(minTaskPriority);
        Assert.assertEquals((long)1L, (long)lockedIntervals.size());
        Assert.assertEquals(Collections.singletonList(Intervals.of((String)"2017/2018")), lockedIntervals.get(task.getDataSource()));
    }

    @Test
    public void testGetLockedIntervalsForRevokedLocks() throws Exception {
        NoopTask lowPriorityTask = NoopTask.create((int)5);
        this.lockbox.add((Task)lowPriorityTask);
        this.taskStorage.insert((Task)lowPriorityTask, TaskStatus.running((String)lowPriorityTask.getId()));
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)lowPriorityTask, Intervals.of((String)"2017/2018"));
        HashMap<String, Integer> minTaskPriority = new HashMap<String, Integer>();
        minTaskPriority.put(lowPriorityTask.getDataSource(), 1);
        Map lockedIntervals = this.lockbox.getLockedIntervals(minTaskPriority);
        Assert.assertEquals((long)1L, (long)lockedIntervals.size());
        Assert.assertEquals(Collections.singletonList(Intervals.of((String)"2017/2018")), lockedIntervals.get(lowPriorityTask.getDataSource()));
        NoopTask highPriorityTask = NoopTask.create((int)10);
        this.lockbox.add((Task)highPriorityTask);
        this.tryTimeChunkLock(TaskLockType.EXCLUSIVE, (Task)highPriorityTask, Intervals.of((String)"2017-05-01/2017-06-01"));
        minTaskPriority.put(highPriorityTask.getDataSource(), 1);
        lockedIntervals = this.lockbox.getLockedIntervals(minTaskPriority);
        Assert.assertEquals((long)1L, (long)lockedIntervals.size());
        Assert.assertEquals(Collections.singletonList(Intervals.of((String)"2017-05-01/2017-06-01")), lockedIntervals.get(highPriorityTask.getDataSource()));
    }

    @Test
    public void testFailedToReacquireTaskLock() throws Exception {
        NoopTask taskWithFailingLockAcquisition0 = NoopTask.withGroupId((String)"FailingLockAcquisition");
        NoopTask taskWithFailingLockAcquisition1 = NoopTask.withGroupId((String)"FailingLockAcquisition");
        NoopTask taskWithSuccessfulLockAcquisition = NoopTask.create();
        this.taskStorage.insert((Task)taskWithFailingLockAcquisition0, TaskStatus.running((String)taskWithFailingLockAcquisition0.getId()));
        this.taskStorage.insert((Task)taskWithFailingLockAcquisition1, TaskStatus.running((String)taskWithFailingLockAcquisition1.getId()));
        this.taskStorage.insert((Task)taskWithSuccessfulLockAcquisition, TaskStatus.running((String)taskWithSuccessfulLockAcquisition.getId()));
        NullLockPosseTaskLockbox testLockbox = new NullLockPosseTaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        testLockbox.add((Task)taskWithFailingLockAcquisition0);
        testLockbox.add((Task)taskWithFailingLockAcquisition1);
        testLockbox.add((Task)taskWithSuccessfulLockAcquisition);
        testLockbox.tryLock((Task)taskWithFailingLockAcquisition0, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)taskWithFailingLockAcquisition0, Intervals.of((String)"2017-07-01/2017-08-01"), null));
        testLockbox.tryLock((Task)taskWithSuccessfulLockAcquisition, (LockRequest)new TimeChunkLockRequest(TaskLockType.EXCLUSIVE, (Task)taskWithSuccessfulLockAcquisition, Intervals.of((String)"2017-07-01/2017-08-01"), null));
        Assert.assertEquals((long)3L, (long)this.taskStorage.getActiveTasks().size());
        TaskLockboxSyncResult result = testLockbox.syncFromStorage();
        Assert.assertEquals((Object)ImmutableSet.of((Object)taskWithFailingLockAcquisition0, (Object)taskWithFailingLockAcquisition1), (Object)result.getTasksToFail());
    }

    private Set<TaskLock> getAllActiveLocks(List<Task> tasks) {
        return tasks.stream().flatMap(task -> this.taskStorage.getLocks(task.getId()).stream()).filter(taskLock -> !taskLock.isRevoked()).collect(Collectors.toSet());
    }

    private Set<TaskLock> getAllLocks(List<Task> tasks) {
        return tasks.stream().flatMap(task -> this.taskStorage.getLocks(task.getId()).stream()).collect(Collectors.toSet());
    }

    private static class NullLockPosseTaskLockbox
    extends TaskLockbox {
        public NullLockPosseTaskLockbox(TaskStorage taskStorage, IndexerMetadataStorageCoordinator metadataStorageCoordinator) {
            super(taskStorage, metadataStorageCoordinator);
        }

        protected TaskLockbox.TaskLockPosse verifyAndCreateOrFindLockPosse(Task task, TaskLock taskLock) {
            return task.getGroupId().contains("FailingLockAcquisition") ? null : super.verifyAndCreateOrFindLockPosse(task, taskLock);
        }
    }

    private static class MyModuleIsntLoadedTask
    extends AbstractTask {
        private String someProp;

        @JsonCreator
        protected MyModuleIsntLoadedTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="someProp") String someProp) {
            super(id, dataSource, context);
            this.someProp = someProp;
        }

        @JsonProperty
        public String getSomeProp() {
            return this.someProp;
        }

        public String getType() {
            return TASK_NAME;
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            return true;
        }

        public void stopGracefully(TaskConfig taskConfig) {
        }

        public TaskStatus runTask(TaskToolbox toolbox) {
            return TaskStatus.failure((String)"how?", (String)"Dummy task status err msg");
        }
    }

    private static class TheModule
    extends SimpleModule {
        public TheModule() {
            this.registerSubtypes(new NamedType[]{new NamedType(MyModuleIsntLoadedTask.class, TASK_NAME)});
        }
    }

    private static class IntervalLockWithoutPriority
    extends TimeChunkLock {
        @JsonCreator
        IntervalLockWithoutPriority(String groupId, String dataSource, Interval interval, String version) {
            super(null, groupId, dataSource, interval, version, null, false);
        }

        @JsonProperty
        public TaskLockType getType() {
            return super.getType();
        }

        @JsonProperty
        public String getGroupId() {
            return super.getGroupId();
        }

        @JsonProperty
        public String getDataSource() {
            return super.getDataSource();
        }

        @JsonProperty
        public Interval getInterval() {
            return super.getInterval();
        }

        @JsonProperty
        public String getVersion() {
            return super.getVersion();
        }

        @JsonIgnore
        public Integer getPriority() {
            return super.getPriority();
        }

        @JsonIgnore
        public boolean isRevoked() {
            return super.isRevoked();
        }
    }
}

