/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.WorkerTaskRunnerQueryAdapter;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkerTaskRunnerQueryAdpaterTest {
    private WorkerTaskRunnerQueryAdapter workerTaskRunnerQueryAdapter;
    private HttpClient httpClient;
    private WorkerTaskRunner workerTaskRunner;
    private TaskMaster taskMaster;

    @Before
    public void setup() {
        this.httpClient = (HttpClient)EasyMock.createNiceMock(HttpClient.class);
        this.workerTaskRunner = (WorkerTaskRunner)EasyMock.createMock(WorkerTaskRunner.class);
        this.taskMaster = (TaskMaster)EasyMock.createStrictMock(TaskMaster.class);
        this.workerTaskRunnerQueryAdapter = new WorkerTaskRunnerQueryAdapter(this.taskMaster, this.httpClient);
        EasyMock.expect((Object)this.taskMaster.getTaskRunner()).andReturn((Object)Optional.of((Object)this.workerTaskRunner)).once();
        EasyMock.expect((Object)this.workerTaskRunner.getWorkers()).andReturn((Object)ImmutableList.of((Object)new ImmutableWorkerInfo(new Worker("http", "worker-host1", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), (Object)new ImmutableWorkerInfo(new Worker("https", "worker-host2", "192.0.0.2", 4, "v1", "_default_worker_category"), 1, (Set)ImmutableSet.of((Object)"grp1"), (Collection)ImmutableSet.of((Object)"task1"), DateTimes.of((String)"2015-01-01T01:01:01Z")))).once();
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
    }

    @Test
    public void testDisableWorker() throws Exception {
        URL workerUrl = new URL("http://worker-host1/druid/worker/v1/disable");
        String workerResponse = "{\"worker-host1\":\"disabled\"}";
        Capture<Request> capturedRequest = this.getHttpClientRequestCapture(HttpResponseStatus.OK, "{\"worker-host1\":\"disabled\"}");
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        this.workerTaskRunnerQueryAdapter.disableWorker("worker-host1");
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((Object)workerUrl, (Object)((Request)capturedRequest.getValue()).getUrl());
    }

    @Test
    public void testDisableWorkerWhenWorkerRaisesError() throws Exception {
        URL workerUrl = new URL("http://worker-host1/druid/worker/v1/disable");
        Capture<Request> capturedRequest = this.getHttpClientRequestCapture(HttpResponseStatus.INTERNAL_SERVER_ERROR, "");
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        try {
            this.workerTaskRunnerQueryAdapter.disableWorker("worker-host1");
            Assert.fail((String)"Should raise RE exception!");
        }
        catch (RE rE) {
            // empty catch block
        }
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((Object)workerUrl, (Object)((Request)capturedRequest.getValue()).getUrl());
    }

    @Test(expected=RE.class)
    public void testDisableWorkerWhenWorkerNotExists() {
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        this.workerTaskRunnerQueryAdapter.disableWorker("not-existing-worker");
    }

    @Test
    public void testEnableWorker() throws Exception {
        URL workerUrl = new URL("https://worker-host2/druid/worker/v1/enable");
        String workerResponse = "{\"worker-host2\":\"enabled\"}";
        Capture<Request> capturedRequest = this.getHttpClientRequestCapture(HttpResponseStatus.OK, "{\"worker-host2\":\"enabled\"}");
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        this.workerTaskRunnerQueryAdapter.enableWorker("worker-host2");
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((Object)workerUrl, (Object)((Request)capturedRequest.getValue()).getUrl());
    }

    @Test
    public void testEnableWorkerWhenWorkerRaisesError() throws Exception {
        URL workerUrl = new URL("https://worker-host2/druid/worker/v1/enable");
        Capture<Request> capturedRequest = this.getHttpClientRequestCapture(HttpResponseStatus.INTERNAL_SERVER_ERROR, "");
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        try {
            this.workerTaskRunnerQueryAdapter.enableWorker("worker-host2");
            Assert.fail((String)"Should raise RE exception!");
        }
        catch (RE rE) {
            // empty catch block
        }
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((Object)workerUrl, (Object)((Request)capturedRequest.getValue()).getUrl());
    }

    @Test(expected=RE.class)
    public void testEnableWorkerWhenWorkerNotExists() {
        EasyMock.replay((Object[])new Object[]{this.workerTaskRunner, this.taskMaster, this.httpClient});
        this.workerTaskRunnerQueryAdapter.enableWorker("not-existing-worker");
    }

    private Capture<Request> getHttpClientRequestCapture(HttpResponseStatus httpStatus, String responseContent) {
        SettableFuture futureResult = SettableFuture.create();
        futureResult.set((Object)new StatusResponseHolder(httpStatus, new StringBuilder(responseContent)));
        Capture capturedRequest = EasyMock.newCapture();
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject())).andReturn((Object)futureResult).once();
        return capturedRequest;
    }
}

