/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class ForkingTaskRunnerConfigTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final Injector INJECTOR = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

        public void configure(Binder binder) {
            binder.bind(Key.get(String.class, (Annotation)Names.named((String)"serviceName"))).toInstance((Object)"some service");
            binder.bind(Key.get(Integer.class, (Annotation)Names.named((String)"servicePort"))).toInstance((Object)0);
            binder.bind(Key.get(Integer.class, (Annotation)Names.named((String)"tlsServicePort"))).toInstance((Object)-1);
        }
    }));
    private static final JsonConfigurator CONFIGURATOR = (JsonConfigurator)INJECTOR.getBinding(JsonConfigurator.class).getProvider().get();

    @Test
    public void testSimpleJavaOpts() {
        ForkingTaskRunnerConfig forkingTaskRunnerConfig = (ForkingTaskRunnerConfig)CONFIGURATOR.configurate(new Properties(), "not found", ForkingTaskRunnerConfig.class);
        Assert.assertEquals((Object)"", (Object)forkingTaskRunnerConfig.getJavaOpts());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)forkingTaskRunnerConfig.getJavaOptsArray());
    }

    @Test
    public void testSimpleStringJavaOpts() {
        String javaOpts = "some string";
        Assert.assertEquals((Object)"some string", (Object)this.buildFromProperties("druid.indexer.runner.javaOpts", "some string").getJavaOpts());
    }

    @Test
    public void testCrazyQuotesStringJavaOpts() {
        String javaOpts = "            \"test\",\n            \"-mmm\\\"some quote with\\\"suffix\",\n            \"test2\",\n            \"\\\"completely quoted\\\"\",\n            \"more\",\n            \"\u2603\",\n            \"-XX:SomeCoolOption=false\",\n            \"-XX:SomeOption=\\\"with spaces\\\"\",\n            \"someValues\",\n            \"some\\\"strange looking\\\"option\",\n            \"andOtherOptions\",\n            \"\\\"\\\"\",\n            \"AndMaybeEmptyQuotes\",\n            \"keep\u00a0me\u00a0around\"";
        Assert.assertEquals((Object)"            \"test\",\n            \"-mmm\\\"some quote with\\\"suffix\",\n            \"test2\",\n            \"\\\"completely quoted\\\"\",\n            \"more\",\n            \"\u2603\",\n            \"-XX:SomeCoolOption=false\",\n            \"-XX:SomeOption=\\\"with spaces\\\"\",\n            \"someValues\",\n            \"some\\\"strange looking\\\"option\",\n            \"andOtherOptions\",\n            \"\\\"\\\"\",\n            \"AndMaybeEmptyQuotes\",\n            \"keep\u00a0me\u00a0around\"", (Object)this.buildFromProperties("druid.indexer.runner.javaOpts", "            \"test\",\n            \"-mmm\\\"some quote with\\\"suffix\",\n            \"test2\",\n            \"\\\"completely quoted\\\"\",\n            \"more\",\n            \"\u2603\",\n            \"-XX:SomeCoolOption=false\",\n            \"-XX:SomeOption=\\\"with spaces\\\"\",\n            \"someValues\",\n            \"some\\\"strange looking\\\"option\",\n            \"andOtherOptions\",\n            \"\\\"\\\"\",\n            \"AndMaybeEmptyQuotes\",\n            \"keep\u00a0me\u00a0around\"").getJavaOpts());
    }

    @Test
    public void testSimpleJavaOptArray() throws JsonProcessingException {
        ImmutableList javaOpts = ImmutableList.of((Object)"option1", (Object)"option \"2\"");
        Assert.assertEquals((Object)javaOpts, (Object)this.buildFromProperties("druid.indexer.runner.javaOptsArray", MAPPER.writeValueAsString((Object)javaOpts)).getJavaOptsArray());
    }

    @Test
    public void testCrazyJavaOptArray() throws JsonProcessingException {
        ImmutableList javaOpts = ImmutableList.of((Object)"test", (Object)"-mmm\"some quote with\"suffix", (Object)"test2", (Object)"\"completely quoted\"", (Object)"more", (Object)"\u2603", (Object)"-XX:SomeCoolOption=false", (Object)"-XX:SomeOption=\"with spaces\"", (Object)"someValues", (Object)"some\"strange looking\"option", (Object)"andOtherOptions", (Object)"\"\"", (Object[])new String[]{"AndMaybeEmptyQuotes", "keep\u00a0me\u00a0around"});
        Assert.assertEquals((Object)javaOpts, (Object)this.buildFromProperties("druid.indexer.runner.javaOptsArray", MAPPER.writeValueAsString((Object)javaOpts)).getJavaOptsArray());
    }

    @Test
    public void testPorts() throws JsonProcessingException {
        ImmutableList ports = ImmutableList.of((Object)1024, (Object)1025);
        Assert.assertEquals((Object)ports, (Object)this.buildFromProperties("druid.indexer.runner.ports", MAPPER.writeValueAsString((Object)ports)).getPorts());
    }

    @Test(expected=ProvisionException.class)
    public void testExceptionalPorts() {
        this.buildFromProperties("druid.indexer.runner.ports", "not an Integer");
    }

    @Test(expected=ProvisionException.class)
    public void testExceptionalPorts2() {
        this.buildFromProperties("druid.indexer.runner.ports", "1024");
    }

    @Test(expected=ProvisionException.class)
    public void testExceptionalJavaOptArray() {
        this.buildFromProperties("druid.indexer.runner.javaOptsArray", "not an array");
    }

    @Test(expected=ProvisionException.class)
    public void testExceptionalJavaOpt() {
        this.buildFromProperties("druid.indexer.runner.javaOpts", "[\"not a string\"]");
    }

    @Test(expected=ProvisionException.class)
    public void testExceptionalJavaOpt2() {
        this.buildFromProperties("druid.indexer.runner.javaOpts", "{\"not a string\":\"someVal\"}");
    }

    private ForkingTaskRunnerConfig buildFromProperties(String key, String value) {
        Properties properties = new Properties();
        properties.put(key, value);
        return (ForkingTaskRunnerConfig)CONFIGURATOR.configurate(properties, "druid.indexer.runner", ForkingTaskRunnerConfig.class);
    }
}

