/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.base.Optional;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.http.OverlordRedirectInfo;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OverlordRedirectInfoTest {
    private TaskMaster taskMaster;
    private OverlordRedirectInfo redirectInfo;

    @Before
    public void setUp() {
        this.taskMaster = (TaskMaster)EasyMock.createMock(TaskMaster.class);
        this.redirectInfo = new OverlordRedirectInfo(this.taskMaster);
    }

    @Test
    public void testDoLocalWhenLeading() {
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskMaster});
        Assert.assertTrue((boolean)this.redirectInfo.doLocal(null));
        Assert.assertTrue((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/leader"));
        Assert.assertTrue((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/isLeader"));
        Assert.assertTrue((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/other/path"));
        EasyMock.verify((Object[])new Object[]{this.taskMaster});
    }

    @Test
    public void testDoLocalWhenNotLeading() {
        EasyMock.expect((Object)this.taskMaster.isLeader()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskMaster});
        Assert.assertFalse((boolean)this.redirectInfo.doLocal(null));
        Assert.assertTrue((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/leader"));
        Assert.assertTrue((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/isLeader"));
        Assert.assertFalse((boolean)this.redirectInfo.doLocal("/druid/indexer/v1/other/path"));
        EasyMock.verify((Object[])new Object[]{this.taskMaster});
    }

    @Test
    public void testGetRedirectURLWithEmptyLocation() {
        EasyMock.expect((Object)this.taskMaster.getRedirectLocation()).andReturn((Object)Optional.absent()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskMaster});
        URL url = this.redirectInfo.getRedirectURL("query", "/request");
        Assert.assertNull((Object)url);
        EasyMock.verify((Object[])new Object[]{this.taskMaster});
    }

    @Test
    public void testGetRedirectURL() {
        String host = "http://localhost";
        String query = "foo=bar&x=y";
        String request = "/request";
        EasyMock.expect((Object)this.taskMaster.getRedirectLocation()).andReturn((Object)Optional.of((Object)host)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskMaster});
        URL url = this.redirectInfo.getRedirectURL(query, request);
        Assert.assertEquals((Object)"http://localhost/request?foo=bar&x=y", (Object)url.toString());
        EasyMock.verify((Object[])new Object[]{this.taskMaster});
    }

    @Test
    public void testGetRedirectURLWithEncodedCharacter() throws UnsupportedEncodingException {
        String host = "http://localhost";
        String request = "/druid/indexer/v1/task/" + URLEncoder.encode("index_hadoop_datasource_2017-07-12T07:43:01.495Z", "UTF-8") + "/status";
        EasyMock.expect((Object)this.taskMaster.getRedirectLocation()).andReturn((Object)Optional.of((Object)host)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.taskMaster});
        URL url = this.redirectInfo.getRedirectURL(null, request);
        Assert.assertEquals((Object)"http://localhost/druid/indexer/v1/task/index_hadoop_datasource_2017-07-12T07%3A43%3A01.495Z/status", (Object)url.toString());
        EasyMock.verify((Object[])new Object[]{this.taskMaster});
    }
}

