/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.http.security.SupervisorResourceFilter;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SupervisorResourceFilterTest {
    private AuthorizerMapper authorizerMapper;
    private SupervisorManager supervisorManager;
    private SupervisorResourceFilter resourceFilter;
    private ContainerRequest containerRequest;
    private List<Object> mocksToVerify;

    @Before
    public void setup() {
        this.supervisorManager = (SupervisorManager)EasyMock.createMock(SupervisorManager.class);
        this.authorizerMapper = (AuthorizerMapper)EasyMock.createMock(AuthorizerMapper.class);
        this.resourceFilter = new SupervisorResourceFilter(this.authorizerMapper, this.supervisorManager);
        this.containerRequest = (ContainerRequest)EasyMock.createMock(ContainerRequest.class);
        this.mocksToVerify = new ArrayList<Object>();
    }

    @Test
    public void testGetWhenUserHasReadAccess() {
        this.setExpectations("/druid/indexer/v1/supervisor/datasource1", "GET", "datasource1", Action.READ, true);
        ContainerRequest filteredRequest = this.resourceFilter.filter(this.containerRequest);
        Assert.assertNotNull((Object)filteredRequest);
        this.verifyMocks();
    }

    @Test
    public void testGetWhenUserHasNoReadAccess() {
        this.setExpectations("/druid/indexer/v1/supervisor/datasource1", "GET", "datasource1", Action.READ, false);
        ForbiddenException expected = null;
        try {
            this.resourceFilter.filter(this.containerRequest);
        }
        catch (ForbiddenException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)((Object)expected));
        this.verifyMocks();
    }

    @Test
    public void testPostWhenUserHasWriteAccess() {
        this.setExpectations("/druid/indexer/v1/supervisor/datasource1", "POST", "datasource1", Action.WRITE, true);
        ContainerRequest filteredRequest = this.resourceFilter.filter(this.containerRequest);
        Assert.assertNotNull((Object)filteredRequest);
        this.verifyMocks();
    }

    @Test
    public void testPostWhenUserHasNoWriteAccess() {
        this.setExpectations("/druid/indexer/v1/supervisor/datasource1", "POST", "datasource1", Action.WRITE, false);
        ForbiddenException expected = null;
        try {
            this.resourceFilter.filter(this.containerRequest);
        }
        catch (ForbiddenException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)((Object)expected));
        this.verifyMocks();
    }

    @Test
    public void testSupervisorNotFound() {
        String dataSource = "not_exist_data_source";
        EasyMock.expect((Object)this.containerRequest.getPathSegments()).andReturn(this.getPathSegments("/druid/indexer/v1/supervisor/" + dataSource)).anyTimes();
        EasyMock.expect((Object)this.containerRequest.getMethod()).andReturn((Object)"POST").anyTimes();
        SupervisorSpec supervisorSpec = (SupervisorSpec)EasyMock.createMock(SupervisorSpec.class);
        EasyMock.expect((Object)supervisorSpec.getDataSources()).andReturn(Collections.singletonList(dataSource)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(dataSource)).andReturn((Object)Optional.absent()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.containerRequest});
        EasyMock.replay((Object[])new Object[]{this.supervisorManager});
        WebApplicationException expected = null;
        try {
            this.resourceFilter.filter(this.containerRequest);
        }
        catch (WebApplicationException e) {
            expected = e;
        }
        Assert.assertNotNull((Object)((Object)expected));
        Assert.assertEquals((long)expected.getResponse().getStatus(), (long)Response.Status.NOT_FOUND.getStatusCode());
        EasyMock.verify((Object[])new Object[]{this.containerRequest});
        EasyMock.verify((Object[])new Object[]{this.supervisorManager});
    }

    private void setExpectations(String path, String requestMethod, String datasource, Action expectedAction, boolean userHasAccess) {
        EasyMock.expect((Object)this.containerRequest.getPathSegments()).andReturn(this.getPathSegments(path)).anyTimes();
        EasyMock.expect((Object)this.containerRequest.getMethod()).andReturn((Object)requestMethod).anyTimes();
        SupervisorSpec supervisorSpec = (SupervisorSpec)EasyMock.createMock(SupervisorSpec.class);
        EasyMock.expect((Object)supervisorSpec.getDataSources()).andReturn(Collections.singletonList(datasource)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(datasource)).andReturn((Object)Optional.of((Object)supervisorSpec)).atLeastOnce();
        HttpServletRequest servletRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)servletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)servletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        servletRequest.setAttribute((String)EasyMock.isA(String.class), EasyMock.anyObject());
        String authorizerName = "authorizer";
        AuthenticationResult authResult = (AuthenticationResult)EasyMock.createMock(AuthenticationResult.class);
        EasyMock.expect((Object)authResult.getAuthorizerName()).andReturn((Object)"authorizer").anyTimes();
        Authorizer authorizer = (Authorizer)EasyMock.createMock(Authorizer.class);
        EasyMock.expect((Object)authorizer.authorize(authResult, new Resource(datasource, "DATASOURCE"), expectedAction)).andReturn((Object)new Access(userHasAccess)).anyTimes();
        EasyMock.expect((Object)this.authorizerMapper.getAuthorizer("authorizer")).andReturn((Object)authorizer).atLeastOnce();
        EasyMock.expect((Object)servletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)authResult).atLeastOnce();
        this.resourceFilter.setReq(servletRequest);
        this.mocksToVerify = Arrays.asList(this.authorizerMapper, supervisorSpec, this.supervisorManager, servletRequest, authorizer, authResult, this.containerRequest);
        this.replayMocks();
    }

    private void replayMocks() {
        for (Object mock : this.mocksToVerify) {
            EasyMock.replay((Object[])new Object[]{mock});
        }
    }

    private void verifyMocks() {
        for (Object mock : this.mocksToVerify) {
            EasyMock.verify((Object[])new Object[]{mock});
        }
    }

    private List<PathSegment> getPathSegments(String path) {
        String[] segments = path.split("/");
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (final String segment : segments) {
            pathSegments.add(new PathSegment(){

                public String getPath() {
                    return segment;
                }

                public MultivaluedMap<String, String> getMatrixParameters() {
                    return null;
                }
            });
        }
        return pathSegments;
    }
}

