/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.FillCapacityWithAffinityWorkerSelectStrategy;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;

public class FillCapacityWithAffinityWorkerSelectStrategyTest {
    @Test
    public void testFindWorkerForTask() {
        FillCapacityWithAffinityWorkerSelectStrategy strategy = new FillCapacityWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "lhost", "lhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        });
        Assert.assertEquals((Object)"localhost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testFindWorkerForTaskWithNulls() {
        FillCapacityWithAffinityWorkerSelectStrategy strategy = new FillCapacityWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "lhost", "lhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null));
        Assert.assertEquals((Object)"lhost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testIsolation() {
        FillCapacityWithAffinityWorkerSelectStrategy strategy = new FillCapacityWithAffinityWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost")), false));
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null));
        Assert.assertNull((Object)worker);
    }
}

