/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.druid.indexing.seekablestream.supervisor.NoticesQueue;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.junit.Assert;
import org.junit.Test;

public class NoticesQueueTest {
    @Test
    public void testQueue() throws InterruptedException {
        NoticesQueue queue = new NoticesQueue();
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)0L, (long)queue.size());
            queue.add((Object)"xyz");
            Assert.assertEquals((long)1L, (long)queue.size());
            queue.add((Object)"xyz");
            Assert.assertEquals((long)1L, (long)queue.size());
            queue.add((Object)"foo");
            Assert.assertEquals((long)2L, (long)queue.size());
            queue.add((Object)"xyz");
            Assert.assertEquals((long)2L, (long)queue.size());
            queue.add((Object)"bar");
            Assert.assertEquals((long)3L, (long)queue.size());
            Assert.assertEquals((Object)"xyz", (Object)queue.poll(10L));
            Assert.assertEquals((Object)"foo", (Object)queue.poll(10L));
            Assert.assertEquals((Object)"bar", (Object)queue.poll(10L));
            Assert.assertNull((Object)queue.poll(10L));
            Assert.assertEquals((long)0L, (long)queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueConcurrent() throws InterruptedException, ExecutionException {
        NoticesQueue queue = new NoticesQueue();
        ExecutorService exec = Execs.singleThreaded((String)this.getClass().getSimpleName());
        try {
            Future<String> item = exec.submit(() -> (String)queue.poll(60000L));
            queue.add((Object)"xyz");
            Assert.assertEquals((Object)"xyz", (Object)item.get());
        }
        finally {
            exec.shutdownNow();
        }
    }
}

