/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClient;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientAsyncImpl;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceClosedException;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceNotAvailableException;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeekableStreamIndexTaskClientAsyncImplTest {
    private static final String DATASOURCE = "the-datasource";
    private static final String TASK_ID = "the-task";
    private static final int MAX_ATTEMPTS = 2;
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final Duration httpTimeout = Duration.standardSeconds((long)1L);
    private MockServiceClient serviceClient;
    private ServiceClientFactory serviceClientFactory;
    private SeekableStreamIndexTaskClient<Integer, Long> client;

    @Before
    public void setUp() {
        this.serviceClient = new MockServiceClient();
        this.serviceClientFactory = (serviceName, serviceLocator, retryPolicy) -> {
            Assert.assertEquals((Object)TASK_ID, (Object)serviceName);
            return this.serviceClient;
        };
        this.client = new TestSeekableStreamIndexTaskClientAsyncImpl();
    }

    @After
    public void tearDown() {
        this.serviceClient.verify();
    }

    @Test
    public void test_getCheckpointsAsync() throws Exception {
        ImmutableMap checkpoints = ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)2, (Object)3L));
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/checkpoints").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)checkpoints));
        Assert.assertEquals((Object)checkpoints, (Object)this.client.getCheckpointsAsync(TASK_ID, false).get());
    }

    @Test
    public void test_getCurrentOffsetsAsync() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)2, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/offsets/current").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        Assert.assertEquals((Object)offsets, (Object)this.client.getCurrentOffsetsAsync(TASK_ID, false).get());
    }

    @Test
    public void test_getEndOffsetsAsync() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)2, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/offsets/end").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        Assert.assertEquals((Object)offsets, (Object)this.client.getEndOffsetsAsync(TASK_ID).get());
    }

    @Test
    public void test_getEndOffsetsAsync_notAvailable() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/offsets/end").timeout(this.httpTimeout), (Throwable)new ServiceNotAvailableException(TASK_ID));
        Assert.assertEquals(Collections.emptyMap(), (Object)this.client.getEndOffsetsAsync(TASK_ID).get());
    }

    @Test
    public void test_stopAsync_publish_ok() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop?publish=true").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertEquals((Object)true, (Object)this.client.stopAsync(TASK_ID, true).get());
    }

    @Test
    public void test_stopAsync_noPublish_ok() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertEquals((Object)true, (Object)this.client.stopAsync(TASK_ID, false).get());
    }

    @Test
    public void test_stopAsync_noPublish_httpError() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop").timeout(this.httpTimeout), (Throwable)new HttpResponseException(new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE), StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)false, (Object)this.client.stopAsync(TASK_ID, false).get());
    }

    @Test
    public void test_stopAsync_noPublish_notAvailable() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop").timeout(this.httpTimeout), (Throwable)new ServiceNotAvailableException(TASK_ID));
        Assert.assertEquals((Object)false, (Object)this.client.stopAsync(TASK_ID, false).get());
    }

    @Test
    public void test_stopAsync_noPublish_closed() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop").timeout(this.httpTimeout), (Throwable)new ServiceClosedException(TASK_ID));
        Assert.assertEquals((Object)true, (Object)this.client.stopAsync(TASK_ID, false).get());
    }

    @Test
    public void test_stopAsync_noPublish_ioException() {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/stop").timeout(this.httpTimeout), (Throwable)new IOException());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            Boolean cfr_ignored_0 = (Boolean)this.client.stopAsync(TASK_ID, false).get();
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
    }

    @Test
    public void test_resumeAsync_ok() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/resume").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertEquals((Object)true, (Object)this.client.resumeAsync(TASK_ID).get());
    }

    @Test
    public void test_resumeAsync_ioException() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/resume").timeout(this.httpTimeout), (Throwable)new IOException());
        Assert.assertEquals((Object)false, (Object)this.client.resumeAsync(TASK_ID).get());
    }

    @Test
    public void test_setEndOffsetsAsync() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)1, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/offsets/end?finish=false").content("application/json", this.jsonMapper.writeValueAsBytes((Object)offsets)).timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertEquals((Object)true, (Object)this.client.setEndOffsetsAsync(TASK_ID, (Map)offsets, false).get());
    }

    @Test
    public void test_setEndOffsetsAsync_ioException() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/resume").timeout(this.httpTimeout), (Throwable)new IOException());
        Assert.assertEquals((Object)false, (Object)this.client.resumeAsync(TASK_ID).get());
    }

    @Test
    public void test_getStatusAsync() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.READING));
        Assert.assertEquals((Object)SeekableStreamIndexTaskRunner.Status.READING, (Object)this.client.getStatusAsync(TASK_ID).get());
    }

    @Test
    public void test_getStatusAsync_notAvailable() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), (Throwable)new ServiceNotAvailableException(TASK_ID));
        Assert.assertEquals((Object)SeekableStreamIndexTaskRunner.Status.NOT_STARTED, (Object)this.client.getStatusAsync(TASK_ID).get());
    }

    @Test
    public void test_getStartTimeAsync() throws Exception {
        DateTime startTime = DateTimes.of((String)"2000");
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/time/start").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)startTime));
        Assert.assertEquals((Object)startTime, (Object)this.client.getStartTimeAsync(TASK_ID).get());
    }

    @Test
    public void test_getStartTimeAsync_noContent() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/time/start").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertNull((Object)this.client.getStartTimeAsync(TASK_ID).get());
    }

    @Test
    public void test_getStartTimeAsync_notAvailable() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/time/start").timeout(this.httpTimeout), (Throwable)new ServiceNotAvailableException(TASK_ID));
        Assert.assertNull((Object)this.client.getStartTimeAsync(TASK_ID).get());
    }

    @Test
    public void test_pauseAsync_immediateOk() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)1, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        Assert.assertEquals((Object)offsets, (Object)this.client.pauseAsync(TASK_ID).get());
    }

    @Test
    public void test_pauseAsync_immediateBadStatus() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)1, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.CONTINUE, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            Map cfr_ignored_0 = (Map)this.client.pauseAsync(TASK_ID).get();
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.startsWith((String)"Pause request for task [the-task] failed with response [100 Continue]"));
    }

    @Test
    public void test_pauseAsync_oneIteration() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)1, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.ACCEPTED, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.PAUSED)).expect(new RequestBuilder(HttpMethod.GET, "/offsets/current").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        Assert.assertEquals((Object)offsets, (Object)this.client.pauseAsync(TASK_ID).get());
    }

    @Test
    public void test_pauseAsync_oneIterationWithError() {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.ACCEPTED, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), (Throwable)new IOException());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            Map cfr_ignored_0 = (Map)this.client.pauseAsync(TASK_ID).get();
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
    }

    @Test
    public void test_pauseAsync_twoIterations() throws Exception {
        ImmutableMap offsets = ImmutableMap.of((Object)1, (Object)3L);
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.ACCEPTED, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.READING)).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.PAUSED)).expect(new RequestBuilder(HttpMethod.GET, "/offsets/current").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)offsets));
        Assert.assertEquals((Object)offsets, (Object)this.client.pauseAsync(TASK_ID).get());
    }

    @Test
    public void test_pauseAsync_threeIterations() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.POST, "/pause").timeout(this.httpTimeout), HttpResponseStatus.ACCEPTED, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.READING)).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.READING)).expect(new RequestBuilder(HttpMethod.GET, "/status").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)SeekableStreamIndexTaskRunner.Status.READING));
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            Map cfr_ignored_0 = (Map)this.client.pauseAsync(TASK_ID).get();
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.startsWith((String)"Task [the-task] failed to change its status from [READING] to [PAUSED]"));
    }

    @Test
    public void test_getMovingAveragesAsync() throws Exception {
        ImmutableMap retVal = ImmutableMap.of((Object)"foo", (Object)"xyz");
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/rowStats").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)retVal));
        Assert.assertEquals((Object)retVal, (Object)this.client.getMovingAveragesAsync(TASK_ID).get());
    }

    @Test
    public void test_getMovingAveragesAsync_empty() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/rowStats").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertNull((Object)this.client.getMovingAveragesAsync(TASK_ID).get());
    }

    @Test
    public void test_getMovingAveragesAsync_null() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/rowStats").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), null);
        Assert.assertNull((Object)this.client.getMovingAveragesAsync(TASK_ID).get());
    }

    @Test
    public void test_getParseErrorsAsync() throws Exception {
        ImmutableList retVal = ImmutableList.of((Object)new ParseExceptionReport("xyz", "foo", Collections.emptyList(), 123L));
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/unparseableEvents").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), this.jsonMapper.writeValueAsBytes((Object)retVal));
        Assert.assertEquals((Object)retVal, (Object)this.client.getParseErrorsAsync(TASK_ID).get());
    }

    @Test
    public void test_getParseErrorsAsync_empty() throws Exception {
        this.serviceClient.expect(new RequestBuilder(HttpMethod.GET, "/unparseableEvents").timeout(this.httpTimeout), HttpResponseStatus.OK, Collections.emptyMap(), ByteArrays.EMPTY_ARRAY);
        Assert.assertNull((Object)this.client.getParseErrorsAsync(TASK_ID).get());
    }

    @Test
    public void test_serviceLocator_unknownTask() throws Exception {
        TaskInfoProvider taskInfoProvider = (TaskInfoProvider)EasyMock.createStrictMock(TaskInfoProvider.class);
        EasyMock.expect((Object)taskInfoProvider.getTaskStatus(TASK_ID)).andReturn((Object)Optional.absent());
        EasyMock.replay((Object[])new Object[]{taskInfoProvider});
        try (SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator locator = new SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator(taskInfoProvider, TASK_ID);){
            Assert.assertEquals((Object)ServiceLocations.closed(), (Object)locator.locate().get());
        }
        EasyMock.verify((Object[])new Object[]{taskInfoProvider});
    }

    @Test
    public void test_serviceLocator_unknownLocation() throws Exception {
        TaskInfoProvider taskInfoProvider = (TaskInfoProvider)EasyMock.createStrictMock(TaskInfoProvider.class);
        EasyMock.expect((Object)taskInfoProvider.getTaskStatus(TASK_ID)).andReturn((Object)Optional.of((Object)TaskStatus.running((String)TASK_ID)));
        EasyMock.expect((Object)taskInfoProvider.getTaskLocation(TASK_ID)).andReturn((Object)TaskLocation.unknown());
        EasyMock.replay((Object[])new Object[]{taskInfoProvider});
        try (SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator locator = new SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator(taskInfoProvider, TASK_ID);){
            Assert.assertEquals((Object)ServiceLocations.forLocations(Collections.emptySet()), (Object)locator.locate().get());
        }
        EasyMock.verify((Object[])new Object[]{taskInfoProvider});
    }

    @Test
    public void test_serviceLocator_found() throws Exception {
        TaskInfoProvider taskInfoProvider = (TaskInfoProvider)EasyMock.createStrictMock(TaskInfoProvider.class);
        EasyMock.expect((Object)taskInfoProvider.getTaskStatus(TASK_ID)).andReturn((Object)Optional.of((Object)TaskStatus.running((String)TASK_ID)));
        EasyMock.expect((Object)taskInfoProvider.getTaskLocation(TASK_ID)).andReturn((Object)TaskLocation.create((String)"foo", (int)80, (int)-1));
        EasyMock.replay((Object[])new Object[]{taskInfoProvider});
        try (SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator locator = new SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator(taskInfoProvider, TASK_ID);){
            Assert.assertEquals((Object)ServiceLocations.forLocation((ServiceLocation)new ServiceLocation("foo", 80, -1, "/druid/worker/v1/chat/the-task")), (Object)locator.locate().get());
        }
        EasyMock.verify((Object[])new Object[]{taskInfoProvider});
    }

    @Test
    public void test_serviceLocator_closed() throws Exception {
        TaskInfoProvider taskInfoProvider = (TaskInfoProvider)EasyMock.createStrictMock(TaskInfoProvider.class);
        EasyMock.expect((Object)taskInfoProvider.getTaskStatus(TASK_ID)).andReturn((Object)Optional.of((Object)TaskStatus.success((String)TASK_ID)));
        EasyMock.replay((Object[])new Object[]{taskInfoProvider});
        try (SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator locator = new SeekableStreamIndexTaskClientAsyncImpl.SeekableStreamTaskLocator(taskInfoProvider, TASK_ID);){
            Assert.assertEquals((Object)ServiceLocations.closed(), (Object)locator.locate().get());
        }
        EasyMock.verify((Object[])new Object[]{taskInfoProvider});
    }

    private class TestSeekableStreamIndexTaskClientAsyncImpl
    extends SeekableStreamIndexTaskClientAsyncImpl<Integer, Long> {
        public TestSeekableStreamIndexTaskClientAsyncImpl() {
            super(SeekableStreamIndexTaskClientAsyncImplTest.DATASOURCE, SeekableStreamIndexTaskClientAsyncImplTest.this.serviceClientFactory, null, SeekableStreamIndexTaskClientAsyncImplTest.this.jsonMapper, SeekableStreamIndexTaskClientAsyncImplTest.this.httpTimeout, 2L);
        }

        public Class<Integer> getPartitionType() {
            return Integer.class;
        }

        public Class<Long> getSequenceType() {
            return Long.class;
        }
    }
}

