/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.seekablestream.StreamChunkParser;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.segment.incremental.NoopRowIngestionMeters;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.transform.TransformSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StreamChunkParserTest {
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec(null, null, null);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final RowIngestionMeters rowIngestionMeters = new NoopRowIngestionMeters();
    private final ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler(this.rowIngestionMeters, false, 0, 0);

    @Test
    public void testWithParserAndNullInputformatParseProperly() throws IOException {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new JSONParseSpec(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, JSONPathSpec.DEFAULT, Collections.emptyMap(), Boolean.valueOf(false)), StringUtils.UTF8_STRING);
        StreamChunkParser chunkParser = new StreamChunkParser((InputRowParser)parser, null, null, null, null, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        this.parseAndAssertResult((StreamChunkParser<ByteEntity>)chunkParser);
    }

    @Test
    public void testWithNullParserAndInputformatParseProperly() throws IOException {
        JsonInputFormat inputFormat = new JsonInputFormat(JSONPathSpec.DEFAULT, Collections.emptyMap(), null, null, null);
        StreamChunkParser chunkParser = new StreamChunkParser(null, (InputFormat)inputFormat, new InputRowSchema(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, ColumnsFilter.all()), TransformSpec.NONE, this.temporaryFolder.newFolder(), row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        this.parseAndAssertResult((StreamChunkParser<ByteEntity>)chunkParser);
    }

    @Test
    public void testWithNullParserAndNullInputformatFailToCreateParser() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Either parser or inputFormat should be set");
        StreamChunkParser chunkParser = new StreamChunkParser(null, null, null, null, null, row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
    }

    @Test
    public void testBothParserAndInputFormatParseProperlyUsingInputFormat() throws IOException {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new JSONParseSpec(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, JSONPathSpec.DEFAULT, Collections.emptyMap(), Boolean.valueOf(false)), StringUtils.UTF8_STRING);
        TrackingJsonInputFormat inputFormat = new TrackingJsonInputFormat(JSONPathSpec.DEFAULT, Collections.emptyMap());
        StreamChunkParser chunkParser = new StreamChunkParser((InputRowParser)parser, (InputFormat)inputFormat, new InputRowSchema(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, ColumnsFilter.all()), TransformSpec.NONE, this.temporaryFolder.newFolder(), row -> true, this.rowIngestionMeters, this.parseExceptionHandler);
        this.parseAndAssertResult((StreamChunkParser<ByteEntity>)chunkParser);
        Assert.assertTrue((boolean)inputFormat.props.used);
    }

    @Test
    public void parseEmptyNotEndOfShard() throws IOException {
        TrackingJsonInputFormat inputFormat = new TrackingJsonInputFormat(JSONPathSpec.DEFAULT, Collections.emptyMap());
        RowIngestionMeters mockRowIngestionMeters = (RowIngestionMeters)Mockito.mock(RowIngestionMeters.class);
        StreamChunkParser chunkParser = new StreamChunkParser(null, (InputFormat)inputFormat, new InputRowSchema(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, ColumnsFilter.all()), TransformSpec.NONE, this.temporaryFolder.newFolder(), row -> true, mockRowIngestionMeters, this.parseExceptionHandler);
        List parsedRows = chunkParser.parse((List)ImmutableList.of(), false);
        Assert.assertEquals((long)0L, (long)parsedRows.size());
        ((RowIngestionMeters)Mockito.verify((Object)mockRowIngestionMeters)).incrementThrownAway();
    }

    @Test
    public void parseEmptyEndOfShard() throws IOException {
        TrackingJsonInputFormat inputFormat = new TrackingJsonInputFormat(JSONPathSpec.DEFAULT, Collections.emptyMap());
        RowIngestionMeters mockRowIngestionMeters = (RowIngestionMeters)Mockito.mock(RowIngestionMeters.class);
        StreamChunkParser chunkParser = new StreamChunkParser(null, (InputFormat)inputFormat, new InputRowSchema(TIMESTAMP_SPEC, DimensionsSpec.EMPTY, ColumnsFilter.all()), TransformSpec.NONE, this.temporaryFolder.newFolder(), row -> true, mockRowIngestionMeters, this.parseExceptionHandler);
        List parsedRows = chunkParser.parse((List)ImmutableList.of(), true);
        Assert.assertEquals((long)0L, (long)parsedRows.size());
        Mockito.verifyNoInteractions((Object[])new Object[]{mockRowIngestionMeters});
    }

    private void parseAndAssertResult(StreamChunkParser<ByteEntity> chunkParser) throws IOException {
        String json = "{\"timestamp\": \"2020-01-01\", \"dim\": \"val\", \"met\": \"val2\"}";
        List parsedRows = chunkParser.parse(Collections.singletonList(new ByteEntity("{\"timestamp\": \"2020-01-01\", \"dim\": \"val\", \"met\": \"val2\"}".getBytes(StringUtils.UTF8_STRING))), false);
        Assert.assertEquals((long)1L, (long)parsedRows.size());
        InputRow row = (InputRow)parsedRows.get(0);
        Assert.assertEquals((Object)DateTimes.of((String)"2020-01-01"), (Object)row.getTimestamp());
        Assert.assertEquals((Object)"val", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("dim")));
        Assert.assertEquals((Object)"val2", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("met")));
    }

    private static class TrackingJsonInputFormat
    extends JsonInputFormat {
        Props props;

        private TrackingJsonInputFormat(@Nullable JSONPathSpec flattenSpec, @Nullable Map<String, Boolean> featureSpec) {
            super(flattenSpec, featureSpec, null, null, null);
            this.props = new Props();
        }

        private TrackingJsonInputFormat(@Nullable JSONPathSpec flattenSpec, @Nullable Map<String, Boolean> featureSpec, boolean lineSplittable, Props props) {
            super(flattenSpec, featureSpec, null, lineSplittable, null, null);
            this.props = props;
        }

        public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
            this.props.used = true;
            return super.createReader(inputRowSchema, source, temporaryDirectory);
        }

        public JsonInputFormat withLineSplittable(boolean lineSplittable) {
            return new TrackingJsonInputFormat(this.getFlattenSpec(), this.getFeatureSpec(), lineSplittable, this.props);
        }

        static class Props {
            private boolean used;

            Props() {
            }
        }
    }
}

