/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.test;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.timeline.DataSegment;

public class TestDataSegmentAnnouncer
implements DataSegmentAnnouncer {
    public Set<DataSegment> announcedSegments = Sets.newConcurrentHashSet();

    public void announceSegment(DataSegment segment) {
        this.announcedSegments.add(segment);
    }

    public void unannounceSegment(DataSegment segment) {
        this.announcedSegments.remove(segment);
    }

    public void announceSegments(Iterable<DataSegment> segments) {
        for (DataSegment segment : segments) {
            this.announcedSegments.add(segment);
        }
    }

    public void unannounceSegments(Iterable<DataSegment> segments) {
        for (DataSegment segment : segments) {
            this.announcedSegments.remove(segment);
        }
    }
}

