/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.RealtimeIndexTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.firehose.LocalFirehoseFactory;
import org.junit.Assert;
import org.junit.Test;

public class TaskAnnouncementTest {
    private final ObjectMapper jsonMapper;

    public TaskAnnouncementTest() {
        TestUtils testUtils = new TestUtils();
        this.jsonMapper = testUtils.getTestObjectMapper();
    }

    @Test
    public void testBackwardsCompatibleSerde() throws Exception {
        RealtimeIndexTask task = new RealtimeIndexTask("theid", new TaskResource("rofl", 2), new FireDepartment(new DataSchema("foo", null, new AggregatorFactory[0], null, null, (ObjectMapper)new DefaultObjectMapper()), new RealtimeIOConfig((FirehoseFactory)new LocalFirehoseFactory(new File("lol"), "rofl", null), (schema, config, metrics) -> null), null), null);
        TaskStatus status = TaskStatus.running((String)task.getId());
        TaskAnnouncement announcement = TaskAnnouncement.create((Task)task, (TaskStatus)status, (TaskLocation)TaskLocation.unknown());
        String statusJson = this.jsonMapper.writeValueAsString((Object)status);
        String announcementJson = this.jsonMapper.writeValueAsString((Object)announcement);
        TaskStatus statusFromStatus = (TaskStatus)this.jsonMapper.readValue(statusJson, TaskStatus.class);
        TaskStatus statusFromAnnouncement = (TaskStatus)this.jsonMapper.readValue(announcementJson, TaskStatus.class);
        TaskAnnouncement announcementFromStatus = (TaskAnnouncement)this.jsonMapper.readValue(statusJson, TaskAnnouncement.class);
        TaskAnnouncement announcementFromAnnouncement = (TaskAnnouncement)this.jsonMapper.readValue(announcementJson, TaskAnnouncement.class);
        Assert.assertEquals((Object)"theid", (Object)statusFromStatus.getId());
        Assert.assertEquals((Object)"theid", (Object)statusFromAnnouncement.getId());
        Assert.assertEquals((Object)"theid", (Object)announcementFromStatus.getTaskStatus().getId());
        Assert.assertEquals((Object)"theid", (Object)announcementFromAnnouncement.getTaskStatus().getId());
        Assert.assertEquals((Object)"theid", (Object)announcementFromStatus.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((Object)"rofl", (Object)announcementFromAnnouncement.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((long)1L, (long)announcementFromStatus.getTaskResource().getRequiredCapacity());
        Assert.assertEquals((long)2L, (long)announcementFromAnnouncement.getTaskResource().getRequiredCapacity());
    }
}

