/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.TestTasks;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.NoopTestTaskReportFileWriter;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.overlord.TestTaskRunner;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.WorkerHistoryItem;
import org.apache.druid.indexing.worker.WorkerTaskManager;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9Factory;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.druid.server.security.AuthTestUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkerTaskManagerTest {
    private final TaskLocation location = TaskLocation.create((String)"localhost", (int)1, (int)2);
    private final TestUtils testUtils = new TestUtils();
    private final ObjectMapper jsonMapper = this.testUtils.getTestObjectMapper();
    private final IndexMergerV9Factory indexMergerV9Factory;
    private final IndexIO indexIO;
    private WorkerTaskManager workerTaskManager;

    public WorkerTaskManagerTest() {
        TestTasks.registerSubtypes(this.jsonMapper);
        this.indexMergerV9Factory = this.testUtils.getIndexMergerV9Factory();
        this.indexIO = this.testUtils.getTestIndexIO();
    }

    private WorkerTaskManager createWorkerTaskManager() {
        TaskConfig taskConfig = new TaskConfig(FileUtils.createTempDir().toString(), null, null, Integer.valueOf(0), null, false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null, false);
        TaskActionClientFactory taskActionClientFactory = (TaskActionClientFactory)EasyMock.createNiceMock(TaskActionClientFactory.class);
        TaskActionClient taskActionClient = (TaskActionClient)EasyMock.createNiceMock(TaskActionClient.class);
        EasyMock.expect((Object)taskActionClientFactory.create((Task)EasyMock.anyObject())).andReturn((Object)taskActionClient).anyTimes();
        SegmentHandoffNotifierFactory notifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
        EasyMock.replay((Object[])new Object[]{taskActionClientFactory, taskActionClient, notifierFactory});
        return new WorkerTaskManager(this.jsonMapper, new TestTaskRunner(new TaskToolboxFactory(taskConfig, null, taskActionClientFactory, null, null, null, null, null, null, null, notifierFactory, null, null, (JoinableFactory)NoopJoinableFactory.INSTANCE, null, new SegmentCacheManagerFactory(this.jsonMapper), this.jsonMapper, this.indexIO, null, null, null, this.indexMergerV9Factory, null, null, null, null, (TaskReportFileWriter)new NoopTestTaskReportFileWriter(), null, AuthTestUtils.TEST_AUTHORIZER_MAPPER, (ChatHandlerProvider)new NoopChatHandlerProvider(), this.testUtils.getRowIngestionMetersFactory(), (AppenderatorsManager)new TestAppenderatorsManager(), (OverlordClient)new NoopOverlordClient(), null, null, null, null, "1"), taskConfig, this.location), taskConfig, (DruidLeaderClient)EasyMock.createNiceMock(DruidLeaderClient.class)){

            protected void taskStarted(String taskId) {
            }

            protected void taskAnnouncementChanged(TaskAnnouncement announcement) {
            }
        };
    }

    @Before
    public void setUp() {
        this.workerTaskManager = this.createWorkerTaskManager();
    }

    @After
    public void tearDown() throws Exception {
        this.workerTaskManager.stop();
    }

    @Test(timeout=60000L)
    public void testTaskRun() throws Exception {
        NoopTask task1 = this.createNoopTask("task1-assigned-via-assign-dir");
        NoopTask task2 = this.createNoopTask("task2-completed-already");
        NoopTask task3 = this.createNoopTask("task3-assigned-explicitly");
        FileUtils.mkdirp((File)this.workerTaskManager.getAssignedTaskDir());
        FileUtils.mkdirp((File)this.workerTaskManager.getCompletedTaskDir());
        this.jsonMapper.writeValue(new File(this.workerTaskManager.getAssignedTaskDir(), task1.getId()), (Object)task1);
        this.jsonMapper.writeValue(new File(this.workerTaskManager.getCompletedTaskDir(), task2.getId()), (Object)TaskAnnouncement.create((Task)task2, (TaskStatus)TaskStatus.success((String)task2.getId()), (TaskLocation)this.location));
        this.workerTaskManager.start();
        Assert.assertTrue((boolean)((TaskAnnouncement)this.workerTaskManager.getCompletedTasks().get(task2.getId())).getTaskStatus().isSuccess());
        while (!this.workerTaskManager.getCompletedTasks().containsKey(task1.getId())) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)((TaskAnnouncement)this.workerTaskManager.getCompletedTasks().get(task1.getId())).getTaskStatus().isSuccess());
        Assert.assertTrue((boolean)new File(this.workerTaskManager.getCompletedTaskDir(), task1.getId()).exists());
        Assert.assertFalse((boolean)new File(this.workerTaskManager.getAssignedTaskDir(), task1.getId()).exists());
        ChangeRequestsSnapshot baseHistory = (ChangeRequestsSnapshot)this.workerTaskManager.getChangesSince(new ChangeRequestHistory.Counter(-1L, 0L)).get();
        Assert.assertFalse((boolean)baseHistory.isResetCounter());
        Assert.assertEquals((long)3L, (long)baseHistory.getRequests().size());
        Assert.assertFalse((boolean)((WorkerHistoryItem.Metadata)baseHistory.getRequests().get(0)).isDisabled());
        WorkerHistoryItem.TaskUpdate baseUpdate1 = (WorkerHistoryItem.TaskUpdate)baseHistory.getRequests().get(1);
        WorkerHistoryItem.TaskUpdate baseUpdate2 = (WorkerHistoryItem.TaskUpdate)baseHistory.getRequests().get(2);
        Assert.assertTrue((boolean)baseUpdate1.getTaskAnnouncement().getTaskStatus().isSuccess());
        Assert.assertTrue((boolean)baseUpdate2.getTaskAnnouncement().getTaskStatus().isSuccess());
        Assert.assertEquals((Object)ImmutableSet.of((Object)task1.getId(), (Object)task2.getId()), (Object)ImmutableSet.of((Object)baseUpdate1.getTaskAnnouncement().getTaskStatus().getId(), (Object)baseUpdate2.getTaskAnnouncement().getTaskStatus().getId()));
        this.workerTaskManager.assignTask((Task)task3);
        while (!this.workerTaskManager.getCompletedTasks().containsKey(task3.getId())) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)((TaskAnnouncement)this.workerTaskManager.getCompletedTasks().get(task3.getId())).getTaskStatus().isSuccess());
        Assert.assertTrue((boolean)new File(this.workerTaskManager.getCompletedTaskDir(), task3.getId()).exists());
        Assert.assertFalse((boolean)new File(this.workerTaskManager.getAssignedTaskDir(), task3.getId()).exists());
        ChangeRequestsSnapshot changes = (ChangeRequestsSnapshot)this.workerTaskManager.getChangesSince(baseHistory.getCounter()).get();
        Assert.assertFalse((boolean)changes.isResetCounter());
        Assert.assertEquals((long)4L, (long)changes.getRequests().size());
        WorkerHistoryItem.TaskUpdate update1 = (WorkerHistoryItem.TaskUpdate)changes.getRequests().get(0);
        Assert.assertEquals((Object)task3.getId(), (Object)update1.getTaskAnnouncement().getTaskStatus().getId());
        Assert.assertTrue((boolean)update1.getTaskAnnouncement().getTaskStatus().isRunnable());
        Assert.assertNull((Object)update1.getTaskAnnouncement().getTaskLocation().getHost());
        WorkerHistoryItem.TaskUpdate update2 = (WorkerHistoryItem.TaskUpdate)changes.getRequests().get(1);
        Assert.assertEquals((Object)task3.getId(), (Object)update2.getTaskAnnouncement().getTaskStatus().getId());
        Assert.assertTrue((boolean)update2.getTaskAnnouncement().getTaskStatus().isRunnable());
        Assert.assertNull((Object)update2.getTaskAnnouncement().getTaskLocation().getHost());
        WorkerHistoryItem.TaskUpdate update3 = (WorkerHistoryItem.TaskUpdate)changes.getRequests().get(2);
        Assert.assertEquals((Object)task3.getId(), (Object)update3.getTaskAnnouncement().getTaskStatus().getId());
        Assert.assertTrue((boolean)update3.getTaskAnnouncement().getTaskStatus().isRunnable());
        Assert.assertNotNull((Object)update3.getTaskAnnouncement().getTaskLocation().getHost());
        WorkerHistoryItem.TaskUpdate update4 = (WorkerHistoryItem.TaskUpdate)changes.getRequests().get(3);
        Assert.assertEquals((Object)task3.getId(), (Object)update4.getTaskAnnouncement().getTaskStatus().getId());
        Assert.assertTrue((boolean)update4.getTaskAnnouncement().getTaskStatus().isSuccess());
        Assert.assertNotNull((Object)update4.getTaskAnnouncement().getTaskLocation().getHost());
    }

    @Test(timeout=30000L)
    public void testTaskStatusWhenTaskRunnerFutureThrowsException() throws Exception {
        Map completeTasks;
        NoopTask task = new NoopTask("id", null, null, 100L, 0L, null, null, (Map)ImmutableMap.of((Object)"priority", (Object)0)){

            public TaskStatus runTask(TaskToolbox toolbox) {
                throw new Error("task failure test");
            }
        };
        this.workerTaskManager.start();
        this.workerTaskManager.assignTask((Task)task);
        while ((completeTasks = this.workerTaskManager.getCompletedTasks()).isEmpty()) {
        }
        Assert.assertEquals((long)1L, (long)completeTasks.size());
        TaskAnnouncement announcement = (TaskAnnouncement)completeTasks.get(task.getId());
        Assert.assertNotNull((Object)announcement);
        Assert.assertEquals((Object)TaskState.FAILED, (Object)announcement.getStatus());
        Assert.assertEquals((Object)"Failed to run task with an exception. See middleManager or indexer logs for more details.", (Object)announcement.getTaskStatus().getErrorMsg());
    }

    private NoopTask createNoopTask(String id) {
        return new NoopTask(id, null, null, 100L, 0L, null, null, (Map)ImmutableMap.of((Object)"priority", (Object)0));
    }
}

