/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collections;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;

public class SegmentCacheManagerFactory {
    private final ObjectMapper jsonMapper;

    @Inject
    public SegmentCacheManagerFactory(@Json ObjectMapper mapper) {
        this.jsonMapper = mapper;
    }

    public SegmentCacheManager manufacturate(File storageDir) {
        return new SegmentLocalCacheManager(new SegmentLoaderConfig().withLocations(Collections.singletonList(new StorageLocationConfig(storageDir, null, null))), this.jsonMapper);
    }
}

