/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class SingleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(SingleFileTaskReportFileWriter.class);
    private final File reportsFile;
    private ObjectMapper objectMapper;

    public SingleFileTaskReportFileWriter(File reportsFile) {
        this.reportsFile = reportsFile;
    }

    @Override
    public void write(String taskId, Map<String, TaskReport> reports) {
        try {
            File reportsFileParent = this.reportsFile.getParentFile();
            if (reportsFileParent != null) {
                FileUtils.mkdirp((File)reportsFileParent);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.reportsFile);){
                SingleFileTaskReportFileWriter.writeReportToStream(this.objectMapper, outputStream, reports);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in write().", new Object[0]);
        }
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static void writeReportToStream(ObjectMapper objectMapper, OutputStream outputStream, Map<String, TaskReport> reports) throws Exception {
        SerializerProvider serializers = objectMapper.getSerializerProviderInstance();
        try (JsonGenerator jg = objectMapper.getFactory().createGenerator(outputStream);){
            jg.writeStartObject();
            for (Map.Entry<String, TaskReport> entry : reports.entrySet()) {
                jg.writeFieldName(entry.getKey());
                JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)entry.getValue());
            }
            jg.writeEndObject();
        }
    }
}

