/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;

public class UpdateStatusAction
implements TaskAction<Void> {
    @JsonIgnore
    private final String status;

    @JsonCreator
    public UpdateStatusAction(@JsonProperty(value="status") String status) {
        this.status = status;
    }

    @JsonProperty
    public String getStatus() {
        return this.status;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) {
        Optional<TaskRunner> taskRunner = toolbox.getTaskRunner();
        if (taskRunner.isPresent()) {
            TaskStatus result = "successful".equals(this.status) ? TaskStatus.success((String)task.getId()) : TaskStatus.failure((String)task.getId(), (String)"Error with task");
            ((TaskRunner)taskRunner.get()).updateStatus(task, result);
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "UpdateStatusAction{status=" + this.status + '}';
    }
}

