/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.IAE;

public class ArrayOfStringsNullSafeSerde
extends ArrayOfItemsSerDe<String> {
    private static final int NULL_STRING_LENGTH = -1;

    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            length += 4;
            if (items[i] == null) continue;
            itemsBytes[i] = items[i].getBytes(StandardCharsets.UTF_8);
            length += itemsBytes[i].length;
        }
        byte[] bytes = new byte[length];
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            if (itemsBytes[i] != null) {
                mem.putInt(offsetBytes, itemsBytes[i].length);
                mem.putByteArray(offsetBytes += 4L, itemsBytes[i], 0, itemsBytes[i].length);
                offsetBytes += (long)itemsBytes[i].length;
                continue;
            }
            mem.putInt(offsetBytes, -1);
            offsetBytes += 4L;
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            Util.checkBounds((long)offsetBytes, (long)4L, (long)mem.getCapacity());
            int strLength = mem.getInt(offsetBytes);
            offsetBytes += 4L;
            if (strLength >= 0) {
                byte[] bytes = new byte[strLength];
                Util.checkBounds((long)offsetBytes, (long)strLength, (long)mem.getCapacity());
                mem.getByteArray(offsetBytes, bytes, 0, strLength);
                offsetBytes += (long)strLength;
                array[i] = new String(bytes, StandardCharsets.UTF_8);
                continue;
            }
            if (strLength == -1) continue;
            throw new IAE("Illegal strLength [%s] at offset [%s]. Must be %s, 0 or a positive integer.", new Object[]{strLength, offsetBytes, -1});
        }
        return array;
    }
}

