/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.indexing.input.DruidSegmentReader;
import org.apache.druid.indexing.input.DruidTombstoneSegmentReader;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;

public class DruidSegmentInputFormat
implements InputFormat {
    private final IndexIO indexIO;
    private final DimFilter dimFilter;

    public DruidSegmentInputFormat(IndexIO indexIO, DimFilter dimFilter) {
        this.indexIO = indexIO;
        this.dimFilter = dimFilter;
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        Preconditions.checkArgument((boolean)(source instanceof DruidSegmentInputEntity), (Object)(DruidSegmentInputEntity.class.getName() + " required, but " + source.getClass().getName() + " provided."));
        IntermediateRowParsingReader retVal = ((DruidSegmentInputEntity)source).isFromTombstone() ? new DruidTombstoneSegmentReader(source) : new DruidSegmentReader(source, this.indexIO, inputRowSchema.getTimestampSpec(), inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter(), this.dimFilter, temporaryDirectory);
        return retVal;
    }
}

