/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.IndexTaskClient;
import org.apache.druid.indexing.common.RetryPolicy;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClient;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public abstract class SeekableStreamIndexTaskClientSyncImpl<PartitionIdType, SequenceOffsetType>
extends IndexTaskClient
implements SeekableStreamIndexTaskClient<PartitionIdType, SequenceOffsetType> {
    private static final EmittingLogger log = new EmittingLogger(SeekableStreamIndexTaskClient.class);

    public SeekableStreamIndexTaskClientSyncImpl(HttpClient httpClient, ObjectMapper jsonMapper, TaskInfoProvider taskInfoProvider, String dataSource, int numThreads, Duration httpTimeout, long numRetries) {
        super(httpClient, jsonMapper, taskInfoProvider, httpTimeout, dataSource, numThreads, numRetries);
    }

    private boolean stop(String id, boolean publish) {
        log.debug("Stop task[%s] publish[%s]", new Object[]{id, publish});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.POST, "stop", publish ? "publish=true" : null, true);
            return this.isSuccess(response);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return false;
        }
        catch (IndexTaskClient.TaskNotRunnableException e) {
            log.info("Task [%s] couldn't be stopped because it is no longer running", new Object[]{id});
            return true;
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception while stopping task [%s]", new Object[]{id});
            return false;
        }
    }

    private boolean resume(String id) {
        log.debug("Resume task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.POST, "resume", null, true);
            return this.isSuccess(response);
        }
        catch (IOException | IndexTaskClient.NoTaskLocationException e) {
            log.warn((Throwable)e, "Exception while stopping task [%s]", new Object[]{id});
            return false;
        }
    }

    private Map<PartitionIdType, SequenceOffsetType> pause(String id) {
        log.debug("Pause task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.POST, "pause", null, true);
            HttpResponseStatus responseStatus = response.getStatus();
            String responseContent = response.getContent();
            if (responseStatus.equals((Object)HttpResponseStatus.OK)) {
                log.info("Task [%s] paused successfully", new Object[]{id});
                return (Map)this.deserializeMap(responseContent, Map.class, this.getPartitionType(), this.getSequenceType());
            }
            if (responseStatus.equals((Object)HttpResponseStatus.ACCEPTED)) {
                RetryPolicy retryPolicy = this.newRetryPolicy();
                while (true) {
                    SeekableStreamIndexTaskRunner.Status status;
                    if ((status = this.getStatus(id)) == SeekableStreamIndexTaskRunner.Status.PAUSED) {
                        return this.getCurrentOffsets(id, true);
                    }
                    Duration delay = retryPolicy.getAndIncrementRetryDelay();
                    if (delay == null) {
                        throw new ISE("Task [%s] failed to change its status from [%s] to [%s], aborting", new Object[]{id, status, SeekableStreamIndexTaskRunner.Status.PAUSED});
                    }
                    long sleepTime = delay.getMillis();
                    log.info("Still waiting for task [%s] to change its status to [%s]; will try again in [%s]", new Object[]{id, SeekableStreamIndexTaskRunner.Status.PAUSED, new Duration(sleepTime).toString()});
                    Thread.sleep(sleepTime);
                }
            }
            throw new ISE("Pause request for task [%s] failed with response [%s] : [%s]", new Object[]{id, responseStatus, responseContent});
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            log.error("Exception [%s] while pausing Task [%s]", new Object[]{e.getMessage(), id});
            return ImmutableMap.of();
        }
        catch (IOException | InterruptedException e) {
            throw new RE((Throwable)e, "Exception [%s] while pausing Task [%s]", new Object[]{e.getMessage(), id});
        }
    }

    private SeekableStreamIndexTaskRunner.Status getStatus(String id) {
        log.debug("GetStatus task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "status", null, true);
            return this.deserialize(response.getContent(), SeekableStreamIndexTaskRunner.Status.class);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return SeekableStreamIndexTaskRunner.Status.NOT_STARTED;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private DateTime getStartTime(String id) {
        log.debug("GetStartTime task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "time/start", null, true);
            return response.getContent() == null || response.getContent().isEmpty() ? null : this.deserialize(response.getContent(), DateTime.class);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> getMovingAverages(String id) {
        log.debug("GetMovingAverages task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "rowStats", null, true);
            if (response.getContent() == null || response.getContent().isEmpty()) {
                log.warn("Got empty response when calling getMovingAverages, id[%s]", new Object[]{id});
                return Collections.emptyMap();
            }
            return (Map)this.deserialize(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            log.warn((Throwable)e, "Got NoTaskLocationException when calling getMovingAverages, id[%s]", new Object[]{id});
            return Collections.emptyMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<ParseExceptionReport> getParseErrors(String id) {
        log.debug("getParseErrors task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "unparseableEvents", null, true);
            if (response.getContent() == null || response.getContent().isEmpty()) {
                log.warn("Got empty response when calling getParseErrors, id[%s]", new Object[]{id});
                return Collections.emptyList();
            }
            return (List)this.deserialize(response.getContent(), TYPE_REFERENCE_LIST_PARSE_EXCEPTION_REPORT);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            log.warn((Throwable)e, "Got NoTaskLocationException when calling getParseErrors, id[%s]", new Object[]{id});
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<PartitionIdType, SequenceOffsetType> getCurrentOffsets(String id, boolean retry) {
        log.debug("GetCurrentOffsets task[%s] retry[%s]", new Object[]{id, retry});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "offsets/current", null, retry);
            return (Map)this.deserializeMap(response.getContent(), Map.class, this.getPartitionType(), this.getSequenceType());
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return ImmutableMap.of();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TreeMap<Integer, Map<PartitionIdType, SequenceOffsetType>> getCheckpoints(String id, boolean retry) {
        log.debug("GetCheckpoints task[%s] retry[%s]", new Object[]{id, retry});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "checkpoints", null, retry);
            return (TreeMap)this.deserializeNestedValueMap(response.getContent(), TreeMap.class, Integer.class, Map.class, this.getPartitionType(), this.getSequenceType());
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return new TreeMap<Integer, Map<PartitionIdType, SequenceOffsetType>>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListenableFuture<TreeMap<Integer, Map<PartitionIdType, SequenceOffsetType>>> getCheckpointsAsync(String id, boolean retry) {
        return this.doAsync(() -> this.getCheckpoints(id, retry));
    }

    private Map<PartitionIdType, SequenceOffsetType> getEndOffsets(String id) {
        log.debug("GetEndOffsets task[%s]", new Object[]{id});
        try {
            StringFullResponseHolder response = this.submitRequestWithEmptyContent(id, HttpMethod.GET, "offsets/end", null, true);
            return (Map)this.deserializeMap(response.getContent(), Map.class, this.getPartitionType(), this.getSequenceType());
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return ImmutableMap.of();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean setEndOffsets(String id, Map<PartitionIdType, SequenceOffsetType> endOffsets, boolean finalize) throws IOException {
        log.debug("SetEndOffsets task[%s] endOffsets[%s] finalize[%s]", new Object[]{id, endOffsets, finalize});
        try {
            StringFullResponseHolder response = this.submitJsonRequest(id, HttpMethod.POST, "offsets/end", StringUtils.format((String)"finish=%s", (Object[])new Object[]{finalize}), this.serialize(endOffsets), true);
            return this.isSuccess(response);
        }
        catch (IndexTaskClient.NoTaskLocationException e) {
            return false;
        }
    }

    @Override
    public ListenableFuture<Boolean> stopAsync(String id, boolean publish) {
        return this.doAsync(() -> this.stop(id, publish));
    }

    @Override
    public ListenableFuture<Boolean> resumeAsync(String id) {
        return this.doAsync(() -> this.resume(id));
    }

    @Override
    public ListenableFuture<DateTime> getStartTimeAsync(String id) {
        return this.doAsync(() -> this.getStartTime(id));
    }

    @Override
    public ListenableFuture<Map<PartitionIdType, SequenceOffsetType>> pauseAsync(String id) {
        return this.doAsync(() -> this.pause(id));
    }

    @Override
    public ListenableFuture<Boolean> setEndOffsetsAsync(String id, Map<PartitionIdType, SequenceOffsetType> endOffsets, boolean finalize) {
        return this.doAsync(() -> this.setEndOffsets(id, endOffsets, finalize));
    }

    @Override
    public ListenableFuture<Map<PartitionIdType, SequenceOffsetType>> getCurrentOffsetsAsync(String id, boolean retry) {
        return this.doAsync(() -> this.getCurrentOffsets(id, retry));
    }

    @Override
    public ListenableFuture<Map<PartitionIdType, SequenceOffsetType>> getEndOffsetsAsync(String id) {
        return this.doAsync(() -> this.getEndOffsets(id));
    }

    @Override
    public ListenableFuture<Map<String, Object>> getMovingAveragesAsync(String id) {
        return this.doAsync(() -> this.getMovingAverages(id));
    }

    @Override
    public ListenableFuture<List<ParseExceptionReport>> getParseErrorsAsync(String id) {
        return this.doAsync(() -> this.getParseErrors(id));
    }

    @Override
    public ListenableFuture<SeekableStreamIndexTaskRunner.Status> getStatusAsync(String id) {
        return this.doAsync(() -> this.getStatus(id));
    }
}

