/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class RetrieveUnusedSegmentsAction
implements TaskAction<List<DataSegment>> {
    @JsonIgnore
    private final String dataSource;
    @JsonIgnore
    private final Interval interval;
    @JsonIgnore
    private final Integer limit;
    @JsonIgnore
    private final DateTime maxUsedStatusLastUpdatedTime;

    @JsonCreator
    public RetrieveUnusedSegmentsAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="limit") @Nullable Integer limit, @JsonProperty(value="maxUsedStatusLastUpdatedTime") @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        this.dataSource = dataSource;
        this.interval = interval;
        this.limit = limit;
        this.maxUsedStatusLastUpdatedTime = maxUsedStatusLastUpdatedTime;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    @JsonProperty
    public DateTime getMaxUsedStatusLastUpdatedTime() {
        return this.maxUsedStatusLastUpdatedTime;
    }

    @Override
    public TypeReference<List<DataSegment>> getReturnTypeReference() {
        return new TypeReference<List<DataSegment>>(){};
    }

    @Override
    public List<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().retrieveUnusedSegmentsForInterval(this.dataSource, this.interval, this.limit, this.maxUsedStatusLastUpdatedTime);
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", limit=" + this.limit + ", maxUsedStatusLastUpdatedTime=" + this.maxUsedStatusLastUpdatedTime + '}';
    }
}

