/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;

public class TaskRealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(TaskRealtimeMetricsMonitor.class);
    private final FireDepartment fireDepartment;
    private final RowIngestionMeters rowIngestionMeters;
    private final Map<String, String[]> dimensions;
    @Nullable
    private final Map<String, Object> metricTags;
    private FireDepartmentMetrics previousFireDepartmentMetrics;
    private RowIngestionMetersTotals previousRowIngestionMetersTotals;

    public TaskRealtimeMetricsMonitor(FireDepartment fireDepartment, RowIngestionMeters rowIngestionMeters, Map<String, String[]> dimensions, @Nullable Map<String, Object> metricTags) {
        this.fireDepartment = fireDepartment;
        this.rowIngestionMeters = rowIngestionMeters;
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.metricTags = metricTags;
        this.previousFireDepartmentMetrics = new FireDepartmentMetrics();
        this.previousRowIngestionMetersTotals = new RowIngestionMetersTotals(0L, 0L, 0L, 0L, 0L);
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        long maxSegmentHandoffTime;
        FireDepartmentMetrics metrics = this.fireDepartment.getMetrics().snapshot();
        RowIngestionMetersTotals rowIngestionMetersTotals = this.rowIngestionMeters.getTotals();
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)this.fireDepartment.getDataSchema().getDataSource());
        MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
        long thrownAway = rowIngestionMetersTotals.getThrownAway() - this.previousRowIngestionMetersTotals.getThrownAway();
        if (thrownAway > 0L) {
            log.warn("[%,d] events thrown away. Possible causes: null events, events filtered out by transformSpec, or events outside earlyMessageRejectionPeriod / lateMessageRejectionPeriod.", new Object[]{thrownAway});
        }
        builder.setDimensionIfNotNull("tags", this.metricTags);
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/thrownAway", (Number)thrownAway));
        long unparseable = rowIngestionMetersTotals.getUnparseable() - this.previousRowIngestionMetersTotals.getUnparseable();
        if (unparseable > 0L) {
            log.error("[%,d] unparseable events discarded. Turn on debug logging to see exception stack trace.", new Object[]{unparseable});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/unparseable", (Number)unparseable));
        long processedWithError = rowIngestionMetersTotals.getProcessedWithError() - this.previousRowIngestionMetersTotals.getProcessedWithError();
        if (processedWithError > 0L) {
            log.error("[%,d] events processed with errors! Set logParseExceptions to true in the ingestion spec to log these errors.", new Object[]{processedWithError});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/processedWithError", (Number)processedWithError));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/processed", (Number)(rowIngestionMetersTotals.getProcessed() - this.previousRowIngestionMetersTotals.getProcessed())));
        long dedup = metrics.dedup() - this.previousFireDepartmentMetrics.dedup();
        if (dedup > 0L) {
            log.warn("[%,d] duplicate events!", new Object[]{dedup});
        }
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/duplicate", (Number)dedup));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/input/bytes", (Number)(rowIngestionMetersTotals.getProcessedBytes() - this.previousRowIngestionMetersTotals.getProcessedBytes())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/rows/output", (Number)(metrics.rowOutput() - this.previousFireDepartmentMetrics.rowOutput())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/count", (Number)(metrics.numPersists() - this.previousFireDepartmentMetrics.numPersists())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/time", (Number)(metrics.persistTimeMillis() - this.previousFireDepartmentMetrics.persistTimeMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/cpu", (Number)(metrics.persistCpuTime() - this.previousFireDepartmentMetrics.persistCpuTime())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/backPressure", (Number)(metrics.persistBackPressureMillis() - this.previousFireDepartmentMetrics.persistBackPressureMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/persists/failed", (Number)(metrics.failedPersists() - this.previousFireDepartmentMetrics.failedPersists())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/failed", (Number)(metrics.failedHandoffs() - this.previousFireDepartmentMetrics.failedHandoffs())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/time", (Number)(metrics.mergeTimeMillis() - this.previousFireDepartmentMetrics.mergeTimeMillis())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/merge/cpu", (Number)(metrics.mergeCpuTime() - this.previousFireDepartmentMetrics.mergeCpuTime())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/count", (Number)(metrics.handOffCount() - this.previousFireDepartmentMetrics.handOffCount())));
        emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/sink/count", (Number)metrics.sinkCount()));
        long messageGap = metrics.messageGap();
        if (messageGap >= 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/events/messageGap", (Number)messageGap));
        }
        if ((maxSegmentHandoffTime = metrics.maxSegmentHandoffTime()) >= 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("ingest/handoff/time", (Number)maxSegmentHandoffTime));
        }
        this.previousRowIngestionMetersTotals = rowIngestionMetersTotals;
        this.previousFireDepartmentMetrics = metrics;
        return true;
    }
}

