/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.File;
import java.util.List;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.java.util.common.ISE;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Initialization {
    public static File[] getHadoopDependencyFilesToLoad(List<String> hadoopDependencyCoordinates, ExtensionsConfig extensionsConfig) {
        File rootHadoopDependenciesDir = new File(extensionsConfig.getHadoopDependenciesDir());
        if (rootHadoopDependenciesDir.exists() && !rootHadoopDependenciesDir.isDirectory()) {
            throw new ISE("Root Hadoop dependencies directory [%s] is not a directory!?", new Object[]{rootHadoopDependenciesDir});
        }
        File[] hadoopDependenciesToLoad = new File[hadoopDependencyCoordinates.size()];
        int i = 0;
        for (String coordinate : hadoopDependencyCoordinates) {
            DefaultArtifact artifact = new DefaultArtifact(coordinate);
            File hadoopDependencyDir = new File(rootHadoopDependenciesDir, artifact.getArtifactId());
            File versionDir = new File(hadoopDependencyDir, artifact.getVersion());
            if (!hadoopDependencyDir.isDirectory() || !versionDir.isDirectory()) {
                throw new ISE("Hadoop dependency [%s] didn't exist!?", new Object[]{versionDir.getAbsolutePath()});
            }
            hadoopDependenciesToLoad[i++] = versionDir;
        }
        return hadoopDependenciesToLoad;
    }
}

