/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.curator.shaded.com.google.common.base.Verify;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class Tasks {
    public static final int DEFAULT_REALTIME_TASK_PRIORITY = 75;
    public static final int DEFAULT_BATCH_INDEX_TASK_PRIORITY = 50;
    public static final int DEFAULT_MERGE_TASK_PRIORITY = 25;
    public static final int DEFAULT_TASK_PRIORITY = 0;
    public static final long DEFAULT_LOCK_TIMEOUT_MILLIS;
    public static final boolean DEFAULT_FORCE_TIME_CHUNK_LOCK = true;
    public static final boolean DEFAULT_STORE_COMPACTION_STATE = false;
    public static final boolean DEFAULT_USE_MAX_MEMORY_ESTIMATES = false;
    public static final TaskLockType DEFAULT_TASK_LOCK_TYPE;
    public static final boolean DEFAULT_USE_CONCURRENT_LOCKS = false;
    public static final String PRIORITY_KEY = "priority";
    public static final String LOCK_TIMEOUT_KEY = "taskLockTimeout";
    public static final String FORCE_TIME_CHUNK_LOCK_KEY = "forceTimeChunkLock";
    public static final String STORE_EMPTY_COLUMNS_KEY = "storeEmptyColumns";
    public static final String USE_SHARED_LOCK = "useSharedLock";
    public static final String TASK_LOCK_TYPE = "taskLockType";
    public static final String USE_CONCURRENT_LOCKS = "useConcurrentLocks";
    public static final String USE_MAX_MEMORY_ESTIMATES = "useMaxMemoryEstimates";
    public static final String STORE_COMPACTION_STATE_KEY = "storeCompactionState";

    public static SortedSet<Interval> computeCondensedIntervals(SortedSet<Interval> intervals) {
        TreeSet<Interval> condensedIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        ArrayList<Interval> toBeAccumulated = new ArrayList<Interval>();
        for (Interval interval : intervals) {
            if (toBeAccumulated.size() == 0) {
                toBeAccumulated.add(interval);
                continue;
            }
            if (((Interval)toBeAccumulated.get(toBeAccumulated.size() - 1)).abuts((ReadableInterval)interval)) {
                toBeAccumulated.add(interval);
                continue;
            }
            condensedIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
            toBeAccumulated.clear();
            toBeAccumulated.add(interval);
        }
        if (toBeAccumulated.size() > 0) {
            condensedIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
        }
        return condensedIntervals;
    }

    static {
        Verify.verify((boolean)true);
        DEFAULT_LOCK_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
        DEFAULT_TASK_LOCK_TYPE = TaskLockType.EXCLUSIVE;
        Verify.verify((boolean)STORE_COMPACTION_STATE_KEY.equals(STORE_COMPACTION_STATE_KEY));
    }
}

