/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.joda.time.Period;

public class ParallelIndexTuningConfig
extends IndexTask.IndexTuningConfig {
    private static final int DEFAULT_MAX_NUM_CONCURRENT_SUB_TASKS = 1;
    private static final int DEFAULT_MAX_RETRY = 3;
    private static final long DEFAULT_TASK_STATUS_CHECK_PERIOD_MS = 1000L;
    private static final Duration DEFAULT_CHAT_HANDLER_TIMEOUT = new Period((Object)"PT10S").toStandardDuration();
    private static final int DEFAULT_CHAT_HANDLER_NUM_RETRIES = 5;
    private static final int DEFAULT_MAX_NUM_SEGMENTS_TO_MERGE = 100;
    private static final int DEFAULT_TOTAL_NUM_MERGE_TASKS = 10;
    private static final int DEFAULT_MAX_ALLOWED_LOCK_COUNT = -1;
    private final SplitHintSpec splitHintSpec;
    private final int maxNumConcurrentSubTasks;
    private final int maxRetry;
    private final long taskStatusCheckPeriodMs;
    private final Duration chatHandlerTimeout;
    private final int chatHandlerNumRetries;
    private final int maxNumSegmentsToMerge;
    private final int totalNumMergeTasks;
    private final int maxAllowedLockCount;

    public static ParallelIndexTuningConfig defaultConfig() {
        return new ParallelIndexTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @JsonCreator
    public ParallelIndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxTotalRows") @Deprecated @Nullable Long maxTotalRows, @JsonProperty(value="numShards") @Deprecated @Nullable Integer numShards, @JsonProperty(value="splitHintSpec") @Nullable SplitHintSpec splitHintSpec, @JsonProperty(value="partitionsSpec") @Nullable PartitionsSpec partitionsSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="maxNumSubTasks") @Deprecated @Nullable Integer maxNumSubTasks, @JsonProperty(value="maxNumConcurrentSubTasks") @Nullable Integer maxNumConcurrentSubTasks, @JsonProperty(value="maxRetry") @Nullable Integer maxRetry, @JsonProperty(value="taskStatusCheckPeriodMs") @Nullable Long taskStatusCheckPeriodMs, @JsonProperty(value="chatHandlerTimeout") @Nullable Duration chatHandlerTimeout, @JsonProperty(value="chatHandlerNumRetries") @Nullable Integer chatHandlerNumRetries, @JsonProperty(value="maxNumSegmentsToMerge") @Nullable Integer maxNumSegmentsToMerge, @JsonProperty(value="totalNumMergeTasks") @Nullable Integer totalNumMergeTasks, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxColumnsToMerge") @Nullable Integer maxColumnsToMerge, @JsonProperty(value="awaitSegmentAvailabilityTimeoutMillis") @Nullable Long awaitSegmentAvailabilityTimeoutMillis, @JsonProperty(value="maxAllowedLockCount") @Nullable Integer maxAllowedLockCount) {
        super(targetPartitionSize, maxRowsPerSegment, appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxTotalRows, null, numShards, null, partitionsSpec, indexSpec, indexSpecForIntermediatePersists, maxPendingPersists, forceGuaranteedRollup, reportParseExceptions, null, pushTimeout, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxColumnsToMerge, awaitSegmentAvailabilityTimeoutMillis);
        List partitionDimensions;
        if (maxNumSubTasks != null && maxNumConcurrentSubTasks != null) {
            throw new IAE("Can't use both maxNumSubTasks and maxNumConcurrentSubTasks. Use maxNumConcurrentSubTasks instead", new Object[0]);
        }
        this.splitHintSpec = splitHintSpec;
        this.maxNumConcurrentSubTasks = maxNumConcurrentSubTasks == null ? (maxNumSubTasks == null ? 1 : maxNumSubTasks) : maxNumConcurrentSubTasks;
        this.maxRetry = maxRetry == null ? 3 : maxRetry;
        this.taskStatusCheckPeriodMs = taskStatusCheckPeriodMs == null ? 1000L : taskStatusCheckPeriodMs;
        this.chatHandlerTimeout = chatHandlerTimeout == null ? DEFAULT_CHAT_HANDLER_TIMEOUT : chatHandlerTimeout;
        this.chatHandlerNumRetries = chatHandlerNumRetries == null ? 5 : chatHandlerNumRetries;
        this.maxNumSegmentsToMerge = maxNumSegmentsToMerge == null ? 100 : maxNumSegmentsToMerge;
        this.totalNumMergeTasks = totalNumMergeTasks == null ? 10 : totalNumMergeTasks;
        this.maxAllowedLockCount = maxAllowedLockCount == null ? -1 : maxAllowedLockCount;
        Preconditions.checkArgument((this.maxNumConcurrentSubTasks > 0 ? 1 : 0) != 0, (Object)"maxNumConcurrentSubTasks must be positive");
        Preconditions.checkArgument((this.maxNumSegmentsToMerge > 0 ? 1 : 0) != 0, (Object)"maxNumSegmentsToMerge must be positive");
        Preconditions.checkArgument((this.totalNumMergeTasks > 0 ? 1 : 0) != 0, (Object)"totalNumMergeTasks must be positive");
        if (this.getPartitionsSpec() != null && this.getPartitionsSpec() instanceof DimensionRangePartitionsSpec && ((partitionDimensions = ((DimensionRangePartitionsSpec)this.getPartitionsSpec()).getPartitionDimensions()) == null || partitionDimensions.isEmpty())) {
            throw new IAE("partitionDimensions must be specified", new Object[0]);
        }
    }

    @Nullable
    @JsonProperty
    public SplitHintSpec getSplitHintSpec() {
        return this.splitHintSpec;
    }

    @JsonProperty
    public int getMaxNumConcurrentSubTasks() {
        return this.maxNumConcurrentSubTasks;
    }

    @JsonProperty
    public int getMaxRetry() {
        return this.maxRetry;
    }

    @JsonProperty
    public long getTaskStatusCheckPeriodMs() {
        return this.taskStatusCheckPeriodMs;
    }

    @JsonProperty
    public Duration getChatHandlerTimeout() {
        return this.chatHandlerTimeout;
    }

    @JsonProperty
    public int getChatHandlerNumRetries() {
        return this.chatHandlerNumRetries;
    }

    @JsonProperty
    public int getMaxNumSegmentsToMerge() {
        return this.maxNumSegmentsToMerge;
    }

    @JsonProperty
    public int getTotalNumMergeTasks() {
        return this.totalNumMergeTasks;
    }

    @JsonProperty
    public int getMaxAllowedLockCount() {
        return this.maxAllowedLockCount;
    }

    @Override
    public ParallelIndexTuningConfig withPartitionsSpec(PartitionsSpec partitionsSpec) {
        return new ParallelIndexTuningConfig(null, null, this.getAppendableIndexSpec(), this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.isSkipBytesInMemoryOverheadCheck(), null, null, this.getSplitHintSpec(), partitionsSpec, this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), this.getMaxPendingPersists(), this.isForceGuaranteedRollup(), this.isReportParseExceptions(), this.getPushTimeout(), this.getSegmentWriteOutMediumFactory(), null, this.getMaxNumConcurrentSubTasks(), this.getMaxRetry(), this.getTaskStatusCheckPeriodMs(), this.getChatHandlerTimeout(), this.getChatHandlerNumRetries(), this.getMaxNumSegmentsToMerge(), this.getTotalNumMergeTasks(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxColumnsToMerge(), this.getAwaitSegmentAvailabilityTimeoutMillis(), this.getMaxAllowedLockCount());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParallelIndexTuningConfig that = (ParallelIndexTuningConfig)o;
        return this.maxNumConcurrentSubTasks == that.maxNumConcurrentSubTasks && this.maxRetry == that.maxRetry && this.taskStatusCheckPeriodMs == that.taskStatusCheckPeriodMs && this.chatHandlerNumRetries == that.chatHandlerNumRetries && this.maxNumSegmentsToMerge == that.maxNumSegmentsToMerge && this.totalNumMergeTasks == that.totalNumMergeTasks && this.maxAllowedLockCount == that.maxAllowedLockCount && Objects.equals(this.splitHintSpec, that.splitHintSpec) && Objects.equals(this.chatHandlerTimeout, that.chatHandlerTimeout);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.splitHintSpec, this.maxNumConcurrentSubTasks, this.maxRetry, this.taskStatusCheckPeriodMs, this.chatHandlerTimeout, this.chatHandlerNumRetries, this.maxNumSegmentsToMerge, this.totalNumMergeTasks, this.maxAllowedLockCount);
    }

    @Override
    public String toString() {
        return "ParallelIndexTuningConfig{splitHintSpec=" + this.splitHintSpec + ", maxNumConcurrentSubTasks=" + this.maxNumConcurrentSubTasks + ", maxRetry=" + this.maxRetry + ", taskStatusCheckPeriodMs=" + this.taskStatusCheckPeriodMs + ", chatHandlerTimeout=" + this.chatHandlerTimeout + ", chatHandlerNumRetries=" + this.chatHandlerNumRetries + ", maxNumSegmentsToMerge=" + this.maxNumSegmentsToMerge + ", totalNumMergeTasks=" + this.totalNumMergeTasks + ", maxAllowedLockCount=" + this.maxAllowedLockCount + "} " + super.toString();
    }
}

