/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.BatchAppenderators;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.InputSourceProcessor;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.worker.shuffle.ShuffleDataSegmentPusher;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.RealtimeMetricsMonitor;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CircularBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

abstract class PartialSegmentGenerateTask<T extends GeneratedPartitionsReport>
extends PerfectRollupWorkerTask {
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;
    private final IndexTaskInputRowIteratorBuilder inputRowIteratorBuilder;
    private @MonotonicNonNull RowIngestionMeters buildSegmentsMeters;
    private @MonotonicNonNull ParseExceptionHandler parseExceptionHandler;

    PartialSegmentGenerateTask(String id, String groupId, TaskResource taskResource, String supervisorTaskId, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, IndexTaskInputRowIteratorBuilder inputRowIteratorBuilder) {
        super(id, groupId, taskResource, ingestionSchema.getDataSchema(), ingestionSchema.getTuningConfig(), context, supervisorTaskId);
        Preconditions.checkArgument((!ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals().isEmpty() ? 1 : 0) != 0, (Object)"Missing intervals in granularitySpec");
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.inputRowIteratorBuilder = inputRowIteratorBuilder;
    }

    @Override
    public final TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(toolbox);
        ParallelIndexSupervisorTaskClient taskClient = toolbox.getSupervisorTaskClientProvider().build(this.supervisorTaskId, this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        List<DataSegment> segments = this.generateSegments(toolbox, taskClient, inputSource, toolbox.getIndexingTmpDir());
        Map<String, TaskReport> taskReport = this.getTaskCompletionReports();
        taskClient.report((SubTaskReport)this.createGeneratedPartitionsReport(toolbox, segments, taskReport));
        return TaskStatus.success((String)this.getId());
    }

    abstract SegmentAllocatorForBatch createSegmentAllocator(TaskToolbox var1, ParallelIndexSupervisorTaskClient var2) throws IOException;

    abstract T createGeneratedPartitionsReport(TaskToolbox var1, List<DataSegment> var2, Map<String, TaskReport> var3);

    private List<DataSegment> generateSegments(TaskToolbox toolbox, ParallelIndexSupervisorTaskClient taskClient, InputSource inputSource, File tmpDir) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        DataSchema dataSchema = this.ingestionSchema.getDataSchema();
        FireDepartment fireDepartmentForMetrics = new FireDepartment(dataSchema, new RealtimeIOConfig(null, null), null);
        FireDepartmentMetrics fireDepartmentMetrics = fireDepartmentForMetrics.getMetrics();
        this.buildSegmentsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
        RealtimeMetricsMonitor metricsMonitor = new RealtimeMetricsMonitor(Collections.singletonList(fireDepartmentForMetrics), Collections.singletonMap("taskId", new String[]{this.getId()}));
        toolbox.addMonitor((Monitor)metricsMonitor);
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        PartitionsSpec partitionsSpec = tuningConfig.getGivenOrDefaultPartitionsSpec();
        long pushTimeout = tuningConfig.getPushTimeout();
        SegmentAllocatorForBatch segmentAllocator = this.createSegmentAllocator(toolbox, taskClient);
        SequenceNameFunction sequenceNameFunction = segmentAllocator.getSequenceNameFunction();
        this.parseExceptionHandler = new ParseExceptionHandler(this.buildSegmentsMeters, tuningConfig.isLogParseExceptions(), tuningConfig.getMaxParseExceptions(), tuningConfig.getMaxSavedParseExceptions());
        boolean useMaxMemoryEstimates = this.getContextValue("useMaxMemoryEstimates", false);
        Appenderator appenderator = BatchAppenderators.newAppenderator(this.getId(), toolbox.getAppenderatorsManager(), fireDepartmentMetrics, toolbox, dataSchema, tuningConfig, new ShuffleDataSegmentPusher(this.supervisorTaskId, this.getId(), toolbox.getIntermediaryDataManager()), this.buildSegmentsMeters, this.parseExceptionHandler, useMaxMemoryEstimates);
        boolean exceptionOccurred = false;
        try {
            List list;
            block13: {
                BatchAppenderatorDriver driver = BatchAppenderators.newDriver(appenderator, toolbox, segmentAllocator);
                try {
                    driver.startJob();
                    SegmentsAndCommitMetadata pushed = InputSourceProcessor.process(dataSchema, driver, partitionsSpec, inputSource, inputSource.needsFormat() ? ParallelIndexSupervisorTask.getInputFormat(this.ingestionSchema) : null, tmpDir, sequenceNameFunction, this.inputRowIteratorBuilder, this.buildSegmentsMeters, this.parseExceptionHandler, pushTimeout);
                    list = pushed.getSegments();
                    if (driver == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (driver != null) {
                            try {
                                driver.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        exceptionOccurred = true;
                        throw e;
                    }
                }
                driver.close();
            }
            return list;
        }
        finally {
            if (exceptionOccurred) {
                appenderator.closeNow();
            } else {
                appenderator.close();
            }
            toolbox.removeMonitor((Monitor)metricsMonitor);
        }
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(IngestionState.COMPLETED, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), "", false, this.segmentAvailabilityWaitTimeMs)));
    }

    private Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        List<ParseExceptionReport> parseExceptionMessages = IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.parseExceptionHandler.getSavedParseExceptionReports());
        if (parseExceptionMessages != null) {
            unparseableEventsMap.put("buildSegments", parseExceptionMessages);
        } else {
            unparseableEventsMap.put("buildSegments", ImmutableList.of());
        }
        return unparseableEventsMap;
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }
}

