/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.appenderator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class ActionBasedUsedSegmentChecker
implements UsedSegmentChecker {
    private final TaskActionClient taskActionClient;

    public ActionBasedUsedSegmentChecker(TaskActionClient taskActionClient) {
        this.taskActionClient = taskActionClient;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdWithShardSpec> segmentIds) throws IOException {
        TreeMap<String, Set> idsByDataSource = new TreeMap<String, Set>();
        for (SegmentIdWithShardSpec segmentId : segmentIds) {
            idsByDataSource.computeIfAbsent(segmentId.getDataSource(), i -> new HashSet()).add(segmentId.asSegmentId());
        }
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>();
        for (Map.Entry entry : idsByDataSource.entrySet()) {
            String dataSource = (String)entry.getKey();
            Set segmentIdsInDataSource = (Set)entry.getValue();
            List intervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform((Iterable)segmentIdsInDataSource, SegmentId::getInterval));
            Collection<DataSegment> usedSegmentsForIntervals = this.taskActionClient.submit(new RetrieveUsedSegmentsAction(dataSource, intervals));
            for (DataSegment segment : usedSegmentsForIntervals) {
                if (!segmentIdsInDataSource.contains(segment.getId())) continue;
                usedSegments.add(segment);
            }
        }
        return usedSegments;
    }
}

