/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.joda.time.Interval;

public class MarkSegmentsAsUnusedAction
implements TaskAction<Integer> {
    @JsonIgnore
    private final String dataSource;
    @JsonIgnore
    private final Interval interval;

    @JsonCreator
    public MarkSegmentsAsUnusedAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval) {
        this.dataSource = dataSource;
        this.interval = interval;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<Integer> getReturnTypeReference() {
        return new TypeReference<Integer>(){};
    }

    @Override
    public Integer perform(Task task, TaskActionToolbox toolbox) {
        int numMarked = toolbox.getIndexerMetadataStorageCoordinator().markSegmentsAsUnusedWithinInterval(this.dataSource, this.interval);
        return numMarked;
    }

    @Override
    public boolean isAudited() {
        return true;
    }
}

