/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;

public class SegmentMetadataUpdateAction
implements TaskAction<Void> {
    @JsonIgnore
    private final Set<DataSegment> segments;

    @JsonCreator
    public SegmentMetadataUpdateAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) {
        TaskLocks.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        try {
            toolbox.getTaskLockbox().doInCriticalSection(task, this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet()), CriticalAction.builder().onValidLocks(() -> {
                toolbox.getIndexerMetadataStorageCoordinator().updateSegmentMetadata(this.segments);
                return null;
            }).onInvalidLocks(() -> {
                throw new ISE("Some locks for task[%s] are already revoked", new Object[]{task.getId()});
            }).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, task);
        for (DataSegment segment : this.segments) {
            metricBuilder.setDimension("interval", (Object)segment.getInterval().toString());
            toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder.setMetric("segment/moved/bytes", (Number)segment.getSize()));
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "SegmentMetadataUpdateAction{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + '}';
    }
}

