/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;

public class SegmentTransactionalAppendAction
implements TaskAction<SegmentPublishResult> {
    private final Set<DataSegment> segments;
    @Nullable
    private final DataSourceMetadata startMetadata;
    @Nullable
    private final DataSourceMetadata endMetadata;

    public static SegmentTransactionalAppendAction forSegments(Set<DataSegment> segments) {
        return new SegmentTransactionalAppendAction(segments, null, null);
    }

    public static SegmentTransactionalAppendAction forSegmentsAndMetadata(Set<DataSegment> segments, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) {
        return new SegmentTransactionalAppendAction(segments, startMetadata, endMetadata);
    }

    @JsonCreator
    private SegmentTransactionalAppendAction(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="startMetadata") @Nullable DataSourceMetadata startMetadata, @JsonProperty(value="endMetadata") @Nullable DataSourceMetadata endMetadata) {
        this.segments = segments;
        this.startMetadata = startMetadata;
        this.endMetadata = endMetadata;
        if (startMetadata == null && endMetadata != null || startMetadata != null && endMetadata == null) {
            throw InvalidInput.exception((String)"startMetadata and endMetadata must either be both null or both non-null.", (Object[])new Object[0]);
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    @Nullable
    public DataSourceMetadata getStartMetadata() {
        return this.startMetadata;
    }

    @JsonProperty
    @Nullable
    public DataSourceMetadata getEndMetadata() {
        return this.endMetadata;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) {
        SegmentPublishResult retVal;
        List<TaskLock> locks = toolbox.getTaskLockbox().findLocksForTask(task);
        for (TaskLock lock : locks) {
            if (lock.getType() == TaskLockType.APPEND) continue;
            throw InvalidInput.exception((String)"Cannot use action[%s] for task[%s] as it is holding a lock of type[%s] instead of [APPEND].", (Object[])new Object[]{"SegmentTransactionalAppendAction", task.getId(), lock.getType()});
        }
        TaskLocks.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        String datasource = task.getDataSource();
        Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock = TaskLocks.findReplaceLocksCoveringSegments(datasource, toolbox.getTaskLockbox(), this.segments);
        CriticalAction.Action<SegmentPublishResult> publishAction = this.startMetadata == null ? () -> toolbox.getIndexerMetadataStorageCoordinator().commitAppendSegments(this.segments, segmentToReplaceLock) : () -> toolbox.getIndexerMetadataStorageCoordinator().commitAppendSegmentsAndMetadata(this.segments, segmentToReplaceLock, this.startMetadata, this.endMetadata);
        try {
            retVal = toolbox.getTaskLockbox().doInCriticalSection(task, this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet()), CriticalAction.builder().onValidLocks(publishAction).onInvalidLocks(() -> SegmentPublishResult.fail((String)"Invalid task locks. Maybe they are revoked by a higher priority task. Please check the overlord log for details.")).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IndexTaskUtils.emitSegmentPublishMetrics(retVal, task, toolbox);
        return retVal;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "SegmentTransactionalAppendAction{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + '}';
    }
}

